/*C4*/
//****************************************************************
//	Author:	Jethro Wright, III 			TS :  1/20/1994 18:50
//	Date:	01/1/1994
//
//			cdrom.hpp :
//
//	History:
//		01/1/1994   jw3	 also sprach zarathustra....
//****************************************************************/


#if			! defined( __CDROM_HPP__ )
#define		 __CDROM_HPP__

#define		NO_EXT_KEYS
#define		_DOSERROR_DEFINED


			//	various options for FormatDuration() and ComputeDuration()
			//	these must retain the indicated order for FormatDuration()
			//	to operate correctly....

#define		TRACK_TIME		1			// == time for desired track
#define		REM_DISK_TIME	2			// == time remaining on disk
#define		TOTAL_TIME		4			// == total disk time

#if		! defined( _PRVW_LGTH )

#define		_PRVW_LGTH		20			// == lgth of an track preview in secs
										//	the preview's duration must be
										//	no more than 60 secs.  the logic
										//	that deals w/ this parameter
										//	doesn't do extensive checking, so
										//	boundary conditions near zero, may
										//	fail and the preview hangs waiting
										//	for a key, w/o starting the next
										//	preview....

#endif

			//	cd-rom sector addressing types

enum {
		ADDR_HSG,						// == high-sierra group addressing
		ADDR_RED						// == audio cd (red book) addressing
} ;


		//	potential mscdex errors encoded into the ioctl request status
		//	word....

enum {
		ERROR_UNKWN_UNIT = 1,
		ERROR_DRIVE_NOT_RDY,
		ERROR_UNKWN_CMD,
		ERROR_BAD_REQ_HDR = 5,
		ERROR_SEEK,
		ERROR_UNKWN_MEDIA,
		ERROR_SECT_NOT_FND,
		ERROR_READ_FAULT = 0x0b,
		ERROR_GEN_FAILURE,
		ERROR_BAD_DISK_CHG = 0x0f
} ;


/****************************************************************

	the CDRom class
		
		please note that despite the fact that the device table
		is set to support 26 cdrom drives, this hasn't been tested
		and may not even be completely implemented, so be on
		guard....

*****************************************************************/


class CDRom {

	private:
		static int	nbrOfDrives,		// how many drives there are
					firstLetter,		// == the 1st cdrom drive letter
					version, 			// == the mscdex version is only
										//	valid after mscdex 2.0
					isPresent ;			// is the mscdex driver alive ?

	public:
		static int	InitClass( void ) ;		// must be called before the
											//	1st use of the cstor.  is
											//	only to be used once during
											//	a user session....

		//	could also use another static fn to return a list of drive
		//	letters, so that in the instance of systems w/ more than one
		//	cdrom drive connected, the consumer can present the user w/
		//	a list of drive letters from which a choice would be made,
		//	but that's why the source code is included w/ the kit....

		//	the cstor defalts to the 1st connected cd
		CDRom( int cdDrive = 0 ) ;
		~CDRom( void ) ;					// don't really need an
											//  explicitly decl'd dstor for
											//  the moment....

		int 		ReadTOC( void ) ;
		void 		PrintTOC( void ) ;		// only applicable under dos
		int			PlayTrack( int ) ;
		int			PlayDisk( int ) ;
		void		PlayPreview( void ) ;
		void 		CloseTray( void ) ;
		void 		LockDoor( int ) ;
		void		Eject( void ) ;
		void		Reset( void ) ;
		int			GetUPC( DWORD far * ) ;
		void		GetPlayStatus( WORD far *, DWORD far *, DWORD far * ) ;
		Boolean		IsItPlaying( void ) ;	// poll the drive's q-channel
		void		GetTimeRemaining( int far *, int far *, int far *, 
									  int far * ) ;
		void		GetDiskInfo( int far *, int far * ) ;
		void		GetTrackInfo( int, int far *, int far * ) ;
		int			GetQInfo( DWORD far *, DWORD far *, DWORD far * ) ;
		void		PrintQInfo( DWORD, DWORD, DWORD ) ;
		void		Stop( Boolean fStop = 1 ) ;
		DWORD		GetDeviceStatus( void ) ;
		void		PrintPlayStatus( DWORD, DWORD ) ;

		inline int	GetVersion( void ) {
			return( CDRom::version ) ;	// returns version of mscdex
		} ;

		inline int	GetNbrOfDrives( void ) {
			return( CDRom::nbrOfDrives ) ;
		} ;

		inline Boolean 	IsBusy() {
			return( lastStatus & IOS_BUSY ) ;
		} ;

		inline int IsTrayOpen( void ) {
			return(	GetDeviceStatus() & STATUS_DOOR_OPEN ? 1 : 0 ) ;
		} ;

		inline int IsTrayLocked( void ) {
			return(	GetDeviceStatus() & STATUS_DOOR_UNLOCKED ? 0 : 1 ) ;
		} ;

		inline int	IsCookedAndRaw( void ) {
			return( GetDeviceStatus() & STATUS_COOKED_RAW_READS ? 1 : 0 ) ;
		} ;

		inline int	IsDiskInDrive( void ) {
			return ( GetDeviceStatus() & STATUS_NO_DISK ? 0 : 1 ) ;
		} ;

		//	get the i/o status from the last operation (cdrom command)
		inline WORD	GetIOS( void ) {
			return( lastStatus ) ;
		} ;

		inline WORD	GetErrorCode() {
			return( lastStatus & 0xff ) ;
		} ;

	private:
		int			cdDriveNbr ;		// == the drive to be used by this
										//	object relative to the list of
										//	device hdrs found in the Present()
										//	mbr fn....
		int			lastStatus ;		// the status word read from last
										//  use of the cdmInterface
		IOCTL		cmdInterface ;		// the actual system interface to the
										//  cd-rom....
		DiskInfoCmd	diskInfo ;			// current CD's information
		TrackInfoCmd  trackInfo[ 99 + 1 ] ;	// info on each track
		DeviceStatusCmd devStat ;		// current device status

		int			Play( DWORD, DWORD, BYTE ) ;
		DWORD		RedToHsg( DWORD ) ;
		void		DisplayAddress( Str255, DWORD ) ;
		void		FormatDuration( int, WORD, Str80 ) ;
		void		ComputeDuration( int, WORD, int far *, int far * ) ;
		void		ComputeSpan( DWORD, DWORD, int far *, int far * ) ;

} ;

#endif									// #if ! defined( __CDROM_HPP__ )
