/*C4*/
/****************************************************************/
/*	Author:	Jethro Wright, III 			TS :  1/18/1994  0:38	*/
/*	Date:	01/01/1994											*/
/*			device.h :											*/
/*																*/
/*	History:													*/
/*		01/01/1994  jw3  also sprach zarathustra....			*/
/****************************************************************/


#if			! defined( __DEVICE_H__ )
#define		__DEVICE_H__


			//
			//	the device data structures describing run-time
			//	access to cdroms....
			//

struct DeviceHeader {
	struct DeviceHeader far * nextDeviceHeader ;
	WORD 	deviceAttributes ;
	VFunc	deviceStrat ;
	VFunc	deviceEntry ;
	BYTE	deviceName[ 8 ] ;
	WORD	reserved ;
	BYTE	driveLetter ;
	BYTE	numberUnits ;
} ;

struct DeviceList {
	BYTE	subUnit ;
	struct	DeviceHeader far * deviceAddress ;
} ;


			//	this is the principal part of the ioctl cmd interface
			//	structure, thru which all cmds are to be xferred to the
			//	cdrom driver....

struct RequestHeader {
	BYTE	len ;						// == lgth of the total pkg of which
										//	the RequestHeader is only a part
	BYTE	unit ;						// the unit nbr of the target device 
	BYTE	command ;					// the primary cmd to be performed
										//	in the case of audio cds, it's
										//	usu an ioctl read or a write cmd
	WORD	status ;					// the target device status following
										//	the cmd
	BYTE	reserved[ 8 ] ;
} ;


struct IOCTLSvcReq {
	struct		RequestHeader rqh ;
	BYTE 		media ;
	void  		far * xferBufr ;
	WORD		byteCnt ;
	WORD		sector ;
	BYTE 		far * volumeId ;
} ;


/*****************************************************************

	the following structures are used to communicate w/ the actual
	cdrom device driver, thru the IOCTL class.  however, certain
	CDRom mbr fns use these structures to extract the information
	needed to carry out their tasks....

*****************************************************************/


		//	the play audio cmd is unique bec of the layout of its ioctl
		//	packet
struct PlayCommand {
	RequestHeader	rqh ;
	BYTE			addressMode ;
	DWORD			startAddr ;
	DWORD			nbrSects ;
} ;

struct DoorLockCmd {
	BYTE	command ;
	BYTE	lockCode ;
} ;

struct CloseTrayCmd {
	BYTE	command ;
} ;

struct ResetCommand {
	BYTE	command ;
} ;

struct EjectCommand {
	BYTE	command ;
} ;

struct UPCCommand {
	BYTE	command ;
	BYTE	controlAddress ;
	BYTE	upc[ 7 ] ;
	BYTE	zero ;
	BYTE	aFrame ;
} ;

struct TrackInfoCmd {
	BYTE	command ;
	BYTE	trackNumber ;
	DWORD	startAddress ;
	BYTE	control ;
} ;

struct QChannelInfoCmd {
	BYTE	command ;
	BYTE	control ;
	BYTE	trackNumber ;
	BYTE	x ;
	BYTE	minute ;
	BYTE	second ;
	BYTE	frame ;
	BYTE	zero ;
	BYTE	pMin ;
	BYTE	pSec ;
	BYTE	pFrame ;
} ;

struct DiskInfoCmd {
	BYTE	command ;
	BYTE	lowTrackNumber ;
	BYTE	highTrackNumber ;
	DWORD	leadOut ;
} ;

struct DeviceStatusCmd {
	BYTE	command ;
	DWORD	deviceStatus ;
} ;

struct PlayStatusCmd {
	BYTE	command ;
	WORD	statusBits ;				// bit #0 == audio paused; the rest
										//  reserved....
	DWORD	startAddress ;				// == the starting and ending addrs
	DWORD	endAddress ;				//  of the last play/next resume
} ;


#endif
