/***************************************************************
File: FLAG.CPP                Copyright 1992 by Dlugosz Software
part of the CMDL package for command-line parsing
cmdl_flag class
This version may be used freely, with attribution.
***************************************************************/

#include "usual.h"
#include "cmdl.h"
#include "scanner.h"

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

bool cmdl_flag::scan (cmdlscan& s)
{
if (!prelude()) return FALSE;
switch (s.thischar()) {
   case '+':
      ++s;
      value= TRUE;
      return TRUE;
   case '-':
      ++s;
      value= FALSE;
      return TRUE;
   case '=':
      error= NoValue;
      return FALSE;
   default:
      value= TRUE;
      return TRUE;
   }
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void cmdl_flag::report_error()
{
switch (error) {
   case NoValue:
      foutput ("use:\n@ or @+ will turn on.\n@- will turn off.\n");
      break;
   default:
      cmdl::report_error();
   }
}

