/***************************************************************
File: HELP.CPP                Copyright 1992 by Dlugosz Software
part of the CMDL package for command-line parsing
cmdl_help class
This version may be used freely, with attribution.
***************************************************************/

#include "usual.h"
#include "cmdl.h"
#include "scanner.h"
#include <stdlib.h>

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

cmdl_help::cmdl_help()
:cmdl ('?',"display usage help (argument for help on a particular parameter)",valueoptional)
{}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

bool cmdl_help::scan (cmdlscan& s)
{
/* an input of -?name will display help just on `name'.  The idea is
   that you can have more detailed help somewhere, and this would
   print that.  For now, it just gives out the usage string.
*/
char* value= getvalue (s);
if (value) {  //display help on this parameter
   bool switch_only= FALSE;
   /* if I said  -?name  then help will be displayed for either
      name or -name.  If -?-name was given, then only -name will be matched. */
   if (value[0] == '-' || value[1] == '/') {
      switch_only= TRUE;
      value++;
      }
   bool onechar= value[1] == '\0';
   int count= 0;  //how many help matches were found
   for (cmdl* p= get_head();  p;  p=p->get_next()) {
      if (switch_only && p->iskeyword()) continue;
      if (!p->matchname(value)) continue;
      // if I got this far, p is pointing to the parameter I want help on
      p->foutput ("@ :");
      output (p->get_helpstring());
      output ("\n");
      // and keep going, in case there is more than one match
      count++;
      }
   if (count == 0) {
      //string did not match any parameters.  show help on help.
      output ("help argument did not match any parameters.\n");
      exit (3);
      }
   }
else show_usage();  //did not find anything.  Just show standard help.
exit (3);
return FALSE;  //never gets here
}
