/***************************************************************
File: REPORT.CPP              Copyright 1992 by Dlugosz Software
part of the CMDL package for command-line parsing
reporting and errors
This version may be used freely, with attribution.
***************************************************************/

#include "usual.h"
#include "cmdl.h"

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void cmdl::report_error()
{
/* default error printing member.  May be overridden in derived class. */
switch (error) {
   case Duplicate:
      foutput ("parameter @ cannot be specified more than once.\n");
      break;
   default:
      foutput ("parameter @ : undiagnised error\n");
   }
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void cmdl::output_name()
{
/* this virtual function outputs the name of the argument.  It is
   very general, handling everything that is built-in.  It can be
   overridded for special derived classes, though.  */
if (!iskeyword()) output ("-");
if (ischar())  output (cname);
else output (sname);
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void cmdl::foutput (const char* s)
{
/* formatted output.  any '@' in the string is replaced by the name
   of the parameter. */
char c;
while ((c=*s++) != '\0') {
   switch (c) {
      case '@': output_name();  break;
      default: output (c);  break;
      }
   }
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void cmdl::show_usage()
{
/* simple usage report.  Shows each parameter and its usage string */
output (signon_string);
for (cmdl* p= head;  p;  p=p->next) {
   if (p->flags & noname) continue;  //don't report these (yet?)
   p->foutput ("@ :");
   output (p->helpstring);
   output ("\n");
   }
}

