/***************************************************************
File: SCANNER.CPP             Copyright 1992 by Dlugosz Software
part of the CMDL package for command-line parsing
the scanner class, used as part of parsing the strings.
This version may be used freely, with attribution.
***************************************************************/

#include "usual.h"
#include "cmdl.h"
#include "scanner.h"
#include <stdio.h>
#include <string.h>

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

cmdlscan::cmdlscan (char* s)
: s (s)
{
link= 0;   // the root entry
source= 0; // came from nowhere
cursor= 0; // always start at the beginning of the string
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

inline bool isws (char c)
{
return c==' ' || c=='\t';
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void cmdlscan::skipws()
{  // stands for Skip Whitespace, in case you did not figure it out.
while (isws(s[cursor])) cursor++;
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void cmdlscan::extract_word (char* buf, int len)
{   // copy letters from string, until it reaches a blank or '='.
len--;  //leave room for trailing nul
for (;;) {
   char ch= s[cursor];
   if (ch == '\n' || ch == '\0' || ch == ' ' || ch == '\t' || ch == '=') break;  //the end
   *buf++ = ch;
   len--;
   cursor++;
   if (len == 0) break;  //quit now anyway.  out of room.
   }
*buf= '\0';
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

char* cmdlscan::extract_string()
{
const bufsize= 128;
char buf[1+bufsize];
int pos= 0;
char close= '\0';  //char used to delimit string (optional)
char ch= s[cursor];
if (ch == '"' || ch == '\'') {  //look for quotes...
   close= ch;                   //...and remember what close quote will be.
   ++s;
   }
for (;;) {
   ch= s[cursor];
   if (ch == '\0') break;
   if (close) { //looking for closing quote
      if (ch == close) {
         cursor++;
         break;
         }
      }
   else { //looking for whitespace
      if (ch == '\n' || ch == '\0' || ch == ' ' || ch == '\t') break;
      }
   buf[pos++] = ch;
   cursor++;
   if (pos == bufsize) break;  //quit now anyway.  out of room.
   }
buf[pos]= '\0';
char* result= new char [1+strlen(buf)];
strcpy (result, buf);
return result;
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */
