; ASMDLL.ASM, DLLPower v2.12 Example.
; Copyright (c) 1996, Tony Toole
; Simple assembler program to demonstrate how to write DLLs in assembly
; Requires WASM to compile
;
; Exported functions provided:
; proc PrintHi_  (void PrintHi(char *))

.model flat
.386p

; Include standard run-time library (Required! even if you don't use it!)
includelib clib3r

.code

; Your main function for your DLL
public main_
main_ proc

  ; Save used registers
  push edx

  ; Display opening message
  mov ah, 9h
  mov edx, offset StartMsg
  int 21h

  ; Pop old registers.
  pop edx

  ; Set return value to 0 and return.
  mov eax, 0
  ret
main_ endp

; This is the closing function for your DLL
public dllexit_
dllexit_ proc
  ; Push used registers
  push edx

  ; Display closing message
  mov ah, 9h
  mov edx, offset ExitMsg
  int 21h

  ; Pop saved registers and return
  pop edx
  ret
dllexit_ endp

; This function is going to be exported...
public PrintHi_
PrintHi_ proc
  ; Push used registers
  push edx
  push ebx

  ; Keep a copy of parameter 1 (char *)
  mov ebx, eax

  ; Display first part of message
  mov ah, 9h
  mov edx, offset HiMsg1
  int 21h

  ; Display your message
  mov ah, 9h
  mov edx, ebx
  int 21h

  ; Display closing ']'
  mov ah, 9h
  mov edx, offset HiMsg2
  int 21h

  ; Pop saved registeres and return
  pop ebx
  pop edx
  ret
PrintHi_ endp

.data
 HiMsg1:   db "Hello world from a DLL [$"
 HiMsg2:   db "]", 10, 13, "$"
 StartMsg: db "ASMDLL.ASM Starting up...",   10, 13, "$"
 ExitMsg:  db "ASMDLL.ASM Shutting Down...", 10, 13, "$"
end

