/*
 * Stub Config v2.1, copyright(c) 1995, 1996 by Tony Toole.
 * Feel free to alter for your own stubs..
 */
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <graph.h>
#include <ctype.h>

struct ExeStub
{
  char ID[6];
  char DLLPath[128];
  char VirtualSet;
  long VirtualMin;
  long VirtualMax;
  long VirtualSwapMin;
  long VirtualSwapInc;
  long VirtualSize;
  char VirtualName[128];
} Stub;

long StubRecPos = 0;

void ReadStubRec(char *Name)
{
  FILE *ap;
  long SeekPos = 1700;
  if((ap = fopen(Name, "rb")) == NULL)
  {
    printf("[STUBCFG]: Can't load \"%s\"\n", Name);
    exit(1);
  }
  while(1)
  {
    fseek(ap, SeekPos, SEEK_SET);
    fread(&Stub, sizeof(ExeStub), 1, ap);
    if(strncmp(Stub.ID, "STUBID", 6) == 0)
    {
      StubRecPos = SeekPos;
      fclose(ap);
      return;
    }
    SeekPos++;
    if(SeekPos == 40000)
    {
      printf("[STUBCFG]: Not a Worlds Without End EXE stub.\n");
      fclose(ap);
      exit(2);
    }
  }
}

void SaveStubRec(char *Name)
{
  FILE *ap;
  if((ap = fopen(Name, "rb+")) == NULL)
  {
    printf("[STUBCFG]: Can't reopen \"%s\"\n", Name);
    exit(1);
  }
  fseek(ap, StubRecPos, SEEK_SET);
  fwrite(&Stub, sizeof(ExeStub), 1, ap);
  fclose(ap);
}

void main(int argc, char *argv[])
{
  int Key;
  char Temp[128];
  setbuf(stdout, NULL);
  if(argc != 2)
  {
    printf("[STUBCFG]: Syntax is STUBCFG <executable.xxx>\n");
    exit(3);
  }

  ReadStubRec(argv[1]);
/*
  printf("VirtualMin     = %d\n", Stub.VirtualMin);
  printf("VirtualMax     = %d\n", Stub.VirtualMax);
  printf("VirtualName    = %s\n", Stub.VirtualName);
*/
  while(1)
  {
    _clearscreen(_GCLEARSCREEN);
    printf("Options:\n\n");
    printf("1) Set DLL search path.                    [%s]\n",  Stub.DLLPath);
    printf("2) Enable/Disable virtual memory.          [%s]\n",  Stub.VirtualSet ? "Enabled" : "Disabled");
    printf("3) Set virtual size.                       [%dK]\n", Stub.VirtualSize);
    printf("4) Set minimum virtual file size.          [%dK]\n", Stub.VirtualSwapMin);
    printf("5) Set increment rate of virtual file.     [%dK]\n", Stub.VirtualSwapInc);
    printf("6) Set the minimum amount of RAM required. [%dK]\n", Stub.VirtualMin);
    printf("7) Set the maximum amount of RAM used.     [%dK]\n", Stub.VirtualMax);
    printf("8) Set virtual swapfile name.              [%s]\n",  Stub.VirtualName);
    printf("Q) Quit.\n");
    printf("\n");
    printf("Please choose an option: ");
    Key = toupper(getch());
    printf("%c\n", Key);
    if(Key == 'Q')
    {
      printf("Do you wish to save changes? ");
      Key = toupper(getch());
      printf("%c\n", Key);
      if(Key == 'Y') SaveStubRec(argv[1]);
      exit(0);
    }
    if(Key == '1')
    {
      printf("Please enter the DLL search path: ");
      gets(Stub.DLLPath);
    }
    if(Key == '2')
    {
      Stub.VirtualSet ^= 1;
    }
    if(Key == '3')
    {
      printf("Please enter the virtual file size: ");
      gets(Temp);
      Stub.VirtualSize = atoi(Temp);
    }
    if(Key == '4')
    {
      printf("Please enter the starting size of the virtal file: ");
      gets(Temp);
      Stub.VirtualSwapMin = atoi(Temp);
    }
    if(Key == '5')
    {
      printf("Please enter the increment rate of the virtual file: ");
      gets(Temp);
      Stub.VirtualSwapInc = atoi(Temp);
    }
    if(Key == '6')
    {
      printf("Please enter the minimum RAM requirement: ");
      gets(Temp);
      Stub.VirtualMin = atoi(Temp);
    }
    if(Key == '7')
    {
      printf("Please enter the maximim amount of RAM used: ");
      gets(Temp);
      Stub.VirtualMax = atoi(Temp);
    }
    if(Key == '8')
    {
      printf("Please enter the name of the virtual file: ");
      gets(Stub.VirtualName);
    }
  }
}














