Quake-Simulator Version 1.0


                      Source Code Description


I recommend reading EQDAMAGE.TEX before reading this document.


GENDISP.CPP -

Generates the earthquake displacement.

Variables:

      waveletn - Number of wavelets in the displacement wave (Number of
		 monochromatic waves added together to make the
		 wave)

      maxt     - The maximum time that the earthquake displacement is going
		 to be gotten for (Needed to make a non-repetative wave)

      fract_dim - The fractal dimension. Used in the spectrum() function.

      intensity - The earthquake intensity. (For Richter scale intensity
		  is 10 to the Richter Scale Intensity power, so for a 2.5
		  on the richter scale intensity is 10 to the 2.5th power)

      offset    - An array of random phases for the wave.

      steps     - An array of steps.

      spectrand - An array of randum number for use with the spectrum()
		  function.

Functions:

      init_globals() - Initializes the global variables

      done_globals() - Destroys the pointers allocated in init_globals()

      dblrand()      - Since there is no floating point random function
		       in Turbo C++, I had to write my own.

      spectrum()     - The fractal part of the program. Read eqdamage.tex
		       to understand it.

      disp()         - Calculates the displacement for a certain time.


EARTHQUAKE.CPP -

Generates the building movement and the graphics.

Defines:
      WAVELET_NUM  - The number of wavelets (Explained in earlier section).

      DELTA_OMEGA  - Same as step[0] in earlier section.

      FRACTAL_DIM  - Same as fract_dim in earlier section.

      DELAY        - The computer delay for active and hybrid control
		     (See eqdamage.tex)

      CONTROL_NORMAL - The normal control coefficient (See eqdamage.tex)

      HYBRID_SPOINT  - The hybrid control switch point (See eqdamage.tex)

      FELASTIC       - The elastic coefficient (See eqdamage.tex)

      FFRICTION      - The friction coefficient (See eqdamage.tex)

      TSTEP          - The time step, i.e. how much the previous time is
		       incremented by to get the current time.

      SNUM           - The number of time steps.

      BMASS          - The building's mass.

      MAGNIFICATION  - The magnification of the earthquake displacement
		       (For the graphics)

Variables:

      blmov          - An array of building movement complete with:
		       force, accelaration, velocity, x movement, and
		       energy used for each element;

      felastic_cos   - The stored coefficient for elasticity.

      ffriction_cos  - The stored coefficient for friction.

      tstep          - The stored time step.

      snum           - The stored number of time steps.

      bmass          - The stored building mass.

Functions:

      no_cntrl()     - No control. Always returns 0.0

      active_cntrl() - The active control function.

      hybrid_cntrl() - The hybrid control function.

      execute_cntrl() - Executes a control function if the conditions are
			right. Otherwise returns 0.0

      init_qglobals() - Inits the quake's global variables and the
			building movement's global variables

      init_gen_qglobals() - Inits the building movement's global variables

      done_qglobals() - Destructs the quake's global variables and the
			building movement's global variables

      done_gen_qglobals() - Destructs the building movement's global variables

      gen_blmov()     - Generates the building movement array.

      plot_blmov()    - Plots the building movement array on the screen.

      plot_disp()     - Plots the displacement on the screen.

      total_blmov()   - Returns the sum of all of the x movements

      max_blmov()     - Returns the greatest x movement

      total_eused()   - Returns the sum of all of the energy used

      show_control()  - Displays the earthquake displacement,
			x movement, and other graphics for a certain
			control function

      select_intensity() - Asks the user to select a new intensity.

