#ifndef _file_itr_h_included
#define _file_itr_h_included    // Prevent multiple includes
//******************************************************************************
//
//								  File Iterator
//								  (FILE_ITR.H)
//
//	PURPOSE:	Used to find all instances of a file specification, within
//				a subdirectory tree. (e.g. Given the file spec,
//				"h:\bcc\O*.HLP", the full path of all help files, that
//				start with the letter 'O' are retrieved.)
//
//
//	  Date		Revision History
//	--------	------------------------------------------------------------
//	 4-30-95	Initial draft of FileIterator.
//	 5- 2-95	Added the operator, (long *), which returns the file's size.
//
//******************************************************************************

//------------------------------- HEADER FILES ---------------------------------

#include	<dir.h>			//  ffblk,
							//	MAXDIR, MAXDRIVE, MAXEXT, MAXFILE, MAXPATH
#include	<stdlib.h>		//  size_t
#include	<string.h>		//  strcpy()
#include	<windows.h>		//  BOOL, TRUE
#include	<_defs.h>		//  _CLASSTYPE()

#include	<arrays.h>		//  TArrayAsVector

//---------------------------- FORWARD DECLARATIONS ----------------------------

//--------------------------------- CONSTANTS ----------------------------------

char const NUL          = '\0';
size_t const MaxFileLen = MAXFILE + MAXEXT;
size_t const MaxPathLen = MAXDRIVE + MAXDIR;

//---------------------------- TYPE DECLARATIONS -------------------------------

//-------------------------- FUNCTION DECLARATIONS -----------------------------

//---------------------------- CLASS DECLARATIONS ------------------------------
//
//

class Subdir
{
public:
	char	FachName[MaxPathLen];

    Subdir& operator= ( const Subdir& AsItem )
	{
		strcpy( FachName, AsItem.FachName );
		return (*this);
	}
    int operator ==( const Subdir& AsItem ) const	{   return (0); }
    int operator < ( const Subdir& AsItem ) const	{   return (0); }
};

typedef TArrayAsVector<Subdir>	SubdirectoryTree;

class _CLASSTYPE FileIterator
{
public:

    //----------------------------------------------------------
    //      Constructors.
    //

	FileIterator( void );
	FileIterator( const char *ApszFileSpec, BOOL AbRecurseSubdirs = TRUE );


    //----------------------------------------------------------
    //      Destructor.
    //

	~FileIterator( void );


    //----------------------------------------------------------
    //      An alternative method for setting the file-to-be-
    //      searched-for specification.
    //

	BOOL	SetFileSpec( const char *ApszFileSpec,
						 BOOL AbRecurseSubdirs = TRUE );


    //----------------------------------------------------------
    //      Typical for() usuage:
    //
    //          char            *pszDataFile;
    //          FileIterator    FileSearch( "*.dat" );
    //
    //          for (FileSearch.FirstFile();
    //               FileSearch.MoreFiles();
    //               FileSearch.NextFile())
    //          {
    //              pszDataFile = FileSearch;
    //
    //              //  process the data file
    //          }
    //

    void    FirstFile( void );
    BOOL    MoreFiles( void ) const		{	return (FbMoreFiles);	}
    void    NextFile( void );

    operator long() const;			//	File size
    operator char *() const;		//	File name


protected:

	unsigned			FuCurrentDir;
	BOOL				FbMoreFiles;
    ffblk				FfblkFileInfo;


private:

    char				FachFileSpec[MaxFileLen];
    char				FachFileName[MAXPATH];
	SubdirectoryTree	*FpaDirectoryList;

	void	BuildSubdirectoryTree( const char *ApszFullSubdir );
	void	FindNextSubdirectory( void );
};

#endif

