	// cbdrdem2.cpp
	// Demo CBinder defaulting to C strings!
	// Link with binder.obj, sbinder.obj, cbinder.obj
	
	#include <fstream.h>
	#include <iomanip.h>
	#include "cbinder.hpp"

	#define ID_CBDR_STRCMP  1

	#pragma argsused
	void display1(char * D, voiD M, int * A)
	{
		int i = strlen((char *)D);


		*A += i;
		cout << "length: " << setw(3) << i
			<< "   accumulated length: "
			<< setw(3)
			<< *A << "   string: "
			<< D << "\n";

	}

	void display2(char * D, unsigned * M)
	{
		cout << "node: " << setw(3)
			<< ++*M
			<< "   contents: "
			<< D << "\n";
	}

	main()
	{
		CBinder B;

		CBinder::registerClass();

		B.pushCLN("Now is the time");
		B.insQCLN("for all programmers");
		B.insQCLN("");  // empty string should Q and stream!		
		B.atInsCLN(B.Nodes(),"to stop reinventing");
		B.insQCLN("the linked list!");
		B.insQCLN("");  // empty string should Q and stream!

		cout << "\n\nOverloaded ++ and typecast: "
			<< "operators \n\n";

		while (B++)
			cout << (char *)(voiD)B << "\n";

		cout << "\n\nOverloaded [] subscript"
			<< " operator \n\n";

		for (unsigned i = 0; i < B.Nodes(); i++)
			cout << (char *)B[i] << "\n";

		cout << "\n\npress enter to continue ...";
		cin.get();

		i = 0;

		cout << "\n\nForEach iterator \n\n";

		B.forEach((BDRforEachBlocK)display1,0,&i);

		cout << "\n\npress enter to continue ...";
		cin.get();

		B.setComparE((BDRcomparE)strcmp);
		
		B.link();

		RegisterFunction(ID_CBDR_STRCMP,
			(GenericFnC)B.ComparE());

		ofstream oS("cbdrdem2.txt");
		if (oS)  {
			oS << (StreamablE) B;
			B.restream();
			oS.close();
			ifstream iS("cbdrdem2.txt");
			if (iS)  {
				StreamablE C;
				iS >> C;
				iS.close();
				RestreamRegistry();
				if (C)
				{
				  cout << "\n\nStreamed and"
					<< " reloaded CBinder \n\n";
				  i = 0;
				  ((CBindeR)C)->forEach(
				  	(BDRforEachBlocK)
						display2,&i,0);
				  ((CBindeR)C)->sort();
				  cout << "\n\nStreamed and"
					<< " reloaded CBinder"
					<< " sorted on reloaded"
					<< " compare fnc! \n\n";
				  i = 0;
				  ((CBindeR)C)->forEach(
				  	(BDRforEachBlocK)
						display2,&i,0);
				  delete (CBindeR) C;
				}
				else
				  cout << "\n\nUnable to reload"
				    << " CBinder \n\n";
			}
			else
				cout << "\n\nUnable to reopen"
				  << " stream for input of"
				  << " of CBinder \n\n";
		}

		cout << "\n\npress enter to continue ...";
		cin.get();

		cout << "\n\nCBinder streamed directly to"
			<< " cout \n\n";

		cout << (StreamablE) B;
		B.restream();


		cout << "\n\npress enter to quit ...";
		cin.get();

		return 0;
	}
