/*

	cbinder.hpp
	10-18-91
	Copy Binder: Loose Data Binder v1.4

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef CBINDER_HPP
#define CBINDER_HPP

#ifndef SBINDER_HPP
#include "sbinder.hpp"
#endif

#include <string.h>

#define ID_CBinder	3

#define CBDR_STRING	0

class CBinder : public SBinder  {
	unsigned sizeofData;
	void construct(unsigned sizeofData)
		{ this->sizeofData = sizeofData; }
	// void destruct()  {}
protected:
	virtual int  Dfree(voiD D)
		{ return (D? delete D, 1 : 0); }
	virtual int  Dattach(voiD)
		{ return 1; }
	virtual void Ddetach(voiD)
		{ return; }
	virtual ostream& store(ostream& os);
	static  StreamablE load(istream& is,
		StreamablE InstancE);
	virtual void Dstore(ostream& os, const voiD D);
	virtual voiD Dload(istream& is);
	virtual voiD Dclone(const voiD D);
	virtual voiD Dcopy(voiD D, const voiD S);
public:
	enum { ID_CLASS = ID_CBinder };
	CBinder(StreamableClassRegistry& dummy,
		unsigned id = ID_CLASS) :
		SBinder(dummy,id) {}
	CBinder(unsigned sizeofData = CBDR_STRING,
		unsigned maxNodes = BDR_MAXNODES,
		unsigned limit = BDR_LIMIT,
		unsigned delta = BDR_DELTA);
	static void registerClass(unsigned id = ID_CLASS,
		StreamablE (*loader)(istream& is,
		StreamablE InstancE) = load)
		{ Streamable :: registerClass(id,loader); }
	virtual unsigned restream()
		{ return Streamable::restream(); }
	virtual ~CBinder() {}
	voiD atInsCLN(unsigned n, const voiD D);
	voiD atFreeCPY(unsigned n, voiD D);
	voiD atFreePutCLN(unsigned n, const voiD D);
	voiD atGetCPY(unsigned n, voiD D)
		{ return Dcopy(D,atGet(n)); }
	voiD topCPY(voiD D)  { return Dcopy(D,atGet(0)); }
	voiD currentCPY(voiD D)
		{ return Dcopy(D,atGet(CurNode())); }
	operator char *();
	voiD bottomCPY(voiD D)
		{ return Dcopy(D,atGet(Nodes()-1)); }
	voiD pushCLN(const voiD D);
	voiD popFreeCPY(voiD D);
	voiD insQCLN(const voiD D);
	voiD rmQFreeCPY(voiD D)  { return popFreeCPY(D); }
	voiD unQFreeCPY(voiD D);
	voiD insCLN(const voiD D);
	voiD insSortCLN(const voiD D);
	voiD delFreeCPY(voiD D);
	voiD nextCPY(voiD D);
	voiD prevCPY(voiD D);

};

typedef CBinder * CBindeR;


#endif

