	// sddem1.cpp
	// Demo Streamable Data
	// Link with binder.obj, sbinder.obj, and sdata.obj

	#include <string.h>
	#include <fstream.h>
	#include "sdata.hpp"

	#define DID_Int	2

	#define ID_SDATA_CMP  1



	// display integers and strings

	void display(SDatA N)
	{
		cout << endl << "DID: " << setw(6)
			<< N->DID()
			<< "  sizeofData: " << setw(6)
			<< N->SizeofData() << "  D:  ";
		switch (N->DID())  {
		case DID_Generic:
			cout << "unknown";
			break;
		case DID_String:
			cout << (char *)(voiD) * N;
			break;
		case DID_Int:
			cout << *(int *)(voiD) * N;
			break;
		}

	}


	// sort integers and strings

	int sdcmp(SDatA N1, SDatA N2)
	{
		// integers sorted to the front
		// strings sorted to the rear

		if (N1->DID() == DID_Generic)
			return 1;
		else if (N2->DID() == DID_Generic)
			return -1;
		if (N1->DID() == DID_Int)
			if (N2->DID() == DID_Int)
				return *(int *)(voiD)*N1
					- *(int *)(voiD)*N2;
			else
				return -1;
		else
			if (N2->DID() == DID_Int)
				return 1;
			else
				return strcmp((const char *)
					(voiD)*N1,
					(const char *)
					(voiD)*N2);
	}


	main()
	{
		SBinder::registerClass();
		SData::registerClass();


		SBinder B;

		B.push(new SData("Hello LDB!"));
		B.insQ(new SData("Goodbye linked"));
		B.insQ(new SData("list programming!"));
		B.insQ(B.bottom());
		B.insQ(new SData(
			"Line above tests multilinking!"));

		for (int i = 3; i; i--)
			B.insQ(new SData(&i,sizeof(i),
				DID_Int));

		cout << "\n\nBinder of streamable integers"
			<< " and strings!\n\n";

		B.forEach((BDRforEachBlocK)display);

		cout << "\n\nPress enter to continue ...";
		cin.get();


		B.setComparE((BDRcomparE)sdcmp);
		
		B.link();

		RegisterFunction(ID_SDATA_CMP,
			(GenericFnC)sdcmp);

		ofstream oS("sddem1.txt");
		if (oS)  {

		  oS << (StreamablE) B;

		  B.restream();

		  B.allFree();

		  // Don't stream B again
		  // without restreaming!!!

		  oS.close();
		  ifstream iS("sddem1.txt");
		  if (iS)  {

		    StreamablE C;

		    cout << "\nStreamed and "
			<< "reloaded Binder with "
			<< "multiple links maintained "
			<< "\nand sorted with streamed "
			<< "compare fnc, ints in front:"
			<< " \n";

		    iS >> C;
		    iS.close();

		    RestreamRegistry();

		    // Don't load again from
		    // any stream without
		    // restreaming!!!

		    if (C)
		    {
		      ((SBindeR)C)->sort();
		      ((SBindeR)C)->forEach(
			(BDRforEachBlocK)display);
		      delete (SBindeR) C;
		    }
		    else
		      cout << "\n\nUnable to reload"
			<< " Binder \n\n";
		  }
		  else
		    cout << "\n\nUnable to reopen"
		      << " stream for input of"
		      << " of Binder \n\n";
		}

		B.unlink();

		return 0;
	}
