/////////////////////////////////////////////
//
// easydemo.cpp
//
// A simple demo for the MenuPlus class
//
// Copyright 1995 Jeffrey A. Schierenbeck
//
/////////////////////////////////////////////

#include <conio.h>  \\ for input\output functions
#include <stdlib.h> \\ for NULL declaration
#include "menu.h"


item sampleitems[4] = { {"Option 1", '1'},
			{"Option 2", '2'},
			{"Option 3", '3'},
			{"Exit"    , 'E'} };

txmenu samplemenu(30,10,4,sampleitems,VERT,NULL);


main()
    {int done = 0;
     samplemenu.initialize();
     textbackground(BLUE);
     textcolor(YELLOW);
     _setcursortype(_NOCURSOR);
     clrscr();
     window(18,10,65,20);
     cputs("This demo provides a simple demonstration\r\n");
     cputs("of the MenuPlus C++ menu class.\r\n\n");
     cputs("Menu options may be selected with highlight\r\n");
     cputs("bar by using arrow keys and <ENTER> key, or\r\n");
     cputs("by clicking with left mouse button, or by\r\n");
     cputs("pressing key corresponding to 'hotkeys'.\r\n\n");
     cputs("       (Press any key to continue)");
     getch();
     gotoxy(1,9);
     clreol();

     window(1,1,80,25);
     while(!done)
	  {samplemenu.open();
	   char choice = samplemenu.getoption();
	   samplemenu.close();

	   gotoxy(26,20);
	   textcolor(WHITE);
	   textbackground(BLUE);
	   switch(choice)
		{case '1' : cputs(" Option One was selected.  ");
			    break;
		 case '2' : cputs(" Option Two was selected.  ");
			    break;
		 case '3' : cputs("Option Three was selected.");
			    break;
		 case 'E' : done = 1;
		};
	   if(done) break;
	   gotoxy(25,21);
	   cputs("(Press any key to continue)");
	   getch();
	   gotoxy(25,20);
	   clreol();
	   gotoxy(25,21);
	   clreol();
	  };
     _setcursortype(_NORMALCURSOR);
     textcolor(LIGHTGRAY);
     textbackground(BLACK);
     clrscr();
     return(0);
    };
