///////////////////////////////////////////////
//
//  grbox.h
//
//  declarations for grbox class
//
//  Copyright 1995 Jeffrey A. Schierenbeck
//
///////////////////////////////////////////////

#ifndef GRBOXdotH
#define GRBOXdotH

class grbox
    {private:
	void far *buffer; // for screen save/restore
	int backcolor;  // background color
	int left, top, right, bottom; // window coordinates
	int shadow; // 0 = OFF, 1 = ON
	int char_width, char_height;
     public:
	grbox(int l,int t, int r, int b, int bkcolor); // constructor
	void open(void);
	void close(void);
	void draw_border(int color, char *toptext, char *bottomtext);
	void wait(void);
	void setshadow(int onoff) {shadow = onoff;}; // 0 = OFF, 1 = ON
    };

#endif


#include <stdlib.h> // for malloc()
#include <graphics.h>
#include <alloc.h>
#include <stdio.h>

grbox::grbox(int l,int t, int r, int b, int bkcolor)
    {left = l;
     top = t;
     right = r;
     bottom = b;
     backcolor = bkcolor;
     shadow = 0; // OFF by default
     char_width = textwidth("X");
     char_height = textwidth("X");
    };


void grbox::open(void)
    {setviewport(0,0,getmaxx(),getmaxy(),1);
     int wasvis = mouse.Visible();
     mouse.Hide();
     unsigned size =imagesize(left,top,right+char_width,bottom+char_height);

     if((buffer = farmalloc(size)) == NULL)
	 {closegraph();
	  printf("Not enough memory in heap"); // save screen below window
	  exit(1);
	 };
     getimage(left,top,right+char_width,bottom+char_height,buffer);
     if(shadow)
	 {setcolor(BLACK);
	  setfillstyle(SOLID_FILL, BLACK);
	  int shadowbox[14] = {left+char_width, bottom+char_height,
			       right+char_width, bottom+char_height,
			       right+char_width, top+char_height,
			       right, top+char_height,
			       right, bottom,
			       left+char_width, bottom,
			       left+char_width, bottom+char_height};
	  fillpoly(7, shadowbox);
	 };
     setcolor(backcolor);
     rectangle(left,top,right,bottom);
     setfillstyle(SOLID_FILL, backcolor);
     floodfill(left+1,top+1,backcolor);
     if(wasvis)
	 mouse.Show();
    };


void grbox::close(void)
    {int wasvis = mouse.Visible();
     mouse.Hide();
     setviewport(0,0,getmaxx(),getmaxy(),1);
     putimage(left,top,buffer,COPY_PUT); // restore screen below box
     farfree(buffer);
     if(wasvis)
	 mouse.Show();
    };


void grbox::wait(void)  // wait for keypress or mouse
    {mouse.TimesPressed(LEFT);  // clear buffer
     mouse.TimesPressed(RIGHT);
     int done = 0;
     while(!done)
	 {if(mouse.Visible() &&
	      (mouse.TimesPressed(LEFT) || mouse.TimesPressed(RIGHT)))
			done=1;
	  else if(kbhit())
	       {getch();
		done = 1;
	       };
	 };
    };


void grbox::draw_border(int color, char* toptext, char* bottomtext)
	{int wasvis = mouse.Visible();
	 mouse.Hide();
	 setviewport(left,top,right,bottom,1);
	 setcolor(color);
	 settextjustify(CENTER_TEXT, CENTER_TEXT);
	 line(char_width,
	      char_height,
	      (right-left)/2-.5*textwidth(toptext),
	      char_height);
	 line((right-left)/2+.5*textwidth(toptext),
	      char_height,
	      (right-left)-char_width,
	      char_height);
	 line(char_width,
	      (bottom-top)-char_height,
	      (right-left)/2-.5*textwidth(bottomtext),
	      (bottom-top)-char_height);
	 line((right-left)/2+.5*textwidth(bottomtext),
	      (bottom-top)-char_height,
	      (right-left)-char_width,
	      (bottom-top)-char_height);
	 line(char_width,
	      char_height,
	      char_width,
	      (bottom-top)-char_height);
	 line((right-left)-char_width,
	      char_height,
	      (right-left)-char_width,
	      (bottom-top)-char_height);
	 outtextxy((right-left)/2,char_width, toptext);
	 outtextxy((right-left)/2,bottom-top-char_height, bottomtext);
	 setviewport(left+char_width,
		     top+char_height,
		     right-char_width,
		     bottom-char_height,1);
	 settextjustify(LEFT_TEXT, TOP_TEXT);
	 if(wasvis)
	     mouse.Show();
	};

// end grbox.h