///////////////////////////////////////////////
//
//  infobox.h
//
//  declarations for infobox class
//
//  Copyright 1995 Jeffrey A. Schierenbeck
//
///////////////////////////////////////////////

#ifndef INFOBOXdotH
#define INFOBOXdotH

class infobox
    {private:
	void *buffer; // for screen save/restore
	int backcolor;  // background color
	int left, top, right, bottom; // window coordinates
	int shadow; // 0 = OFF, 1 = ON
     public:
	infobox(int l,int t, int r, int b, int bkcolor); // constructor
	void open(void);
	void close(void);
	void draw_border(int color, char *toptext, char *bottomtext);
	void wait(void);
	void setshadow(int onoff) {shadow = onoff;}; // 0 = OFF, 1 = ON
    };


#include <conio.h> //for input/output
#include <stdlib.h> // for malloc()
#include <string.h> // for strlen()

infobox::infobox(int l,int t, int r, int b, int bkcolor)
    {left = l;
     top = t;
     right = r;
     bottom = b;
     backcolor = bkcolor;
     shadow = 1; // ON by default
    };


void infobox::open(void)
    {int wasvis = mouse.Visible();
     mouse.Hide();
     int size;                                  ///
     buffer = (char *)malloc(size);  		// save screen below window
     gettext(left,top,right+2,bottom+1,buffer); ///
     if(shadow)
	 {textbackground(BLACK);   		 ///
	  window(left+2,top+1,right+2,bottom+1); // shadow
	  clrscr();                		 ///
	 };
     textbackground(backcolor);     ///
     window(left,top,right,bottom); // text window
     clrscr();                      ///
     if(wasvis)
	mouse.Show();
    };


void infobox::close(void)
    {int wasvis = mouse.Visible();
     mouse.Hide();
     puttext(left,top,right+2,bottom+1,buffer); // restore screen
     free(buffer);
     window(1,1,80,25);
     if(wasvis)
	mouse.Show();
    };


void infobox::wait(void)  // wait for keypress or mouse
    {int done = 0;
     mouse.TimesPressed(LEFT); // clear buffer
     mouse.TimesPressed(RIGHT);
     while(!done)
	 {if(mouse.Visible() &&
	      (mouse.TimesPressed(LEFT) || mouse.TimesPressed(RIGHT)))
			done=1;
	  else if(kbhit())
	       {getch();
		done = 1;
	       };
	 };
    };


void infobox::draw_border(int color, char* toptext, char* bottomtext)
	{int wasvis = mouse.Visible();
	 mouse.Hide();
	 textcolor(color);
	 struct text_info ti;
	 int current_wscroll = _wscroll;
	 _wscroll = 0;     // set textwrap to same line
	 gettextinfo(&ti);
	 int width = ti.winright - ti.winleft;
	 int height = ti.winbottom - ti.wintop;

	 for(int c = 2; c < height+1; c++)
		{gotoxy(1,c);   // draw left edge
		 putch(186); // 
		 gotoxy(width+1,c);   // draw right edge
		 putch(186); // 
		};

	 for(c = 2; c < width+1; c++)
		{gotoxy(c,1);
		 putch(205); // 
		 gotoxy(c,height+1);
		 putch(205); // 
		};

	 gotoxy(1,1); putch(201); // 
	 gotoxy(width+1,1); putch(187); // 
	 gotoxy(1,height+1); putch(200); // 
	 gotoxy(width+1,height+1); putch(188); // 

	 gotoxy(width/2 - (strlen(toptext)/2-1), 1);
	 cputs(toptext);   // text in top border
	 gotoxy(width/2 - (strlen(bottomtext)/2-1), height+1);
	 cputs(bottomtext); // text in bottom border

	 gotoxy(1,1);
	 _wscroll = current_wscroll;  // return text wrap to default
	 window(left+2,top+1,right-2,bottom-1); // window inside border
	 textattr(ti.attribute);
	 if(wasvis)
	      mouse.Show();
	};

#endif
