/////////////////////////////////////////////
//
//  menu.h
//
//  declarations for menu, txmenu, & grmenu classes
//
//  Copyright 1995  Jeffrey A. Schierenbeck
//
/////////////////////////////////////////////

#ifndef MENUdotH
#define MENUdotH

#define ESC 27
enum Modes {TEXT, GRAPHICS};
enum Orientation {HORZ, VERT};
enum Borderstyles {NO_BORDER, SINGLE_LINE, DOUBLE_LINE};
enum Outerwidths {NONE, THIN, THICK};
enum Status {OFF, ON};
enum Boolean {FALSE, TRUE};
enum {RIGHT_ARROW = -3, LEFT_ARROW = -1};

struct item	      // item of menu (option)
      {char *name;        // name to appear in menu
       char hotkey;       // key to activate menu option
       Boolean active;
      };


class menu
      {protected:
	  int left, top, right, bottom;  // viewport/window coordinates
	  int back_color, text_color, border_color, hotkey_color,
		bar_color, inactive_text_color; // menu colors
	  Status shadow; // OFF or ON
	  Orientation orientation; // HORZ or VERT
	  Status lr_arrows; // left/right arrows active status for getoption
	  int border_style;
	  int outerwidth; // sets width of menu outside of items
	  int startpos; // default highlight pos @ menu opening
	  int current_pos; // current (highlighted) position in list
	  int char_width, char_height;  // character size parameters
	  int bar_height;  // height of highlight bar

	  int num_items;   // number of menu items
	  item *i_list; // array of items composing menu
	  int *hotpos;  // array of positions of hotkey in names
	  int *end; // for HORZ:  hold pos of menu block endpoints

	  Boolean opened; // menu display status
	  Boolean initialized; // menu initialization status

       public:
	  menu(int l, int t, int ni, item *list, Orientation orient,
					      void (*optionhandler)(char));
	  ~menu(void);
	  void setcolors(int newtext, int newborder, int newback,
			 int newhotkey, int newbar, int newinactive);
	  void setborderstyle(int newstyle);
	  void setopenpos(char hotkey); // set default highlight @ open
	  char getcurrentpos(void) {return i_list[current_pos].hotkey;};
	  int getrightcoord(void) {return right+outerwidth;};
	  int getbottomcoord(void) {return bottom+outerwidth;};
	  void shadowon(void) {shadow = ON;};
	  void shadowoff(void) {shadow = OFF;};
	  void makeactive(char hotkey);
	  void makeinactive(char hotkey);
	  void (*handler)(char);
	  void setlr_arrows(Status newstatus);
	  int isopened(void) {return opened;};
     };


class txmenu:public menu
     {private:
	  char *buffer; // for screen saving/restoring
	  int old_cursortype; // for cursor restoration at close
	  unsigned char old_textattr; // for text color/back restoration

	  void redisplay(int oldpos, int pos);
	  void draw_divider(int n); // writes divide line in vert menu
	  void draw_border(void); // draw border in text mode
      public:
	  txmenu(int l, int t, int ni, item *list, Orientation orient,
					      void (*optionhandler)(char));
	  void open(void);
	  void initialize(void);
	  char getoption(void);
	  char getoption(int mousex, int mousey);
	  char getoption(char cmd);
	  void setborderwidth(int newwidth);
	  void refresh(char=0, char=0);
	  void close(void);
     };


class grmenu:public menu
     {private:
	  void far *buffer;  // for screen saving/restoring
	  void redisplay(int oldpos, int pos); // highlight
	  void draw_divider(int n); // writes divide line in vert menu
	  void draw_border(void); // draw border in text mode
	  void item_outtext(int item_num); // to display menu text
      public:
	  grmenu(int l, int t, int ni, item *list, Orientation orient,
					      void (*optionhandler)(char));
	  void open(void);
	  void initialize(void);
	  char getoption(void);
	  char getoption(int mousex, int mousey);
	  char getoption(char cmd);
	  void setborderwidth(int newwidth);
	  void refresh(char=0, char=0);
	  void close(void);
     };


#endif

///END menu.h


