////////////////////////////////////////////
//
//   txdemo.h
//
//   Declarations for demo.cpp
//   demo for MenuPlus class
//
//   Copyright 1995 Jeffrey A. Schierenbeck
//
//   Note: the only difference between txdemo.h
//         and grdemo.h is the left and top menu
//	   coordinates specified by constructors
//
////////////////////////////////////////////

////////////////////////////////////
//  function prototypes
///////////////////////////////////

// menu handlers
void topmenubarhandler(char);
void optionhandler(char);
void exithandler(char);
void helphandler(char);
void outerwidthhandler(char);
void borderstylehandler(char);
void shadowhandler(char);
void colorhandler(char);
void COLORhandler(char);

// demo.cpp functions called by menu handlers
void techsupport(void);
void aboutmenuplus(void);
void gettingaround(void);


/////////////////////////////////
//  menu item declarations
/////////////////////////////////

int done = 0; // when done is nonzero, control() returns
char selection; // for saving colormenu choice for COLORmenu

item topmenubaritems[3] = { {"Options", 'O'},
			    {"Exit", 'E'},
			    {"Help", 'H'} };


item optionitems[4] = { {" Outerwidth", 'O'},
			{" Border style", 'B'},
			{" Shadow", 'S'},
			{" Colors", 'C'} };

item exititems[1] = { {" Exit to DOS ", 'E'} };


item helpitems[3] = { {" About MenuPlus ", 'A'},
		      {" Getting around demo ", 'G'},
		      {" Technical support ", 'T'} };

item outerwidthitems[3] = { {" NONE ", 'N'},
			    {" THIN ", 'T'},
			    {" THICK ", 'K'} };

item borderstyleitems[3] = { {" NO_BORDER ", 'N'},
			     {" SINGLE_LINE ", 'S'},
			     {" DOUBLE_LINE ", 'D'} };

item shadowitems[2] = { {" Shadow on ", 'n'},
			{" Shadow off ", 'f'} };

item coloritems[6] = { {" Text ", 'T'},
		       {" Hotkey ", 'H'},
		       {" Background ", 'k'},
		       {" Border ", 'B'},
		       {" Highlight bar ", 'r'},
		       {" Inactive text ", 'I'} };

item COLORitems[19] = { {" Black ", 'k'},
			{" Blue ", 'B'},
			{" Green ", 'G'},
			{" Cyan ", 'C'},
			{"-",'-'},
			{" Red ", 'R'},
			{" Magenta ", 'M'},
			{" Brown ", 'o'},
			{" Lightgray ", 'i'},
			{"-",'-'},
			{" Darkgray ", 'a'},
			{" Lightblue ", 'L'},
			{" Lightgreen ", 'e'},
			{" Lightcyan ", 't'},
			{"-",'-'},
			{" Lightred ", 'd'},
			{" Lightmagenta ", 'h'},
			{" Yellow ", 'Y'},
			{" White ", 'W'} };

item sampleitems[5] = { {" First option ", 'F'},
			{" Second option ", 'S'},
			{"-",'-'},
			{" Third option ",'T'},
			{" Fourth option ",'o'} };


//////////////////////////////////
//   menu constructors
/////////////////////////////////

txmenu topmenubar(1,1,3,topmenubaritems,HORZ,topmenubarhandler);
txmenu optionmenu(1,2,4,optionitems,VERT,optionhandler);
txmenu exitmenu(10,2,1,exititems,VERT,exithandler);
txmenu helpmenu(16,2,3,helpitems,VERT,helphandler);
txmenu outerwidthmenu(16,3,3,outerwidthitems,VERT,outerwidthhandler);
txmenu borderstylemenu(16,4,3,borderstyleitems,VERT,borderstylehandler);
txmenu shadowmenu(16,5,2,shadowitems,VERT,shadowhandler);
txmenu colormenu(16,6,6,coloritems,VERT,colorhandler);
txmenu COLORmenu(33,3,19,COLORitems,VERT,COLORhandler);
txmenu samplemenu(41,13,5,sampleitems,VERT,NULL);


//////////////////////////////////
//  menu handlers
//////////////////////////////////

void topmenubarhandler(char cmd)
	{topmenubar.refresh();
	 topactive = 1;
	 topmenubar.getoption(cmd);
	 switch(cmd)
	       {case 'O' : optionmenu.open();
			   openedlist.Add(&optionmenu);
			   break;
		case 'E' : exitmenu.open();
			   openedlist.Add(&exitmenu);
			   break;
		case 'H' : helpmenu.open();
			   openedlist.Add(&helpmenu);
			   break;
	       };
	};


void optionhandler(char cmd)
	{switch(cmd)
		{case 'O' : outerwidthmenu.open();
			    openedlist.Add(&outerwidthmenu);
			    break;
		 case 'B' : borderstylemenu.open();
			    openedlist.Add(&borderstylemenu);
			    break;
		 case 'S' : shadowmenu.open();
			    openedlist.Add(&shadowmenu);
			    break;
		 case 'C' : colormenu.open();
			    openedlist.Add(&colormenu);
			    break;
		 case -2  : optionmenu.close();
			    openedlist.Trim();
			    topmenubarhandler('H');
			    break;
		 case -3  : optionmenu.close();
			    openedlist.Trim();
			    topmenubarhandler('E');
			    break;
		};
	};


void exithandler(char cmd)
	{switch(cmd)
		{case 'E' : done = 1;
			    break;
		 case -2  : exitmenu.close();
			    openedlist.Trim();
			    topmenubarhandler('O');
			    break;
		 case -3  : exitmenu.close();
			    openedlist.Trim();
			    topmenubarhandler('H');
			    break;
		};
	};

void helphandler(char cmd)
	{switch(cmd)
		{case 'A' : closeall();
			    aboutmenuplus();
			    break;
		 case 'G' : closeall();
			    gettingaround();
			    break;
		 case 'T' : closeall();
			    techsupport();
			    break;
		 case -2  : helpmenu.close();
			    openedlist.Trim();
			    topmenubarhandler('E');
			    break;
		 case -3  : helpmenu.close();
			    openedlist.Trim();
			    topmenubarhandler('O');
			    break;
		};
	};


void colorhandler(char cmd)
	{if(cmd == 'T' || cmd == 'H' || cmd == 'k' || cmd == 'B'
					|| cmd == 'r' || cmd == 'I')
	     {if(cmd == 'k' || cmd == 'r')
		  {COLORmenu.makeinactive('a');
		   COLORmenu.makeinactive('L');
		   COLORmenu.makeinactive('e');
		   COLORmenu.makeinactive('t');
		   COLORmenu.makeinactive('d');
		   COLORmenu.makeinactive('h');
		   COLORmenu.makeinactive('Y');
		   COLORmenu.makeinactive('W');
		  }
	      else
		  {COLORmenu.makeactive('a');
		   COLORmenu.makeactive('L');
		   COLORmenu.makeactive('e');
		   COLORmenu.makeactive('t');
		   COLORmenu.makeactive('d');
		   COLORmenu.makeactive('h');
		   COLORmenu.makeactive('Y');
		   COLORmenu.makeactive('W');
		  };
	      selection = cmd; // for use by COLORhandler()
	      COLORmenu.open();
	      openedlist.Add(&COLORmenu);
	     };
	};


void COLORhandler(char cmd)
	{int color;
	 switch(cmd)
		{case 'k' : color = (BLACK); break;
		 case 'B' : color = (BLUE); break;
		 case 'G' : color =(GREEN); break;
		 case 'C' : color=(CYAN); break;
		 case 'R' : color=RED; break;
		 case 'M' : color=MAGENTA; break;
		 case 'o' : color=(BROWN); break;
		 case 'i' : color=(LIGHTGRAY); break;
		 case 'a' : color=(DARKGRAY); break;
		 case 'L' : color=(LIGHTBLUE); break;
		 case 'e' : color=(LIGHTGREEN); break;
		 case 't' : color=(LIGHTCYAN); break;
		 case 'd' : color=(LIGHTRED); break;
		 case 'h' : color=(LIGHTMAGENTA); break;
		 case 'Y' : color=(YELLOW); break;
		 case 'W' : color=(WHITE); break;
		};
	 closeall();
	 samplemenu.close();
	 switch(selection)
		{case 'T' : samplemenu.setcolors(color,-1,-1,-1,-1,-1);
			    break;
		 case 'H' : samplemenu.setcolors(-1,-1,-1,color,-1,-1);
			    break;
		 case 'k' : samplemenu.setcolors(-1,-1,color,-1,-1,-1);
			    break;
		 case 'B' : samplemenu.setcolors(-1,color,-1,-1,-1,-1);
			    break;
		 case 'r' : samplemenu.setcolors(-1,-1,-1,-1,color,-1);
			    break;
		 case 'I' : samplemenu.setcolors(-1,-1,-1,-1,-1,color);
			    break;
		};
	 samplemenu.open();
	};


void outerwidthhandler(char cmd)
	{samplemenu.close();
	 switch(cmd)
		{case 'N' : samplemenu.setborderwidth(NONE);
			    break;
		 case 'T' : samplemenu.setborderwidth(THIN);
			    break;
		 case 'K' : samplemenu.setborderwidth(THICK);
			    break;
		};
	 if(cmd == 'N')
		{borderstylemenu.makeinactive('S');
		 borderstylemenu.makeinactive('D');
		}
	 else
		{borderstylemenu.makeactive('S');
		 borderstylemenu.makeactive('D');
		};
	 closeall();
	 samplemenu.open();
	};


void borderstylehandler(char cmd)
	{samplemenu.close();
	 switch(cmd)
		{case 'N' : samplemenu.setborderstyle(NO_BORDER);
			    break;
		 case 'S' : samplemenu.setborderstyle(SINGLE_LINE);
			    break;
		 case 'D' : samplemenu.setborderstyle(DOUBLE_LINE);
			    break;
		};
	 closeall();
	 samplemenu.open();
	};


void shadowhandler(char cmd)
	{samplemenu.close();
	 switch(cmd)
		{case 'n' : samplemenu.shadowon();
			    break;
		 case 'f' : samplemenu.shadowoff();
			    break;
		};
	 closeall();
	 samplemenu.open();
	};

// end txdemo.h