/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: techlib.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	General header file for the Techniques Class library.
*
* $Id: techlib.hpp 1.2 1995/09/16 11:22:41 kjb release $
*
****************************************************************************/

#ifndef	__TCL_TECHLIB_HPP
#define	__TCL_TECHLIB_HPP

#ifndef	__DEBUG_H
#include "debug.h"
#endif

/*--------------------------- Inline Functions ----------------------------*/

//---------------------------------------------------------------------------
// Set of debugging macros used by the library. If the debug flag is
// set, they are turned on depending on the setting of the flag. If DEBUG
// is set to 2, all checks are turned on, if DEBUG is set to 1, only the
// pre-conditions are enabled. If DEBUG is 0 or undefined, no checks are
// peformed.
//---------------------------------------------------------------------------

void _TCL_checkFail(char *msg,char *cond,char *file,int line);

#undef	PRECONDITION
#undef	CHECK

#ifdef	DEBUG
#       define  PRE(x)  x
#       define  PRECONDITION(p)                                     \
		if (!(p)) _TCL_checkFail(									\
			"Precondition failed: '%s', file %s, line %d\n",		\
			#p, __FILE__, __LINE__)
#if		DEBUG > 1
#       define  CHK(x)  x
#		define	CHECK(p)											\
		if (!(p)) _TCL_checkFail(									\
			"Check failed: '%s', file %s, line %d\n",				\
			#p, __FILE__, __LINE__)
#else
#       define  CHK(x)
#		define	CHECK(p)		((void)0)
#endif
#else
#		define	PRECONDITION(p)	((void)0)
#		define	CHECK(p)		((void)0)
#       define  PRE(x)
#       define  CHK(x)
#endif

#endif	// __TCL_TECHLIB_HPP
