void LoadRender( render *dest, letter *src, point loc, int letter );
void normalize( render *dest );

void LoadRender( render *dest, letter *src, point loc, int letter )
{
	int x, y;
	point *v1;
	point2 *v2;
	side *s1;

	(*dest).letter = letter;

	(*dest).vertices = (*src).vertices;
	(*dest).sides = (*src).sides;

	for( x = 0; x < (*src).vertices; x++ )
	{
	  v1 = &(*dest).render_point[x];
	  v2 = &(*src).letter_point[x];
	  (*v1).x = (*v2).x;
	  (*v1).y = (*v2).y;
	  (*v1).z = (*v2).z;
	}

	for( x = 0; x < (*src).sides; x++ )
	{
	  v2 = &(*src).letter_side[x];
	  s1 = &(*dest).render_side[x];

	  (*s1).p1 = &((*dest).rotated_point[(*v2).x]);
	  (*s1).p2 = &((*dest).rotated_point[(*v2).y]);
	  (*s1).p3 = &((*dest).rotated_point[(*v2).z]);

	  (*dest).render_sort[x] = s1;
	  (*s1).normalize = 1;
	}
	
	(*dest).local_rotation.x = random_number()&255;
	(*dest).local_rotation.y = random_number()&255;
	(*dest).local_rotation.z = random_number()&255;

	//(*dest).local_position.x = (random_number()&16383)-8192;
	//(*dest).local_position.y = (random_number()&16383)-8192;

	(*dest).local_position.x = (random_number()&8191)-4096;
	(*dest).local_position.y = (random_number()&8191)-4096;

	(*dest).local_position.z = 8192;
				   
	(*dest).final_position.x = loc.x;
	(*dest).final_position.y = loc.y;
	(*dest).final_position.z = loc.z;

	(*dest).frames = 128;

}

void normalize( render *dest )
{
	int x;
	long xvect, yvect, zvect;
	long length;
	side *tmp;
	long z, c, t;

	prime_rotation( &(*dest).local_rotation );

	for( x = 0; x < (*dest).vertices; x++ )
	  rotate( &(*dest).render_point[x], &(*dest).rotated_point[x] );//, &(*dest).local_rotation );

	for( x = 0; x < dest->sides; x++ )
	{
	  tmp = &dest->render_side[x];

	  zvect = 
	    (
	      ((tmp->p1->x - tmp->p2->x) * (tmp->p1->y - tmp->p3->y)) -
	      ((tmp->p1->y - tmp->p2->y) * (tmp->p1->x - tmp->p3->x))
	    )>>8;

	  yvect = 
	    (
	      ((tmp->p1->x - tmp->p2->x) * (tmp->p1->z - tmp->p3->z)) -
	      ((tmp->p1->z - tmp->p2->z) * (tmp->p1->x - tmp->p3->x))
	    )>>8;

	  xvect = 
	    (
	      ((tmp->p1->z - tmp->p2->z) * (tmp->p1->y - tmp->p3->y)) -
	      ((tmp->p1->y - tmp->p2->y) * (tmp->p1->z - tmp->p3->z))
	    )>>8;

	  xvect *= xvect;           
	  yvect *= yvect;
	  zvect *= zvect;
	  length = xvect;
	  length += yvect;
	  length += zvect;
	
//          length>>=8;

	  if( length<0 )
	  {
	    //printf( "bad length %d\n", length );
	    length = -length;
	  }

	  t = length>>2;
	  z = 20;
	  while( z>=2 )
	  {
	    z=(length/t-t)>>1;
	    t+=z;
	  }

//        printf( "%ld   %d\n", length, t );

	  dest->render_side[x].normalize = t;
	}
}
