#include <stdio.h>
#include <stdlib.h>
#include <process.h>

void change_pal( int col_num, char red, char green, char blue );
void Get_pal( void );
void ZeroPalette(void);
void mode03h(void);

int  Test_previous_setup(void);
void AutoDetect(void);
void TestEnvironemt( void );

void DisplayCurrentSetUp(void);
void ShowScreen( char* screen, int highlight );
void FadeIn(void);
void locate( char x, char y);
void Restore_pal(void);
void FadeOut(void);
void wait_retrace( void );
int get_key( void );
void ShowInfo();
void GetDma();
void GetPort();
void GetFrquency();
void GetSoundCard();
void GetIrq();

char pal[256][3];
char fade[256][3];

char main_menu[20][60] = {
"                       Freedom CD Intro                     ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                        Run the demo                        ",
"                     Select sound card                      ",
"                     Select sample rate                     ",
"                        Select port                         ",
"                        Select DMA                          ",
"                        Select IRQ                          ",
"                      Exit to DOS :'-(                      ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            " };

char info[20][60] = {
"                       Freedom CD Intro                     ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                         NO INFO!!                          ",
"                       Party Version                        ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            " };

char Sound[20][60] = {

"                       Freedom CD Intro                     ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                           Silence                          ",
"                     Soundblaster 8 bit                     ",
"                     Soundblaster 16 bit                    ",
"                      Gravis Ultrasound                     ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            " };

char* sound_devices[]  = {
	"Silence",
	"DMA-SB-Mono",
	"DMA-SB-Stereo",
	"GUS" };

char rate[20][60] = {
"                       Freedom CD Intro                     ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"               8000          386                            ",
"              10000           .                             ",
"              12000           .                             ",
"              14000           .                             ",
"              16000           .                             ",
"              18000           .                             ",
"              20000           .                             ",
"              22000         486/33                          ",
"              26000           .                             ",
"              32000           .                             ",
"              38000           .                             ",
"              44000         486/66+                         ",
"                                                            ",
"                                                            ",
"                                                            " };

char* frequency_list[] = {
	"8000", "10000", "12000", "14000", "16000", "18000", "20000",
	"22000", "26000", "32000", "38000", "44000" };

char outp[20][60] = {
"                       Freedom CD Intro                     ",
"                                                            ",
"                                                            ",
"                                                            ",
"                        Select port                         ",
"                            200h                            ",
"                            210h                            ",
"                            220h                            ",
"                            230h                            ",
"                            240h                            ",
"                            250h                            ",
"                            260h                            ",
"                            270h                            ",
"                            280h                            ",
"                            290h                            ",
"                            2A0h                            ",
"                            2B0h                            ",
"                                                            ",
"                                                            ",
"                                                            " };

char* port_list[] = {
	"$200", "$210", "$220", "$230", "$240", "$250", "$260", "$270",
	"$280", "$290", "$2A0", "$2B0" };

char IRQ[20][60] = {
"                       Freedom CD Intro                     ",
"                                                            ",
"                                                            ",
"                                                            ",
"                         Select IRQ                         ",
"                              2                             ",
"                              3                             ",
"                              4                             ",
"                              5                             ",
"                              7                             ",
"                              8                             ",
"                             10                             ",
"                             11                             ",
"                             12                             ",
"                             13                             ",
"                             14                             ",
"                             15                             ",
"                                                            ",
"                                                            ",
"                                                            " };

int IRQ_list[12] = { 2, 3, 4, 5, 7, 8, 10, 11, 12, 13, 14, 15 };

char channel[20][60] = {
"                       Freedom CD Intro                     ",
"                                                            ",
"                                                            ",
"                                                            ",
"                         Select DMA                         ",
"                              0                             ",
"                              1                             ",
"                              3                             ",
"                              5                             ",
"                              6                             ",
"                              7                             ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            ",
"                                                            " };

int DMA_list[6] = { 0, 1, 3, 5, 6, 7 };

int sound_card = 0;
int frequency = 7;
int port = 0;
int dma = 0;
int ISR = 0;
int location = 5;

void main(void)
{
	int x, y;
	int temp;
	FILE* fp;

//      if( Test_previous_setup()==0 )
	  AutoDetect();

	Get_pal();
	FadeOut();

	mode03h();
	ZeroPalette();
	locate( 0, 24 );

	  ShowScreen((char*)main_menu, location);
	  FadeIn();

	while( 1 )
	{
		temp = get_key();
		ShowScreen((char*)main_menu, location);
		if( temp == 13 )
		{
		  switch( location )
		  {
		    case 5:

			fp = fopen( "freedom.vto", "wt" );
			fprintf( fp, "; Thanks to JCAB for DemoVT!\n\n" );
			if( (sound_card != 0) && (sound_card!=3) )
			  fprintf( fp, "/f:%s\n", frequency_list[frequency] );
			fprintf( fp, "/d:%s\n", sound_devices[sound_card] );
			if( sound_card!=0 )
			{
			  fprintf( fp, "/port:%s\n", port_list[port] );
			  fprintf( fp, "/irq:%d\n", IRQ_list[ISR] );
			  fprintf( fp, "/dma:%d\n", DMA_list[dma] );
			  fprintf( fp, "/v:80\n" );
			}
			fprintf( fp, "\n" );
			fprintf( fp, "   freedom.003 /off:31808  /sh:freedom.004 \n" );
			fprintf( fp, "/                          /sh:freedom.002 \n" );
			fprintf( fp, "/                          /sh:freedom.005 \n" );
			fprintf( fp, "/\n" );
			
			Restore_pal();
			fclose( fp );
			FadeOut();
			asm   {
			  mov  ax, 0x0013
			  int  0x10  }
			for( x = 0; x < 256; x++ )
			  change_pal( x, 0, 0, 0 );

			if( sound_card == 0 )
			{
			  fp = fopen( "freedom.bat", "wt" );
			  fprintf( fp, "@echo off\n" );
			  fprintf( fp, "copy freedom.004 temp.exe\n" );
			  fprintf( fp, "temp.exe\n" );
			  fprintf( fp, "copy freedom.002 temp.exe\n" );
			  fprintf( fp, "temp.exe\n" );
			  fprintf( fp, "copy freedom.005 temp.exe\n" );
			  fprintf( fp, "temp.exe\n" );
			  fprintf( fp, "del temp.exe\n" );
			  fprintf( fp, "del freedom.bat\n" );
			  fclose( fp );
			  system( "freedom.bat" );
			  goto not_today;
			}
			else 
			  execl( "freedom.001", "freedom.001", "@freedom.vto" );
			
		    case 6:
		      FadeOut();
		      GetSoundCard();
		      ShowScreen((char*)main_menu, location);
		      FadeIn();
		      break;

		    case 7:
		      if( sound_card != 4 )
		      {
		      FadeOut();
		      GetFrquency();
		      ShowScreen((char*)main_menu, location);
		      FadeIn();
		      }
		      break;

		    case 8:
		      FadeOut();
		      GetPort();
		      ShowScreen((char*)main_menu, location);
		      FadeIn();
		      break;

		    case 9:
		      FadeOut();
		      GetDma();
		      ShowScreen((char*)main_menu, location);
		      FadeIn();
		      break;

		    case 10:
		      FadeOut();
		      GetIrq();
		      ShowScreen((char*)main_menu, location);
		      FadeIn();
		      break;

		    case 11:
		      goto not_today;
		  }
		}

		if( temp == 27 )
		  break;

		if( (temp&255) == 224 )
		{
		  switch( temp>>8 )
		  {
		    case 'P':
		      if( location < 11 )
			location++;
		      break;

		    case 'H':
		      if( location > 5 )
			location--;
		      break;
		  }
		  asm  {
		    mov  ah, 5
		    mov  ch, 1eh
		    mov  cl, 'A'
		    int  0x16  }
		}
	}

not_today:
	FadeOut();
	mode03h();
}

void change_pal( int col_num, char red, char green, char blue )
{
	asm  {
	  mov  dx, 0x3c8
	  mov  ax, col_num
	  out  dx, al
	  inc  dx
	  mov  al, red
	  out  dx, al
	  mov  al, green
	  out  dx, al
	  mov  al, blue
	  out  dx, al  }
}

void Get_pal( void )
{
	int x;
	char temp, temp1, temp2;

	for( x = 0; x < 256; x++ )
	{
	  asm  {
	    mov  dx, 0x3c7
	    mov  ax, x
	    out  dx, al
	    inc  dx
	    inc  dx
	    in   al, dx
	    mov  temp, al
	    in   al, dx
	    mov  temp1, al
	    in   al, dx
	    mov  temp2, al
	  }
	  pal[x][0] = temp;
	  pal[x][1] = temp1;
	  pal[x][2] = temp2;
	}

	pal[7][0] = 0;
	pal[7][1] = 0;
	pal[7][2] = 0;
}

void FadeOut(void)
{
	int x, y;

	for( y = 0; y < 63; y++ )
	{
	  if( (y&7) == 0 )
	    wait_retrace();

	  for( x = 0; x < 256; x++ )
	    change_pal( x, ((pal[x][0]-y)<=0)? 0:pal[x][0]-y,
	    ((pal[x][1]-y)<=0)? 0:pal[x][1]-y,
	    ((pal[x][2]-y)<=0)? 0:pal[x][2]-y  );
	}
}

void mode03h(void)
{
	asm  {
	  mov  ax, 0x0003
	  int  0x10
	  mov  ax, 0xb800
	  mov  es, ax
	}
}

int Test_previous_setup(void)
{
	FILE* fp;

	fp = fopen( "expressn.vto", "rb" );
	if( fp != NULL )
	{
		return( 1 );
	}
	fclose( fp );
	return(0);
}

void AutoDetect(void)
{
	char *env;
	int x = 0;

	env = getenv( "ULTRASND" );

	if( env != NULL )
	{
	  while( (env[x] != '2') && (x<80) )
	    x++;

	  port = env[x+1]-48;
	  if( port > 10 )
	    port = (env[x+1]|32)-97;
	  x = 0;

	  while( (env[x] != ',') && (x<80) )
	    x++;

	  x++;

	  while( (env[x] != ',') && (x<80) )
	    x++;

	  x++;
	  
	  while( (env[x] != ',') && (x<80) )
	    x++;
	  
	  ISR = 0;
	  switch( env[x+1] )
	  {
	    case '1':
	      switch( env[x+2] )
	      {
		case '5':
		  ISR++;

		case '4':
		  ISR++;

		case '3':
		  ISR++;

		case '2':
		  ISR++;

		case '1':
		  ISR++;

		case '0':
		  ISR++;
	      }

	    case '8':
		ISR++;

	    case '7':
		ISR++;

	    case '5':
		ISR++;

	    case '4':
		ISR++;

	    case '3':
		ISR++;

	    case '2':
		break;

	    default:
		ISR = 0;
	}

	x = 0;

	while( (env[x] != ',') && (x<80) )
	  x++;

	switch( env[x+1] )
	{
	  case '7':
	    dma++;

	  case '6':
	    dma++;

	  case '5':
	    dma++;

	  case '3':
	    dma++;

	  case '1':
	    dma++;

	  case '0':
	    break;

	  default:
	    dma = 0;
	}

	  sound_card = 3;
	}
	else
	{
	  env = getenv( "BLASTER" );

	  if( env!=NULL)
	  {
	    sound_card = 1;

	    while( (env[x] != 'A') && (x < 80) )
	      x++;

	    port = env[x+2]-48;
	    if( port > 10 )
	      port = (env[x+2]|32)-97;
	    x = 0;

	    while( (env[x] != 'I') && (x < 80) )
	      x++;

	    ISR = 0;
	    switch( env[x+1] )
	    {
	      case '1':
		switch( env[x+2] )
		{
		case '5':
		  ISR++;

		case '4':
		  ISR++;

		case '3':
		  ISR++;

		case '2':
		  ISR++;

		case '1':
		  ISR++;

		case '0':
		  ISR++;
	      }

	      case '8':
		ISR++;

	      case '7':
		ISR++;

	      case '5':
		ISR++;

	      case '4':
		ISR++;

	      case '3':
		ISR++;

	      case '2':
		break;

	      default:
		ISR = 0;
	    }

	  x = 0;
	  while( (env[x] != 'D') && (x < 80) )
	    x++;

	  switch( env[x+1] )
	  {
	    case '7':
	      dma++;

	    case '6':
	      dma++;

	    case '5':
	      dma++;

	    case '3':
	      dma++;

	    case '1':
	      dma++;

	    case '0':
	      break;

	    default:
	      dma = 0;
	  }
	}

	  if( env == NULL )
	  {
	    sound_card = 0;
	  }
	}
}

void ShowScreen( char* screen, int highlight )
{
	int x, y;
	char temp;

	asm  {
	  mov  si, 20 }
	for( x = 0; x < 20; x++ )
	{
	  for( y = 0; y < 60; y++ )
	  {
	    temp = *(screen+(x*60)+y);
	    asm  {
	      mov  al, temp
	      mov  es:[si], al
	      inc  si
	      inc  si
	    }
	  }
	  asm  {
	    add  si, 40  }
	}
	asm  {
	  xor  si, si
	  inc  si  }

	DisplayCurrentSetUp();

	for( x = 0; x < 3; x++ )
	  for( y = 0; y < 80; y++ )
	  {
	    asm  {
	      mov  al, 1
	      mov  es:[si], al
	      inc  si
	      inc  si  }
	  }

	for( x = 3; x < highlight; x++ )
	  for( y = 0; y < 80; y++ )
	  {
	    asm  {
	      mov  al, 5
	      mov  es:[si], al
	      inc  si
	      inc  si  }
	  }

	  for( y = 0; y < 80; y++ )
	  {
	    asm  {
	      mov  al, 10
	      mov  es:[si], al
	      inc  si
	      inc  si  }
	  }

	for( x = highlight+1; x < 24; x++ )
	  for( y = 0; y < 80; y++ )
	  {
	    asm  {
	      mov  al, 5
	      mov  es:[si], al
	      inc  si
	      inc  si  }
	  }
}

void FadeIn(void)
{
	int x, y;

	for( y = 63; y >= 0; y-- )
	{
	  if( (y&7) == 0 )
	    wait_retrace();

	  for( x = 0; x < 256; x++ )
	    change_pal( x,
	    ((pal[x][0]-y)<=0)? 0:pal[x][0]-y,
	    ((pal[x][1]-y)<=0)? 0:pal[x][1]-y,
	    ((pal[x][2]-y)<=0)? 0:pal[x][2]-y  );
	}
}

void DisplayCurrentSetUp(void)
{
	locate( 0, 22 );
	if( sound_card != 3 )
	{
	  printf( "Sound Card: %s  Port %s  Irq: %d  Dma: %d  Frequency: %s\t\t\t\t\t",
	    sound_devices[sound_card],
	    port_list[port],
	    IRQ_list[ISR],
	    DMA_list[dma],
	    frequency_list[frequency] );
	}
	else
	{
	  printf( "Sound Card: %s  Port %s  Irq: %d  Dma: %d\t\t\t\t\t",
	    sound_devices[sound_card],
	    port_list[port],
	    IRQ_list[ISR],
	    DMA_list[dma]  );
	}
	locate( 0, 24 );
}

void locate( char x, char y)
{
	asm  {
	  mov   ax, 0200h         // Good
	  mov   bh, 00h
	  mov   dh, y        // y is the row
	  mov   dl, x        // x is the column
	  int   0x10  }
}

void Restore_pal()
{
	int x;

	pal[7][0] = 48;
	pal[7][1] = 48;
	pal[7][2] = 48;

	for( x = 0; x < 256; x++ )
	  change_pal( x, pal[x][0], pal[x][1], pal[x][2] );
}

void wait_retrace( void )
{
      // straight from Denthor's tutorials  Thanks!

      asm  {
	mov  dx,0x3da  }
   l1:
      asm  {
	in  al,dx
	test al, 8
	jnz l1  }
   l2:
      asm  {
	in  al,dx
	test al, 8
	jz  l2  }
}

void ZeroPalette(void)
{
	int x;

	for( x = 0; x < 256; x++ )
	  change_pal( x, 0, 0, 0 );
}

int get_key()
{
	int r;

	asm  {
	  mov   ah, 10h
	  int   0x16

	  mov   dx, ax
	  xor   ah, ah
	  mov   r, ax

	  cmp   al, 224
	  je    key
	  cmp   al, 0
	  je    key
	  jmp   goon
	  }

key:
	asm  {
	  mov  r, dx  }

goon:
	asm  {
	  mov   ah, 2
	  int   0x16               // bordering on good
	  }

	return  r;

}

void GetDma(void)
{
	int temp;
	ShowScreen( (char*)channel, dma+5 );
	FadeIn();

	while( 1 )
	{
		temp = get_key();
		ShowScreen((char*)channel, dma+5);
		if( temp == 13 )
		{
		  break;
		}

		if( temp == 27 )
		{
		  dma = 0;
		  break;
		}

		if( (temp&255) == 224 )
		{
		  switch( temp>>8 )
		  {
		    case 'P':
		      if( dma < 5 )
			dma++;
		      break;

		    case 'H':
		      if( dma > 0 )
			dma--;
		      break;
		  }
		  asm  {
		    mov  ah, 5
		    mov  ch, 1eh
		    mov  cl, 'A'
		    int  0x16  }
		}
	}
	FadeOut();
}

void GetPort(void)
{
	int temp;
	ShowScreen( (char*)outp, port+5);
	FadeIn();

	while( 1 )
	{
		temp = get_key();
		ShowScreen((char*)outp, port+5);
		if( temp == 13 )
		{
		  break;
		}

		if( temp == 27 )
		{
		  port = 0;
		  break;
		}

		if( (temp&255) == 224 )
		{
		  switch( temp>>8 )
		  {
		    case 'P':
		      if( port < 11 )
			port++;
		      break;

		    case 'H':
		      if( port > 0 )
			port--;
		      break;
		  }
		  asm  {
		    mov  ah, 5
		    mov  ch, 1eh
		    mov  cl, 'A'
		    int  0x16  }
		}
	}
	FadeOut();
}

void GetFrquency(void)
{
	int temp;
	ShowScreen( (char*)rate, frequency+5);
	FadeIn();

	while( 1 )
	{
		temp = get_key();
		ShowScreen((char*)rate, frequency+5);
		if( temp == 13 )
		{
		  break;
		}

		if( temp == 27 )
		{
		  frequency = 0;
		  break;
		}

		if( (temp&255) == 224 )
		{
		  switch( temp>>8 )
		  {
		    case 'P':
		      if( frequency < 11 )
			frequency++;
		      break;

		    case 'H':
		      if( frequency > 0 )
			frequency--;
		      break;
		  }
		  asm  {
		    mov  ah, 5
		    mov  ch, 1eh
		    mov  cl, 'A'
		    int  0x16  }
		}
	}
	FadeOut();
}

void GetSoundCard(void)
{
	int temp;
	ShowScreen( (char*)Sound, sound_card+5);
	FadeIn();

	while( 1 )
	{
		temp = get_key();
		ShowScreen((char*)Sound, sound_card+5);
		if( temp == 13 )
		{
		  break;
		}

		if( temp == 27 )
		{
		  sound_card = 0;
		  break;
		}

		if( (temp&255) == 224 )
		{
		  switch( temp>>8 )
		  {
		    case 'P':
		      if( sound_card < 3 )
			sound_card++;
		      break;

		    case 'H':
		      if( sound_card > 0 )
			sound_card--;
		      break;
		  }
		  asm  {
		    mov  ah, 5
		    mov  ch, 1eh
		    mov  cl, 'A'
		    int  0x16  }
		}
	}
	FadeOut();
}

void GetIrq()
{
	int temp;
	ShowScreen( (char*)IRQ, ISR+5);
	FadeIn();

	while( 1 )
	{
		temp = get_key();
		ShowScreen((char*)IRQ, ISR+5);
		if( temp == 13 )
		{
		  break;
		}

		if( temp == 27 )
		{
		  ISR = 0;
		  break;
		}

		if( (temp&255) == 224 )
		{
		  switch( temp>>8 )
		  {
		    case 'P':
		      if( ISR < 11 )
			ISR++;
		      break;

		    case 'H':
		      if( ISR > 0 )
			ISR--;
		      break;
		  }
		  asm  {
		    mov  ah, 5
		    mov  ch, 1eh
		    mov  cl, 'A'
		    int  0x16  }
		}
	}
	FadeOut();
}
