        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include graphics.inc
include pmodedvt.inc
include kb.inc

extrn   putcode:near, putcode2:near

public  _main

;
; DATA
;

buffer1 dd      ?
buffer2 dd      ?
counter dd      0
frame   dw      0
amount  dw      200
where   dd      ?
temppal db  63, 63, 63
music   db  1

;
; CODE
;

;
_main:
        sti

        call _initkb
        
        call InitMusic
        or   al, al
        jz   no_music
        call VTConnectTimer
        call VTBeginSync
        call VTWaitForStart
        jmp   bgn
no_music:
        mov music, 0

bgn:
        call    init_mode13
        
        mov     ecx, offset pal1
        mov     eax, 0
set_pal:
        call    change_pal
        add     ecx, 6
        inc     eax
        cmp     eax, 256
        jne     set_pal


        mov     eax, 128000
        call    _gethimem
        mov     [buffer1], eax

        mov     eax, 128000
        call    _gethimem
        mov     [buffer2], eax          ; allocate memory

        mov     edi, buffer1
        mov     ecx, 64000
        sub     eax, eax
        rep     stosw

        mov     edi, buffer2
        mov     ecx, 64000
        sub     eax, eax
        rep     stosw                   ; clear buffers

water_lp:
        mov     edi, screenptr
        mov     ecx, (64000-320)/8
        xor     ebx, ebx

        cmp     word ptr frame, 0
        je      use_buffer1
        mov     esi, buffer2
        jmp     blit_to_screen
use_buffer1:
        mov     esi, buffer1
blit_to_screen:
        mov     ax, [esi+ebx*2]
        mov     [edi+ebx], al
        mov     ax, [esi+ebx*2+2]
        mov     [edi+ebx+1], al
        mov     ax, [esi+ebx*2+4]
        mov     [edi+ebx+2], al
        mov     ax, [esi+ebx*2+6]
        mov     [edi+ebx+3], al
        
        mov     ax, [esi+ebx*2+8]
        mov     [edi+ebx+4], al
        mov     ax, [esi+ebx*2+10]
        mov     [edi+ebx+5], al
        mov     ax, [esi+ebx*2+12]
        mov     [edi+ebx+6], al
        mov     ax, [esi+ebx*2+14]
        mov     [edi+ebx+7], al

        add     ebx, 8
        dec     ecx
        jnz     blit_to_screen

        cmp     word ptr frame, 0
        jne     use_buffer2
        mov     esi, buffer1
        mov     edi, buffer2
        jmp     frame_begin
use_buffer2:
        mov     esi, buffer2
        mov     edi, buffer1
frame_begin:

        add     esi, 318*2
        add     edi, 318*2
        mov     edx, 198
yloop:
        add     edi, 8
        add     esi, 8
        mov     ecx, 158
xloop:
        add     edi, 2
        add     esi, 2

        mov     ax, word ptr [esi+640]
        add     ax, word ptr [esi-640]
        add     ax, word ptr [esi-2]
        add     ax, word ptr [esi+2]
        sar     ax, 1
        sub     ax, [edi]
        
        mov     bx, ax
        sar     bx, 4
        sub     ax, bx
        mov     word ptr [edi], ax

        add     edi, 2
        add     esi, 2

        mov     ax, word ptr [esi+640]
        add     ax, word ptr [esi-640]
        add     ax, word ptr [esi-2]
        add     ax, word ptr [esi+2]
        sar     ax, 1
        sub     ax, [edi]
        
        mov     bx, ax
        sar     bx, 4
        sub     ax, bx
        mov     word ptr [edi], ax
        
        dec     ecx
        jnz     xloop
        dec     edx
        jnz     yloop

        cmp  music, 0
        je   no_semcheck

        mov     ebx, 1
        mov     al, 1
        call    VTCheckSemaphore
        je      no_line

        mov     ebx, 1
        mov     al, 2
        call    VTCheckSemaphore
        je      no_line2

        mov     ebx, 1
        mov     al, 3
        call    VTCheckSemaphore
        je      outta_here

no_semcheck:
        cmp counter, 200
        jge   no_line

        cmp     word ptr frame, 1
        je      b2
        mov     edi, buffer2
        jmp     b1
b2:
        mov     edi, buffer1
b1:
        mov     ebx, 128
        call    putcode2
        jmp     no_line2
no_line:
        cmp  counter, 400
        jge  no_line2

line2:
        cmp     word ptr frame, 1
        je      b3
        mov     edi, buffer2
        jmp     b4
b3:
        mov     edi, buffer1
b4:
        mov     ebx, 128
        call    putcode
no_line2:

        cmp counter, 600
        jge  outta_here

        cmp  music, 1
        je   no_inc
        inc  counter

no_inc:        
        xor     word ptr frame, 1

        jmp     water_lp

outta_here:

        ;call init_mode03

        call _resetkb

        jmp _exit

include palette.inc

code32  ends
        end

