; Floor&Sky darkness table

        IDEAL
        MODEL Compact, Pascal
        RADIX 10
        P286

        FARDATA FloorSky

PUBLIC FloorSkyTable

FloorSkyTable:
        INCLUDE "data\floorsky.inc"

        DATASEG

EXTRN CurrentBase : Word
EXTRN CurrentPage : Word

PUBLIC SkyTexture, FloorTexture
PUBLIC Column0, Column1, Column2, Column3
PUBLIC LoY, HiY

SkyTexture     DD   100d DUP(?)      ; Colors for Sky...
FloorTexture   DD   100d DUP(?)      ; ...and Floor

Column0        DD   200d DUP (?)
Column1        DD   200d DUP (?)
Column2        DD   200d DUP (?)
Column3        DD   200d DUP (?)

ColumnMemoryP0 DB   200d*20d DUP(?)
ColumnMemoryP1 DB   200d*20d DUP(?)
ColumnMemoryP2 DB   200d*20d DUP(?)

Times4000      DW   0d,4000d,8000d   ; 4000 table to calculate offset
                                     ; into ColumnMemoryP?
                                     ; (seen 4000 in binary? :-o)

LoY            DW   ?
HiY            DW   ?

PageLoHi       DW   3*20d DUP (00c7h)  ; Lo=199, Hi=0

        CODESEG

EXTRN DumpColumns : NEAR

PUBLIC InitColumnMemory
PUBLIC FillWithFloorSky        ; fills 16 cols w/ background & reset LoY,HiY
PUBLIC RegisterRange           ; (Y0,Y1:word)
PUBLIC Dump16cols              ; (Ofs:word);

; // InitColumnMemory

      PROC InitColumnMemory NEAR
P386
      USES eax, ecx, edi, es
        xor eax,eax
        mov ecx, 3000d
        mov ax,ds
        mov es,ax
        xor edi,edi
        mov di, offset ColumnMemoryP0
        rep stosd
      ret
      ENDP

; // FillWithFloorSky

      PROC FillWithFloorSky NEAR
P386
      USES ax, ecx, esi, edi, es

        mov [LoY], 199d
        mov [HiY], 0

        mov ax,ds
        mov es,ax

        xor esi,esi
        xor edi,edi
        cld
        mov di, offset Column0

        REPT 4
          mov si, offset SkyTexture
          mov ecx, 200d
          rep movsd
        ENDM

        ret
P286
      ENDP

; // RegisterRange

      PROC RegisterRange NEAR
      ARG Y0 : Word, Y1 : Word
      USES ax
        mov ax, [Y0]
        cmp ax, [LoY]
        jnb @@Y0notLess
        mov [LoY],ax
@@Y0notLess:
        mov ax, [Y1]
        cmp ax, [HiY]
        jna @@Y1notMore
        mov [HiY], ax
@@Y1notMore:
        ret
      ENDP

; // UpdateColumns

        PROC UpdateColumns NEAR
        ARG Texture : FAR PTR Byte, X : Word, \
            ScreenOffset : Word, Y0 : Word, Y1 : Word
P386
        pusha
        push es
        push ds
        push fs

          mov dx, 3c5h
          mov al, 0fh
          out dx, al        ; set mask to all

          mov ax, 0a000h
          mov fs, ax
          mov di, [CurrentBase]
          add di, [ScreenOffset]

          mov ax, [Y0]
          shl ax,4
          add di, ax
          shl ax,2
          add di, ax         ; fs:di-> screen

          mov ax,ds
          mov es,ax
          mov bx, offset Times4000
          mov ax, [CurrentPage]
          shl ax,1
          add bx,ax
          mov bx,[bx]                   ; bx = 4000*page

          mov ax, [X]
          shl ax,3
          add bx,ax
          shl ax,3
          add bx,ax
          shl ax,1
          add bx,ax                     ; + 200*X

          add bx, [Y0]                  ; + Y0

          add bx, offset ColumnMemoryP0  ; es:bx -> ColumnMemory

          lds si, [Texture]              ; ds:si -> texture
          mov ax, [Y0]
          shl ax,2
          add si, ax                     ; +4*Y0

          mov cx, [Y1]
          sub cx, [Y0]
          inc cx
          jle @@nothing

@@updtLoop:
          mov eax, [ds:si]    ; get floor/sky texture color
          cmp al, [es:bx]     ; compare w/ memory
          je @@same

          ; not the same, update screen:

          mov [es:bx], al     ; update memory
          mov [fs:di], eax    ; ...and dump to screen

@@same:
          inc bx
          add si,4
          add di,80d

          loop @@updtLoop

@@nothing:

        pop fs
        pop ds
        pop es
        popa
P286
        ret
        ENDP


; // KillMemory

        PROC KillMemory NEAR
        ARG X : Word, Y0 : Word, Y1 : Word
P386
        pusha
        push es

          mov ax,ds
          mov es,ax
          mov bx, offset Times4000
          mov ax, [CurrentPage]
          shl ax,1
          add bx,ax
          mov di,[bx]                   ; di = 4000*page

          mov ax, [X]
          shl ax,3
          add di,ax
          shl ax,3
          add di,ax
          shl ax,1
          add di,ax                     ; + 200*X

          add di, [Y0]                  ; + Y0

          add di, offset ColumnMemoryP0  ; es:bx -> ColumnMemory

          mov cx, [Y1]
          sub cx, [Y0]
          inc cx
          jle @@nothing

          xor al,al
          rep stosb

@@nothing:

        pop es
        popa
P286
        ret
        ENDP


; // Dump16cols

MACRO   dumpOne buf,msk
        push ds
        push offset buf
        push [Ofs]
        push [allY0]
        push [allY1]
        push msk
        call DumpColumns
ENDM

      PROC Dump16cols NEAR
      ARG Ofs : Word, X : Word
      LOCAL allY0 : Word, allY1 : Word

        ; find lo and hi Y

        mov si, offset PageLoHi
        mov ax, [CurrentPage]
        shl ax,3
        mov bx,ax
        shl ax,2
        add ax,bx
        add si, ax
        mov ax, [X]     ; ax = 0..19
        shl ax, 1
        add si, ax      ; ax -> PageLoHi[X div 16]

        mov ax,[si]
        xor bh,bh
        mov bl,al       ; bx = oldLoY
        mov cx, [LoY]
        cmp bx, cx
        jb @@1
        mov bx,cx
@@1:                    ; bx = min(oldLoY,LoY)
        mov [allY0], bx

        xor bh,bh
        mov bl,ah
        mov cx, [HiY]
        cmp bx,cx
        ja @@2
        mov bx,cx
@@2:                    ; bx = max(oldHiY,HiY)
        mov [allY1], bx

        ; draw walls

        DumpOne Column0, 1
        DumpOne Column1, 2
        DumpOne Column2, 4
        DumpOne Column3, 8

        push [X]
        push [allY0]
        push [allY1]
        call KillMemory


        ; Update sky

        mov ax,[allY0]
        dec ax
        js @@skipSky

        push ds
        push offset SkyTexture
        push [X]
        push [Ofs]
        push 0         ; Y0
        push ax        ; Y1 = allY0-1
        call UpdateColumns

@@skipSky:

        ; update floor

        mov ax,[allY1]
        inc ax
        cmp ax,200
        jae @@skipFloor

        push ds
        push offset SkyTexture
        push [X]
        push [Ofs]
        push ax        ; Y0 = allY1+1
        push 199       ; Y1 = 199
        call UpdateColumns

@@skipFloor:

        ret
      ENDP




        END

