{$M 30720,0,655360}

(* Text showing part  (C) '95 By Paradise *)

Unit Tekst2;

Interface

 Procedure Tekst2_Init;
 Procedure Tekst2_Setup(Sd, Md : Word);
 Procedure Tekst2_Run;
 Procedure Tekst2_Done;

Implementation

Uses Crt, Dos, Vga, FP, TPUnpack;

Type
 PalType  = Array [0..255,1..3] of Byte;

Var
 Font     : Array [0..45,0..15,0..15] of Byte;
 FontPal,
 ZeroPal,
 MainPal,
 Palette,
 Target   : PalType;
 CharTab  : Array [0..255] of Byte;
 Count    : Integer;
 Teksty   : Array [1..100] of String[30];
 TekstNum : Byte;
 IncPal   : Array [0..255,1..3] of LongInt;
 TOffs    : Word;
 MDelayed,
 SDelayed : Word;

{$L FoncikP.Obj}
Procedure FoncikPalette; External;

{$L Foncik.Obj}
Function FoncikSize: Word; Far; External;
Procedure UnpackFoncik(Var Buffer); Far; External;

Procedure InitCharTab;
Begin
 FillChar(CharTab,SizeOf(CharTab),45);
 For Count:=Ord('a') to Ord('z') do CharTab[Count]:=Count-80;
 For Count:=Ord('A') to Ord('Z') do CharTab[Count]:=Count-48;
 For Count:=Ord('0') to Ord('9') do CharTab[Count]:=Count-44;
 CharTab[Ord('(')]:=43; CharTab[Ord(')')]:=44;
 CharTab[Ord('{')]:=43; CharTab[Ord('}')]:=44;
 CharTab[Ord('[')]:=43; CharTab[Ord(']')]:=44;
 CharTab[Ord('!')]:=0;  CharTab[Ord('-')]:=1;
 CharTab[Ord('.')]:=2;  CharTab[Ord('/')]:=3;
 CharTab[Ord(':')]:=14; CharTab[Ord('_')]:=15;
 CharTab[Ord('?')]:=16;
End;

Procedure FontLoad;
Begin
 UnpackFoncik(Font);
 Move(@FoncikPalette^,FontPal,768);
End;

Procedure PlotChar(X, Y : Word; Z : Byte; GSeg : Word); Assembler;
Asm
 mov ax, GSeg
 mov es, ax
 mov bx, Y
 shl bx, 1
 mov di, word ptr YOfs[bx]
 add di, X
 xor bx, bx
 mov bl, Z
 shl bx, 8
 mov cx, 16
@yloop:
 db $66; mov ax, word ptr Font[bx]
 db $66; stosw
 db $66; mov ax, word ptr Font[bx+4]
 db $66; stosw
 db $66; mov ax, word ptr Font[bx+8]
 db $66; stosw
 db $66; mov ax, word ptr Font[bx+12]
 db $66; stosw
 add bx, 16
 add di, 304
 dec cx
 jnz @yloop
End;

Procedure Printf(X, Y : Integer; St : String; GSeg : Word);
Var
 Count : Byte;
 NewX  : Word;
Begin
 NewX:=X;
 For Count:=1 to Length(St) do
 Begin
  PlotChar(NewX,Y,CharTab[Ord(St[Count])],GSeg);
  Inc(NewX,16);
 End;
End;

Procedure AddString(St : String);
Begin
 Inc(TekstNum);
 Teksty[TekstNum]:=St;
End;

Procedure DrawTeksty(TOfs : Byte; SOfs : Word; GSeg : Word);
Begin
 For Count:=1 to 10 do
 Begin
  If Teksty[TOfs+Count]<>'' then
   Printf(0,(Count-1)*20+SOfs,Teksty[TOfs+Count],GSeg);
 End;
End;

Procedure CalcFading(P1, P2 : PalType; Steps : Integer);
Var
 i : Integer;
Begin
 For i:=0 to 255 do
 Begin
  IncPal[i,1]:=FixedDiv(I2L(P2[i,1]-P1[i,1]),I2L(Steps));
  IncPal[i,2]:=FixedDiv(I2L(P2[i,2]-P1[i,2]),I2L(Steps));
  IncPal[i,3]:=FixedDiv(I2L(P2[i,3]-P1[i,3]),I2L(Steps));
 End;
 MainPal:=P1;
 Palette:=P1;
 SetPalette(@Palette);
End;

Procedure UpdateFading(Frame : Integer);
Var
 i : Integer;
Begin
 For i:=0 to 255 do
 Begin
  Palette[i,1]:=L2I(I2L(MainPal[i,1])+FixedMul(IncPal[i,1],I2L(Frame)));
  Palette[i,2]:=L2I(I2L(MainPal[i,1])+FixedMul(IncPal[i,2],I2L(Frame)));
  Palette[i,3]:=L2I(I2L(MainPal[i,1])+FixedMul(IncPal[i,3],I2L(Frame)));
 End;
 SetPalette(@Palette);
End;

Procedure ShowTitle(Ofz : Word);
Var
 j : Integer;
Begin
 FillChar(ZeroPal,768,0);
 CalcFading(ZeroPal,FontPal,30);
 ClearFake($A000);
 DrawTeksty(TOffs,Ofz,$A000);
 Inc(TOffs,10);
 For j:=1 to 30 do
 Begin
  UpdateFading(j);
  VRet;
 End;
 SetPalette(@FontPal);
 VRet;
End;

Procedure HideTitle;
Var
 j : Integer;
Begin
 CalcFading(FontPal,ZeroPal,30);
 For j:=1 to 30 do
 Begin
  UpdateFading(j);
  VRet;
 End;
 SetPalette(@ZeroPal);
 VRet;
End;

Procedure BlowTitle;
Var
 j : Integer;
Begin
 FillChar(ZeroPal,768,63);
 CalcFading(FontPal,ZeroPal,20);
 For j:=1 to 20 do
 Begin
  UpdateFading(j);
  VRet;
 End;
 SetPalette(@ZeroPal);
 VRet;
End;

Procedure Tekst2_Init;
Begin
 InitYOfs;
 FontLoad;
 InitCharTab;
 TekstNum:=0;
 TOffs:=0;
 MDelayed:=4000;
 SDelayed:=1000;
 AddString('');
 AddString('');
 AddString('');
 AddString('');
 AddString('    it is over___  ');
 AddString('');
 AddString('');
 AddString('');
 AddString('');
 AddString('');
 AddString('');
 AddString('');
 AddString('');
 AddString('');
 AddString('        not !      ');
 AddString('');
 AddString('');
 AddString('');
 AddString('');
 AddString('');
End;

Procedure Tekst2_Setup(Sd, Md : Word);
Begin
 SDelayed:=Sd;
 MDelayed:=Md;
End;

Procedure Tekst2_Run;
Begin
 Delay(SDelayed);
 ShowTitle(10);
 Delay(MDelayed);
 HideTitle;
 Delay(SDelayed);
 ShowTitle(10);
 Delay(MDelayed);
 HideTitle;
 Delay(SDelayed);
End;

Procedure Tekst2_Done;
Begin
End;

End.
