{$M 32000,0,655360}
{$G+}

(* Lens effect   (C) '95 By Paradise *)

Unit Lens;

Interface

 Procedure Lens_Init;
 Procedure Lens_Setup(NSteps : Word);
 Procedure Lens_Run;
 Procedure Lens_Done;

Implementation

Uses Crt, Dos, Vga, LensGFX1, LensGFX2, DAC;

Var
 Len            : Array [0..140*140] of Word;
 PicSeg         : Word;
 Pic            : Pointer;
 LX,LY,LCount,LS: Word;
 Step, Steps	: LongInt;
 Lissa          : Array [1..502,1..2] of Word;
 NecroPal,
 ZeroPal,FullPal: Array [0..255,1..3] of Byte;

Procedure LoadData;
Begin
 Move(@LensData^,Len,SizeOf(Len));
 UnpackNecro(Pic^);
 UnpackLissa(Lissa);
 Move(@NecroPalette^,NecroPal,768);
End;

Procedure DrawLens(X, Y : Integer; GSeg : Word); Assembler;
Asm
 push ds
 mov ax, PicSeg
 mov ds, ax
 xor si, si                { DS:SI - PicSeg }
 mov ax, GSeg
 mov es, ax
 mov ax, Y
 mov bx, ax
 shl ax, 6
 shl bx, 8
 mov di, ax
 add di, bx
 add di, X
 mov dx, di                { ES:DI - GSeg:Y*320+X }
 mov ax, seg Len
 db $8e,$e8                { mov gs, ax }
 mov bx, offset Len       { GS:BX - Lens }
 mov cx, 140
@yloop:
 push cx
 mov cx, 140
@xloop:
 db $65,$8b,$37            { mov si, gs:[bx] }
 add si, dx
 mov al, ds:[si]
 mov es:[di], al
 inc di
 inc bx
 inc bx
 dec cx
 jnz @xloop
 add di, 320-140
 pop cx
 dec cx
 jnz @yloop
 pop ds
End;

Procedure Lens_Init;
Begin
 FillChar(FullPal,768,63);
 SetPalette(@FullPal);
 FillChar(ZeroPal,768,0);
 InitVPage;
 GetMem(Pic,65000);
 PicSeg:=Seg(Pic^);
 LoadData;
 LCount:=1;
 Steps:=450;
 Step:=0;
End;

Procedure Lens_Setup(NSteps : Word);
Begin
 Steps:=NSteps;
End;

Procedure Lens_Done;
Begin
 FreeMem(Pic,65000);
 DoneVPage;
End;

Procedure Lens_Run;
Begin
 DAC_SetFading(@FullPal,@NecroPal,30);
 While Step<Steps do
 Begin
  DAC_UpdateFading;
  LX:=Lissa[LCount,1];
  LY:=Lissa[LCount,2];
  CopyFake(PicSeg,VSeg);
  DrawLens(LX,LY,VSeg);
  ShowFake(VSeg);
  Inc(LCount);
  If LCount>=503 then LCount:=1;
  Inc(Step);
  If Step=Steps-31 then
  Begin
   DAC_SetFading(@NecroPal,@ZeroPal,30);
  End;
 End;
End;

End.