(* Interrupt Keyboard Handler                           (C) '95 By Paradise *)
Unit Keyboard;
Interface

 Const
  LeftShift    = 42;
  RightShift   = 54;
  Space        = 57;
  Enter        = 28;
  Escape       =  1;
  Tab          = 15;
  Alt          = 56;
  Control      = 29;
  UpKey        = 72;
  DownKey      = 80;
  LeftKey      = 75;
  RightKey     = 77;
  F1           = 59;
  F2           = 60;
  F3           = 61;
  F4           = 62;
  F5           = 63;
  F6           = 64;
  F7           = 65;
  F8           = 66;
  F9           = 67;
  F10          = 68;
  F11          = 87;
  F12          = 88;
  Key1         =  2;
  Key2         =  3;
  Key3         =  4;
  Key4         =  5;
  Key5         =  6;
  Key6         =  7;
  Key7         =  8;
  Key8         =  9;
  Key9         = 10;
  Key0         = 11;
  InsertK      = 82;
  DeleteK      = 83;
  PageUp       = 73;
  PageDown     = 81;
  Home         = 71;
  Ende         = 79;
  Pause        = 69;
  PrtSc        = 55;
  PlusKey      = 78; { gray }
  MinusKey     = 74; { gray }

 Var
  Keys            : Array [0..128] of Boolean;
  Old9Interrupt   : Procedure;

 Procedure InstallKeyboard;
 Procedure ReleaseKeyboard;
 Function  KeyPressed : Boolean;

Implementation
Uses Dos;

Var
 c  : Byte;
 ok : Boolean;

{$F+}
Procedure New9Interrupt; Interrupt;
Begin
 c := port[$60];
 if c>128 then keys[c-128] := false else keys[c] := true;
 Asm
  mov al, 20h
  mov dx, 20h
  out dx, al
 End;
End;
{$F-}

Procedure InstallKeyboard;
Begin
 FillChar(Keys, SizeOf(Keys), False);
 GetIntVec($9, @Old9Interrupt);
 SetIntVec($9, @New9Interrupt);
End;

Procedure ReleaseKeyboard;
Begin
 SetIntVec($9, @Old9Interrupt);
End;

Function KeyPressed;
Begin
 ok := False;
 For c := 0 to 128 do
  If Keys[c] then ok := True;
 KeyPressed := ok;
End;

End.

