{$M 30720,0,655360}

(* Lucifer's Scrolling (C) By Paradise *)

Unit LuciScrl;

Interface

 Procedure LuciScrl_Init;
 Procedure LuciScrl_Setup(LDelay : Word);
 Procedure LuciScrl_Run;
 Procedure LuciScrl_Done;

Implementation

Uses Crt,Vga,FP,LuciGFX1,LuciGFX2;

Type
 PalType  = Array [0..255,1..3] of Byte;

Var
 IncPal   : Array [0..255,1..3] of LongInt;
 WhiPal,
 PicPal,
 MainPal,
 Palette,
 Target   : PalType;
 LDelayed : Word;

{$L LuciferP.Obj}
Procedure LuciferPalette; External;

Procedure InitChain4; Assembler;
Asm
 mov    ax, 13h
 int    10h
 mov    dx, 3c4h
 mov    al, 4
 out    dx, al
 inc    dx
 in     al, dx
 and    al, not 08h
 or     al, 04h
 out    dx, al
 mov    dx, 3ceh
 mov    al, 5
 out    dx, al
 inc    dx
 in     al, dx
 and    al, not 10h
 out    dx, al
 dec    dx
 mov    al, 6
 out    dx, al
 inc    dx
 in     al, dx
 and    al, not 02h
 out    dx, al
 mov    dx, 3c4h
 mov    ax, (0fh shl 8) + 2
 out    dx, ax
 mov    ax, 0a000h
 mov    es, ax
 sub    di, di
 mov    ax, 0000h
 mov    cx, 32768
 cld
 rep    stosw
 mov    dx, 3d4h
 mov    al, 14h
 out    dx, al
 inc    dx
 in     al, dx
 and    al, not 40h
 out    dx, al
 dec    dx
 mov    al, 17h
 out    dx, al
 inc    dx
 in     al, dx
 or     al, 40h
 out    dx, al
 mov    dx, 3d4h
 mov    al, 13h
 out    dx, al
 inc    dx
 mov    al, 40
 out    dx, al
End;

Procedure PutPixel(X,Y : Word; Col : Byte); Assembler;
Asm
 mov    ax,[y]
 xor    bx,bx
 mov    bl,40
 imul   bx
 shl    ax,1
 mov    bx,ax
 mov    ax, [X]
 mov    cx, ax
 shr    ax, 2
 add    bx, ax
 and    cx, 00000011b
 mov    ah, 1
 shl    ah, cl
 mov    dx, 3c4h
 mov    al, 2
 out    dx, ax
 mov    ax, 0a000h
 mov    es, ax
 mov    al, [col]
 mov    es: [bx], al
End;

Procedure Pan(x, y : word);
Var o : word;
Begin
 o:=y*40*2+x;
 Asm
  mov    bx, [o]
  mov    ah, bh
  mov    al, 0ch
  mov    dx, 3d4h
  out    dx, ax
  mov    ah, bl
  mov    al, 0dh
  mov    dx, 3d4h
  out    dx, ax
 End;
End;

Procedure LoadPicture;
Var X, Y : Integer;
Begin
 Move(@LuciferPalette^,PicPal,768);
 For Y:=0 to 199 do
 For X:=0 to 319 do
 Begin
  PutPixel(X,Y+200, Mem[Seg(Lucifer1):Y*320+X]);
 End;
 UnpackLucifer2(VPage^);
 For Y:=0 to 199 do
 For X:=0 to 319 do
 Begin
  PutPixel(X,Y+400, Mem[VSeg:Y*320+X]);
 End;
End;

Procedure CalcFading(P1, P2 : PalType; Steps : Integer);
Var
 i : Integer;
Begin
 For i:=0 to 255 do
 Begin
  IncPal[i,1]:=FixedDiv(I2L(P2[i,1]-P1[i,1]),I2L(Steps));
  IncPal[i,2]:=FixedDiv(I2L(P2[i,2]-P1[i,2]),I2L(Steps));
  IncPal[i,3]:=FixedDiv(I2L(P2[i,3]-P1[i,3]),I2L(Steps));
 End;
 MainPal:=P1;
 Palette:=P1;
 SetPalette(@Palette);
End;

Procedure UpdateFading(Frame : Integer);
Var
 i : Integer;
Begin
 For i:=0 to 255 do
 Begin
  Palette[i,1]:=L2I(I2L(MainPal[i,1])+FixedMul(IncPal[i,1],I2L(Frame)));
  Palette[i,2]:=L2I(I2L(MainPal[i,2])+FixedMul(IncPal[i,2],I2L(Frame)));
  Palette[i,3]:=L2I(I2L(MainPal[i,3])+FixedMul(IncPal[i,3],I2L(Frame)));
 End;
 SetPalette(@Palette);
End;

Procedure LuciScrl_Init;
Begin
 InitVPage;
 FillChar(WhiPal,768,63);
 SetPalette(@WhiPal);
 InitChain4;
 SetPalette(@WhiPal);
 LDelayed:=3000;
End;

Procedure LuciScrl_Setup(LDelay : Word);
Begin
 LDelayed:=LDelay;
End;

Procedure LuciScrl_Done;
Begin
 DoneVPage;
 InitVga;
End;

Procedure LuciScrl_Run;
Var YO : Word;
Begin
 Pan(0,400);
 LoadPicture;
 CalcFading(WhiPal,PicPal,30);
 For YO:=1 to 30 do
 Begin
  UpdateFading(YO);
  VRet;
 End;
 For YO:=400 downto 200 do
 Begin
  Pan(0,YO);
  VRet;
 End;
 Delay(LDelayed);
 For YO:=200 downto 0 do
 Begin
  Pan(0,YO);
  VRet;
 End;
End;

End.
