COMMENT 

                           Read the info file



LOCALS
.model tiny
.386

codesegm        segment byte public 'code' use16
                org     100h
                assume  cs:codesegm, ds:codesegm

s:              call    setstack

; timer routine adapted from fc's starport 2 add.
inittimer       proc
                push    0
                pop     fs
                mov     eax,fs:[8*4]            ;read old timer int.
                mov     oldint8,eax             ;save it
                mov     ax,cs
                shl     eax,16
                mov     ax,offset intti8        ;address of new timer int
                mov     dx,23863 ;50Hz          ;frame rate
                jmp     @@1                     ;when in init
deinittimer:    mov     eax,ds:oldint8          ;set address of old int
                xor     dx,dx                   ;set timer to 18.2Hz
@@1:            cli
                mov     fs:[8*4],eax            ;set new interrupt
                mov     al,036h
                out     43h,al                  ;adjust pit commands
                mov     al,dl
                out     40h,al                  ;adjust speed
                mov     al,dh
                out     40h,al                  ;here too
                sti
                ret
inittimer       endp

intti8          proc far ;timer interrupt
                push    ax                      ;only ax used
                inc     cs:rot                  ;bitmap rotation
                inc     byte ptr cs:sin1        ;moving sin curve
                sub     byte ptr cs:sin2,3
                add     byte ptr cs:sin3,2
                inc     word ptr cs:textcounter ;advance text position counting
                mov     ax,cs:dist
                add     ax,cs:ddi
                mov     cs:dist,ax              ;bitmap zooming
                cmp     ax,355
                jge     @@Kk1
                cmp     ax,1
                jg      @@cont
                mov     ax,cs:imageoffs
                sub     ax,offset Imagedata
                add     ax,1024
                and     ax,0fffh
                add     ax,offset Imagedata
                mov     cs:imageoffs,ax
@@Kk1:          neg     cs:ddi                  ;if at limit, change direction
@@cont:         mov     al,20h                  ;tell pic new interrupts are
                out     20h,al                  ; allowed
                pop     ax
                iret
intti8          endp

setstack        proc                            ;this routine sets the stack
                inc     bp                      ;the way we want it.
                pop     ax
                inc     bx
                inc     bp
                push    ax
                push    sp
                dec     cx
                dec     di
                dec     si
                sbb     cl,bl
                pop     es
                pop     di
                jmp     [cs:retard]
setstack        endp

startaddr       proc    near            ;start addr in cs:curadd
                mov     dx,3dah
@@WaitDE:       in      al,dx           ;wait until retrace not in progress
                test    al,01h
                jnz     @@WaitDE
                mov     bx,cs:curadd
                mov     dx,3d4h
                mov     al,0dh
                mov     ah,bl
                out     dx,ax           ;tell crtc start addr data coming
                dec     al
                mov     ah,bh
                out     dx,ax           ;send start adress
                mov     dx,3dah
@@WaitVS:       in      al,dx           ;vertical retrace?
                test    al,08h
                jz      @@WaitVS
                ret
startaddr       endp

MakeSintbl      proc
                mov     di,offset sintbl;load destination in es:di
                mov     si,offset sinbasetbl    ;we assume ds is right
                mov     dx,64
                mov     cx,dx           ;then we toy around with our
                                        ;sin table.
                sub     ah,ah
@@Looppi1:      lodsb
                stosw
                loop    @@Looppi1
                mov     cx,dx
@@Looppi2:      std
                lodsb
                cld
                stosw
                loop    @@Looppi2
                mov     cx,dx
                shl     cx,1
                mov     si,offset sintbl
@@Looppi3:      lodsw
                neg     ax
                stosw
                loop    @@Looppi3
                ret
MakeSintbl      endp

DrawScreen      proc            ;cl=rot, ax=scale, dx=y, bx=x
                push    bx
                push    dx
                sub     ch,ch
                push    cx
                mov     si,cx
                shl     si,1            ;si points to sin table
                mov     di,64
                sub     di,cx
                and     di,255
                shl     di,1            ;di points to cos table
                mov     cx,[di+offset sintbl]
                mov     bx,ax           ;store scale in bx
                imul    cx
                shl     eax,16
                mov     ax,dx
                rol     eax,16
                shr     eax,5           ;/32
                mov     ddx,ax          ;ddx=Temp;

                mov     cx,[si+offset sintbl]
                mov     ax,bx
                imul    cx
                shl     eax,16
                mov     ax,dx
                rol     eax,16
                shr     eax,8           ;Temp=SinTable[rot]*scale / 256;
                mov     ddy,ax          ;ddy=Temp;

                pop     cx
                mov     si,cx
                add     si,64
                and     si,255
                shl     si,1            ;si points to sin table again
                sub     di,di
                sub     di,cx
                and     di,255
                shl     di,1            ;di points to cos table again

                mov     ax,bx
                mov     cx,[di+offset sintbl]
                imul    cx
                shl     eax,16
                mov     ax,dx
                rol     eax,16
                shr     eax,5           ;/32
                mov     d2x,ax          ;d2x=temp;

                mov     ax,bx
                mov     cx,[si+offset sintbl]
                imul    cx
                shl     eax,16
                mov     ax,dx
                rol     eax,16
                shr     eax,8           ;Temp=Sin2Table[rot]*scale / 256;
                mov     d2y,ax          ;d2y=temp;


                mul     roty            ;rotate around the center of the screen
                mov     cx,ax           ;move d2y*100 into cx
                mov     ax,ddy
                mul     rotx            ;rotate around the center of the screen
                pop     dx              ;move y into dx
                sub     dx,ax
                sub     dx,cx           ;j=y-ddy*160-d2y*100;
                mov     j,dx

                mov     ax,d2x
                mul     roty            ;rotate around the center of the screen
                mov     cx,ax           ;move d2y*100 into cx
                mov     ax,ddx
                mul     rotx            ;rotate around the center of the screen
                pop     dx              ;move y into dx
                sub     dx,ax
                sub     dx,cx           ;i=x-ddx*160-d2x*100;
                mov     i,dx

                mov     di,curadd       ;set counter to upperleft corner of
                                        ;screen
                push    0a000h
                pop     es              ;set es to videomem
                mov     cx,200          ;number of rows on screen
vloop:          mov     gs,cx           ;use gs instead of stack <grin>
                mov     dx,i            ;start scanning the bitmap in (i,j)
                mov     ax,j            ;which were calculated before
                mov     cx,8            ;Number of columns on screen
hloop:          mov     fs,cx           ;use fs instead of stack <grin>
                mov     cx,16           ;16 bits in a word (oh really?)
@@Looppi:       add     dx,[ddx]        ;add 'right' vector to the current
                add     ax,[ddy]        ;bitmap coordinates. 8.8 fixed point

                sub     bh,bh
                mov     bl,ah
                shl     bx,5            ;multiply by 32 (32)
                mov     bp,dx
                shr     bp,11           ;bp=x/1024
                add     bx,bp

                and     bx,03ffh                ;and with size of the picture -1
                add     bx,imageoffs
                mov     bl,[bx]                 ;get the byte
                sub     bh,bh
                shl     si,1
                or      si,bx           ;put it in our temporary word
                loop    @@Looppi
                mov     cx,fs           ;reload cx from fs
                mov     bx,si
                xchg    bl,bh           ;funny byte order toying
                mov     es:[di],bx
                add     di,2
                loop    hloop           ;end of horiz loop
                add     di,24
                mov     ax,d2x
                add     i,ax            ;i and j are the starting coords for
                                        ;the line
                mov     ax,d2y
                add     j,ax
                mov     cx,gs           ;restore the vloop count
                loop    vloop
                ret
DrawScreen      endp

SinPlane        proc    ;dest. in di
                push    0a000h
                pop     es
                sub     si,si
                mov     dx,3c4h
                mov     ax,0402h
                out     dx,ax           ;select output plane
                mov     dx,200
@@spl0:         mov     ax,[si+offset sintbl]
                add     si,10
                and     si,511
                sar     ax,4
                add     ax,113          ;true x-coordinate
                mov     bx,ax
                shr     bx,3            ;real address of first byte
                mov     cl,al
                and     cl,7
                mov     al,0ffh         ;first byte
                shr     al,cl
                add     di,bx           ;put it in di
                stosb                   ;output first byte
                mov     cx,39
                sub     cx,bx
                mov     al,0ffh
                rep     stosb           ;output the rest
                dec     dx
                jnz     @@spl0
                ret
SinPlane        endp

SinPlane2       proc
                push    0a000h
                pop     es
                mov     di,curadd
                mov     si,word ptr rot
                shl     si,2
                and     si,511
                mov     dx,3c4h
                mov     ax,0202h
                out     dx,ax           ;select output plane
                mov     dx,200
@@spl0:         mov     bx,sin1
                shl     bx,1
                add     bx,si
                and     bx,511
                mov     ax,[bx+offset sintbl]
                mov     bx,sin2
                shl     bx,1
                add     bx,si
                and     bx,511
                mov     ax,[bx+offset sintbl]
                mov     bx,sin3
                shl     bx,1
                add     bx,si
                add     bx,si
                and     bx,511
                add     ax,[bx+offset sintbl]

                add     si,4
                and     si,511          ;read sin in ax
                sar     ax,4            ;divide by 16, now it's -x..x (?)
                add     ax,64           ;true x-coordinate
                mov     bx,ax
                shr     bx,3            ;real address of first byte
                mov     cx,bx
                push    ax
                sub     al,al
                rep     stosb           ;write until first byte
                pop     ax
                mov     cl,al
                and     cl,7
                mov     al,0ffh         ;first byte
                shr     al,cl
                mov     cs:retard,offset endit
                stosb                   ;output first byte
                mov     cx,20
                mov     ah,al
                mov     al,0ffh
                rep     stosb           ;constant width
                mov     al,ah
                not     al
                stosb                   ;last byte
                mov     cx,18
                sub     cx,bx
                sub     al,al
                rep     stosb
                dec     dx
                jnz     @@spl0
                ret
SinPlane2       endp

decode          proc    ;si=bit "packed" buffer addr, di=dest. for byte data
                mov     bp,512          ;this decodes 64x64x2 stuff
@@perbyte:      lodsb                   ;load next byte
                mov     dl,al           ;move into dl for storage
                mov     bx,7            ;first bit
                mov     cx,8            ;run 8 times per byte
@@perbit:       bt      dx,bx           ;set cf if bit bx is set in dx
                setc    al              ;if cf, set al=1, else al=0
                stosb                   ;stash that byte
                dec     bx              ;next bit
                loop    @@perbit        ;next bit
                dec     bp
                jnz     @@perbyte       ;next byte
                ret
decode          endp

calvin          proc    ;draws calvin on the screen, es:di where to
                mov     dx,3c4h
                mov     ax,0402h
                out     dx,ax           ;select output plane
                mov     si,offset calvpic
                mov     dx,62
@@y:            mov     cx,19
                rep     movsb
                add     di,40-19
                dec     dx
                jnz     @@y
                ret
calvin          endp

start:          mov     ax,01130h
                mov     bh,3
                int     10h                     ; es:bp = 8x8 font
                push    es
                pop     ds
                mov     si,bp                   ; ds:si = es:bp
                push    cs
                pop     es
                mov     di,offset biosfont      ; es:di = font
                mov     cx,2048
                rep     movsw

                push    cs
                pop     ds
                push    cs
                pop     es

                mov     si,offset encoded_1
                mov     di,offset imagedata
                call    decode

                call    MakeSintbl

                mov     ax,0Dh                 ;320x200x16 (EGA/VGA)
                int     10h

                mov     ax,1000h
		sub	bx,bx
		mov	cx,16
@kalapal:	pusha
		int	10h
		popa
		inc	bl
		inc	bh
                loop    @kalapal                ;remap the palette positions
                mov     cx,48
                sub     al,al
                mov     dx,3c8h
                out     dx,al
                inc     dx
                mov     si,offset palette
                rep     outsb                   ;output the funny palette

                mov     ax,cs
                add     ax,5120                 ;select text buffer segment
                mov     textseg,ax

                sub     di,di                   ;stuff first page's sin
                call    sinplane                ; curve
                mov     di,8192                 ;stuff second page
                call    sinplane

                mov     di,130*40+19
                call    calvin
                mov     di,8192+(130*40+19)
                call    calvin

                call    inittimer               ;put the jolly timer to work

@@Loooppi:      mov     dx,03c4h
                mov     ax,0102h
                out     dx,ax

                mov     ax,dist
                mov     cl,rot
                mov     dx,y
                mov     bx,x
                call    DrawScreen              ;do the bitmap `thing'

                call    sinplane2               ;the changing sin tbl

                mov     cx,textcounter
                and     cx,cx
                jz      @@endofloop
@@doggie:       push    cx                      ;we're 100% sure cx will be
                                                ;modified
                cmp     textstat1,0             ;are we going in?
                jne     @@nottextin             ;no, do something else
                cmp     textstat2,200           ;first frame?
                jne     @@nocreate              ;no, do something else
                call    text                    ;create text
@@nocreate:     mov     ax,textcury
                add     ax,textcdir
                mov     textcury,ax
                dec     textstat2
                jnz     @@andnext
                inc     textstat1
                mov     textstat2,50*4
                jmp     @@andnext
@@nottextin:    cmp     textstat1,1
                jne     @@notwait
                dec     textstat2
                jnz     @@andnext
                inc     textstat1
                mov     textstat2,200
                jmp     @@andnext
@@notwait:      mov     ax,textcury
                add     ax,textcdir
                mov     textcury,ax
                dec     textstat2
                jnz     @@andnext
                mov     textstat1,0
                mov     textstat2,200
@@andnext:      pop     cx
                loop    @@doggie
@@endofloop:    mov     word ptr textcounter,0  ;restart looping
                call    outputtext

                call    startaddr
                xor     curadd,8192
                mov     ah,01
                int     16h
                jz      @@Loooppi

@@Endi:         push    0
                pop     fs
                call    deinittimer             ;remove the timer
                call    setstack                ;set the stack to normal
endit:          mov     ax,03h                  ;reset video mode
                int     10h
                push    0b800h
                pop     es
                sub     di,di
                mov     si,offset vittu
                mov     cx,80
                rep     movsw
                mov     dx,offset koira
                mov     ah,9
                int     21h
                ret

koira   db      13,10,10,36

vittu label byte
        db      '<',25,'',25,'=',25,'-',25,' ',24,' ',24,' ',24,' ',24
        db      ' ',24,' ',24,'E',27,'x',27,'c',27,'e',27,'p',27,'t',27
        db      'i',27,'o',27,'n',27,' ',27,'1',27,'3',27,' ',27,' ',27
        db      '+',23,'3',23,'5',23,'8',23,'-',23,'0',23,'-',23,'2',23
        db      '9',23,'4',23,'-',23,'4',23,'1',23,'2',23,'0',23,' ',23
        db      'v',19,'3',19,'2',19,'b',19,'i',19,'s',19,',',19,' ',19
        db      '2',19,'4',19,'h',19,' ',19,' ',19,'E',27,'x',27,'p',27
        db      'e',27,'r',27,'i',27,'m',27,'e',27,'n',27,'t',27,' ',27
        db      'W',27,'H',27,'Q',27,' ',26,' ',26,' ',26,' ',26,' ',26
        db      ' ',26,' ',26,' ',26,' ',26,'-',25,'=',25,'',25,'>',25

text            proc    near
                neg     textcdir                ;change direction
                push    es
                push    textseg
                pop     es
                sub     di,di                   ;es:di points to text segment
                mov     si,textptr              ;ds:si points to texts
                mov     cx,900*40
                sub     al,al
                rep     stosb                   ;clear buffer
                sub     di,di
                lodsb                           ;load number of lines
                cmp     al,0ffh
                jne     @@noteop                ;not end of pages
                mov     si,offset texts         ;wrap
                lodsb                           ;load number of lines
@@noteop:       mov     dl,al
                sub     dh,dh                   ;dx=number of lines on screen
                mov     bp,dx                   ;bp=-"-
                mov     di,300                  ;number of scanlines in buffer/2
                shl     dx,2                    ;dx*=4, 8x8 font
                sub     di,dx                   ;di=number of first scanline
                imul    di,40                   ;hahahha! don't give shit
                                                ;about 9-14 cycles on a 386
                ;output text
@@genlb2:       lodsb                           ;line length in al
                and     al,al
                jz      @@genlb5                ;zero text length, don't draw
                sub     ah,ah                   ;line length now 16bit
                mov     bx,40
                sub     bx,ax
                shr     bx,1                    ;offset of 1st character on row
                mov     dx,ax                   ;loop ax times
                push    di                      ;di stored
                add     di,bx                   ;line starting addr in di
@@genlb3:       lodsb                           ;current character in al
                sub     ah,ah
                push    di                      ;di stored
                mov     bx,ax                   ;bx pointer to character
                shl     bx,3
                mov     cx,8
@@chry:         mov     al,[bx+offset biosfont] ;load character data in al
                stosb                           ;put it in the buffer
                add     di,39                   ;next line
                inc     bx
                loop    @@chry
                pop     di                      ;di restored
                inc     di                      ;advance di to next char
                dec     dx
                jnz     @@genlb3
                pop     di                      ;di restored
@@genlb5:       add     di,8*40                 ;advance di to next line
                dec     bp
                jnz     @@genlb2

                mov     textptr,si
                cmp     textcdir,0              ;which direction are we going
                jl      @@godown                ;text goes down
                mov     textcury,0              ;text goes up
                jmp     @@outfish
@@godown:       mov     textcury,400*40         ;stuff
@@outfish:      pop     es
                ret
text            endp

retard          dw      offset start

outputtext      proc    near
                push    ds
                mov     si,textcury
                mov     di,curadd               ;es:di = screen
                push    textseg
                pop     ds                      ;ds:si = text buffer

                mov     dx,03c4h
                mov     ax,0802h
                out     dx,ax

                mov     cx,4000
                rep     movsw
                pop     ds
@@noincr:       ret
outputtext      endp


;sin table for angles 0-64, cos table is sin(64-angle)

sinbasetbl      db        0,  6, 13, 19, 25, 31, 38, 44
                db       50, 56, 62, 68, 74, 80, 86, 92
                db       98,104,109,115,121,126,132,137
                db      142,147,152,157,162,167,172,177
                db      181,185,190,194,198,202,206,209
                db      213,216,220,223,226,229,231,234
                db      237,239,241,243,245,247,248,250
                db      251,252,253,254,255,255,255,255,255

encoded_1       label   byte
        include img.inc

calvpic         label   byte
        include pallo.inc

palette         label   byte
        include pal.inc

curadd          dw      8192
rot             db      0
                db      0
x               dw      16
y               dw      16
dist            dw      127
ddi             dw      2
rotx            dw      64
roty            dw      100
sin1            dw      0
sin2            dw      32
sin3            dw      64

textstat1       db      0                       ;0=scroll in, 1=wait
                                                ;2=scroll out
textstat2       db      200                     ;number of frames to wait more

textcdir        dw      40                      ;increase y or decrease
textcounter     dw      0                       ;number of frames to process
textptr         dw      offset texts            ;text buffer address

;text structure:
; 1st byte              : number of lines on next screen or 0ffh for loop
; 1st byte of each line : number of characters on line, max 40
                          ;          1         2         3         4
texts           db      5 ; 1234567890123456789012345678901234567890
                db      23,"E X C E P T I O N   1 3"
                db      0
                db      18,"+358-(9)0-294-4120"
                db      0
                db      19,"Experiment World HQ"
                db      6
                db      14,"4.320 Gbits of"
                db      0
                db      7, "sources"
                db      24,"programming docs & tools"
                db      16,"quality graphics"
                db      24,"other demo related stuff"

                db      9
                db      25,"Experiment is looking for"
                db      0
                db      18,"Talented musicians"
                db      16,"Graphics artists"
                db      17,"Productive coders"
                db      0
                db      36,"Those who are interested give a call"
                db      28,"to Exception 13 or E-mail to"
                db      19,"olliv@mits.mdata.fi"

                db      7
                db      30,"Credits for this advertisement"
                db      0
                db       5,"Code:"
                db      22,"Condor and Xaya Iccita"
                db      0
                db       9,"Graphics:"
                db       5,"Price"

                db      7
                db      14,"Condor greets:"
                db      0
                db      26,"Trancer, Treeman, Feather,"
                db      20,"Shaq, Mik, Wildfire,"
                db      33,"Breeze/CC - thnx for the gametune"
                db      27,"- The game is a bit delayed"
                db      25,"all others I think I know"

                db      3
                db      13,"Price shouts:"
                db      0
                db      34,'"',"I don't need no stinkin' greets!",'"'

                          ;          1         2         3         4
                db      10; 1234567890123456789012345678901234567890
                db      30,"Xaya waves his coke bottle at:"
                db      30,"(in random order, so to speak)"
                db      0
                db      35,"Me, myself, I, Trancer, Pizza/Corp,"
                db      33,"Treeman, V.Viper, Siamese, Trurl,"
                db      37,"haaki, latexi, Jeffu, Anti-LA, Kauhu,"
                db      32,"Ratter, Breeze and all others in"
                db      33,"Capacala, Wog, AIDS, Astro, Rave,"
                db      34,"Mellow-D, void/hSA, Weasel, Trane,"
                db      37,"Shaq, Feather, and y'all who know me."

                db      0ffh

softkill        db      "hboot",13,0

imageoffs       dw      offset Imagedata

textcury        dw      ?                       ;current y
textseg         dw      ?                       ;segment for text buffer

ddx             dw      ?
ddy             dw      ?
d2x             dw      ?
d2y             dw      ?
i               dw      ?
j               dw      ?
oldint8         dd      ?
sintbl          dw      256 dup (?)
Imagedata       label byte
                dw      4096 dup (?)
biosfont        db      16*256 dup (?)
codesegm        ends
                end     s
