/* RGPG Game project file
 *
 * RolePlayng Game Programmers Group
 * http://www.geocities.com/SiliconValley/Heights/8254/rgpg.htm
 *
 * If you hack or modify this file, please put an entry in the file
 * history, so people know who to consult about the changes.
 *
 * File History:
 * --------------------------------------------
 * 01/29/97 Daniel White     Created   (dpwhite@flash.lakeheadu.ca)
 *
 *
 */

/* Tile class
 *
 * This is the basic class of each tile of a map.  Note that it does
 * not contain information on an image, but it does have a reference
 * to a "TileImage".  If a map has 50 forest tiles, and 250 plains
 * tiles, you only need to keep 1 copy of each tile image.
 *
 */

public class Tile {
    // Instance Variables
    /////////////////////
    private int       type;     // A number indicating what kind
                                // of tile it is.
    private TileImage tImage;   // a reference to a tile's image.
    private int       height;   // height of tile (for multiple lvl maps)
    private BitSet    flags;    // a set of saved bits for various possible
                                // special conditions
    private Vector    inventory;// list of items that are inside the tile
                                // eg: a sword lying on the ground

    private String    mapLink;  // URL to the map to be loaded if someone
                                // enters this location.  Used for towns in a
                                // wilderness map, or houses in a town setting, etc.

    // Instance Methods
    ///////////////////

    // Note I have Image returning methods here - the TileMap class
    //      should gather the images, and actually paint to the applet
    //      window.
    public Image getImage() {
        // Takes image from TileImage, and paints on top any items that
        // are in the Inventory. (hopefully, they have some transparency
        // them, so the underlying terrain is still visible)
    }

    public Image getBaseImage() {
        // returns the image of the terrain only
    }

    public boolean isTransparent() {
        // Tests flags to check for transparency of tile
    }

    public boolean canMoveTo(int moveType) {
        // Tests if a player or beastie object can move into this tile
        // * final static vars below define movement Types
        // * also, probably checks bits in the 'flags' BitSet.
    }

    public Item getItem(String itemName) {
        // Searches the tile's inventory for a named item and returns it,
        // removing it from inventory.
    }

    public Item peekItem(String itemName) {
        // Searches the tile's inventory for a named item, and returns it,
        // but leaves it in the tile's inventory.
    }

    public Item putItem(Item droppedItem) {
        // Adds an item to the tile's inventory (it is dropped)
    }

    public String getLink() { return mapLink; }

    public void setLink(String newLink) { mapLink = newLink; }


    // Constructor(s)
    public Tile(int newType, TileImage ti, int newHeight, BitSet newFlags) {
        // Set instance variables and initialize.
        type = newType;
        tImage = ti;
        height = newHeight;
        flags = newFlags;
        inventory = new Vector(1,1);
        mapLink = null;
    }

    // Class Variables
    //////////////////
    public static final int MOVE_WALK = 0; // normal, default movement.
    public static final int MOVE_SWIM = 1; // Can you swim?
    public static final int MOVE_RIDE = 2; // i.e. Riding a horse.
    public static final int MOVE_FLY  = 3; // By magic spell or item?
}


