//////////////////////////////////////////////////////////////
// Jade.java
// 
// Jade demo example 1
//
// Copyright (C) 1996 Kwan Software Research
// All rights reserved.
//
// Please send email to: tkwan@aa.net for license detail.
//
//////////////////////////////////////////////////////////////

import java.awt.*;
import java.applet.*;
import java.net.*;
import java.io.*;

public class Jade extends Applet implements Runnable
{
    public static void PrintError(JadeDB db, int fType )
    {
        OutString state=new OutString("");
        OutLong Error=new OutLong(0);
        OutString ErrorMsg=new OutString("");

        db.SQLError( fType, state, Error, ErrorMsg );
        System.err.println( state+" "+Error+" "+ErrorMsg);
    }

    public static void AnotherTest()
    {
        JadeDB db = new JadeDB("moon", 4201);
        db.debug = true;
        do
        {
            long err = db.SQLConnect("test", "sa", "") ;
            if (( err == db.SQL_ERROR ) || ( err == db.SQL_SUCCESS_WITH_INFO ))
            {
                PrintError( db, db.SQL_ERROR_CONNECT );
                if (err == db.SQL_ERROR )
                    break;
            }

            do
            {
                if (db.SQLExecDirect("CREATE TABLE NAMEID (ID integer, NAME varchar(50))") != db.SQL_SUCCESS )
                {
                    PrintError( db, db.SQL_ERROR_HSTMT );
                    //break;
                }

                db.SQLTransact( db.SQL_COMMIT );

                if ( db.SQLPrepare("INSERT INTO NAMEID VALUES (?, ?)") != db.SQL_SUCCESS )
                {
                    PrintError( db, db.SQL_ERROR_HSTMT );
                    //break;
                }

                db.JadeResetBindVector();
                OutInteger Id= new OutInteger(500);
                OutString name=  new OutString("Baddage");
                db.SQLBindParameter( 1, db.SQL_PARAM_INPUT, db.SQL_C_SLONG, db.SQL_INTEGER, 0, 0, Id );
                db.SQLBindParameter( 2, db.SQL_PARAM_INPUT, db.SQL_C_CHAR, db.SQL_VARCHAR, 50, 0, name );

                db.JadeSQLSetValues();

                if ( db.SQLExecute() != db.SQL_SUCCESS )
                {
                    PrintError( db, db.SQL_ERROR_HSTMT );
                    //break;
                }

                Id.set(100);
                name.string="bear";

                db.JadeSQLSetValues();

                if ( db.SQLExecute() != db.SQL_SUCCESS )
                {
                    PrintError( db, db.SQL_ERROR_HSTMT );
                    //break;
                }

                Id.set(25);
                name.string="dog";

                db.JadeSQLSetValues();

                if ( db.SQLExecute() != db.SQL_SUCCESS )
                {
                    PrintError( db, db.SQL_ERROR_HSTMT );
                    //break;
                }

                db.SQLTransact( db.SQL_COMMIT );

                if ( db.SQLExecDirect( "SELECT ID, NAME FROM NAMEID" ) != db.SQL_SUCCESS )
                {
                    PrintError( db, db.SQL_ERROR_HSTMT );
                    //break;
                }

                Id.nValue = 0;
                name.string="";

                db.JadeResetBindVector();
                db.SQLBindCol( 1, db.SQL_C_SLONG, Id );
                db.SQLBindCol( 2, db.SQL_C_CHAR, name );
                while (true)
                {
                    if ( db.SQLFetch() != db.SQL_SUCCESS )
                        break;
                
                    db.JadeSQLGetValues();
                    db.SQLTransact( db.SQL_COMMIT );
    
                    System.err.println("Id:"+Id);
                    System.err.println("name:"+name);
                }
            }  while(false);

            db.SQLDisconnect();
        } while (false);

    }
    public static void TestColumns( JadeDB db )
    {
        if ( db.SQLColumns("","","Addresses", "" ) == db.SQL_SUCCESS )
        {
            OutString szQualifier = new OutString("");
            OutString szOwner = new OutString("");
            OutString szTableName = new OutString("");
            OutString szColName = new OutString("");
            OutString szTypeName = new OutString("");
            OutString szRemark = new OutString("");
            OutShort sDataType = new OutShort(0);
            OutShort sScale = new OutShort(0);
            OutShort sRadix = new OutShort(0);
            OutShort sNullable = new OutShort(0);
            OutLong lPrecision = new OutLong(0);
            OutLong lLength = new OutLong(0);

            // bind the columns
            db.SQLBindCol( 1, db.SQL_C_CHAR, szQualifier );
            db.SQLBindCol( 2, db.SQL_C_CHAR, szOwner );
            db.SQLBindCol( 3, db.SQL_C_CHAR, szTableName );
            db.SQLBindCol( 4, db.SQL_C_CHAR, szColName );
            db.SQLBindCol( 5, db.SQL_C_SSHORT, sDataType );
            db.SQLBindCol( 6, db.SQL_C_CHAR, szTypeName );
            db.SQLBindCol( 7, db.SQL_C_SLONG, lPrecision );
            db.SQLBindCol( 8, db.SQL_C_SLONG, lLength );
            db.SQLBindCol( 9, db.SQL_C_SSHORT, sScale );
            db.SQLBindCol( 10, db.SQL_C_SSHORT, sRadix );
            db.SQLBindCol( 11, db.SQL_C_SSHORT, sNullable );
            db.SQLBindCol( 12, db.SQL_C_CHAR, szRemark );

            while (true)
            {
                if ( db.SQLFetch() != db.SQL_SUCCESS )
                    break;

                System.err.println( szQualifier+" "+szOwner+" "+szTableName );
                System.err.println( szColName+" "+sDataType+" "+szTypeName );
                System.err.println( lPrecision+" "+lLength+" "+sScale );
                System.err.println( sRadix+" "+sNullable+" "+szRemark );
            }
        } else
        {
            PrintError( db, db.SQL_ERROR_HSTMT );
        }
    }

    public static void TestGetInfo( JadeDB db )
    {
        OutString out=new OutString("");

        if ( db.SQLGetInfo( db.SQL_DATA_SOURCE_NAME, out ) != db.SQL_ERROR )
        {
            System.err.println( "data source name: "+out );
        }

        OutInteger nInt= new OutInteger(0);

        if ( db.SQLGetInfo( db.SQL_ACTIVE_CONNECTIONS, nInt ) != db.SQL_ERROR )
        {
            System.err.println( "Active connections: "+nInt );
        }

        OutLong nLong = new OutLong(0);

        if ( db.SQLGetInfo( db.SQL_SYSTEM_FUNCTIONS, nLong ) != db.SQL_ERROR )
        {
            System.err.println( "System Functions: "+nLong );
        }

        if ( db.SQLGetInfo( db.SQL_DATABASE_NAME, out ) != db.SQL_ERROR )
        {
            System.err.println( "Database name: "+out );
        }

        if ( db.SQLGetInfo( db.SQL_DBMS_NAME, out ) != db.SQL_ERROR )
        {
            System.err.println( "DBMS name: "+out.string );
        }

        if ( db.SQLGetInfo( db.SQL_DBMS_VER, out ) != db.SQL_ERROR )
        {
            System.err.println( "DBMS Ver: "+out );
        }

        if ( db.SQLGetInfo( db.SQL_DRIVER_NAME, out ) != db.SQL_ERROR )
        {
            System.err.println( "DRIVER Name: "+out );
        }

        if ( db.SQLGetInfo( db.SQL_DRIVER_VER, out ) != db.SQL_ERROR )
        {
            System.err.println( "Driver Ver: "+out );
        }
    }

    public static void TestGetDrivers( JadeDB db )
    {
        OutString Des=new OutString("");
        OutString Att=new OutString("");
        
        while ( db.SQLDrivers( db.SQL_FETCH_NEXT, Des, Att ) == db.SQL_SUCCESS )
        {
            System.err.println("Des: "+Des);
            System.err.println("Att: "+Att);
        }
    }

    public static void TestBindCol( JadeDB db )
    {
        OutInteger id = new OutInteger(0);
        OutString strFirstName=new OutString("");
        OutString strLastName=new OutString("");
        OutString strSpouseName=new OutString("");
        OutString strAddress=new OutString("");
        OutString strCity=new OutString("");
        OutString strState=new OutString("");
        OutString strPostal=new OutString("");
        OutString strCountry=new OutString("");
        OutString strEmail=new OutString("");
        OutString strHome=new OutString("");
        OutString strWork=new OutString("");
        OutString strWorkExt=new OutString("");
        OutString strFax=new OutString("");
        OutTimestamp tsBirthday=new OutTimestamp(0,0,0,0,0,0,0);
        OutBit Send=new OutBit(0);

        db.JadeResetBindVector();
        db.SQLBindCol( 1, db.SQL_C_LONG, id );
        db.SQLBindCol( 2, db.SQL_C_CHAR, strFirstName );
        db.SQLBindCol( 3, db.SQL_C_CHAR, strLastName );
        db.SQLBindCol( 4, db.SQL_C_CHAR, strSpouseName );
        db.SQLBindCol( 5, db.SQL_C_CHAR, strAddress );
        db.SQLBindCol( 6, db.SQL_C_CHAR, strCity );
        db.SQLBindCol( 7, db.SQL_C_CHAR, strState );
        db.SQLBindCol( 8, db.SQL_C_CHAR, strPostal );
        db.SQLBindCol( 9, db.SQL_C_CHAR, strCountry );
        db.SQLBindCol( 10, db.SQL_C_CHAR, strEmail );
        db.SQLBindCol( 11, db.SQL_C_CHAR, strHome );
        db.SQLBindCol( 12, db.SQL_C_CHAR, strWork );
        db.SQLBindCol( 13, db.SQL_C_CHAR, strWorkExt );
        db.SQLBindCol( 14, db.SQL_C_CHAR, strFax );
        db.SQLBindCol( 15, db.SQL_C_TIMESTAMP, tsBirthday );
        db.SQLBindCol( 16, db.SQL_C_BIT, Send );

        while (true)
        {
            if ( db.SQLFetch() != db.SQL_SUCCESS )
                break;

            // test for get data
            OutInteger id1 = new OutInteger(0);
            OutString strFirstName1=new OutString("");
            OutString strLastName1=new OutString("");
            OutString strSpouseName1=new OutString("");
            OutString strAddress1=new OutString("");
            OutString strCity1=new OutString("");
            OutString strState1=new OutString("");
            OutString strPostal1=new OutString("");
            OutString strCountry1=new OutString("");
            OutString strEmail1=new OutString("");
            OutString strHome1=new OutString("");
            OutString strWork1=new OutString("");
            OutString strWorkExt1=new OutString("");
            OutString strFax1=new OutString("");
            OutTimestamp tsBirthday1=new OutTimestamp(0,0,0,0,0,0,0);
            OutBit Send1=new OutBit(0);
            db.SQLGetData( 1, db.SQL_C_LONG, id1 );
            db.SQLGetData( 2, db.SQL_C_CHAR, strFirstName1 );
            db.SQLGetData( 3, db.SQL_C_CHAR, strLastName1 );
            db.SQLGetData( 4, db.SQL_C_CHAR, strSpouseName1 );
            db.SQLGetData( 5, db.SQL_C_CHAR, strAddress1 );
            db.SQLGetData( 6, db.SQL_C_CHAR, strCity1 );
            db.SQLGetData( 7, db.SQL_C_CHAR, strState1 );
            db.SQLGetData( 8, db.SQL_C_CHAR, strPostal1 );
            db.SQLGetData( 9, db.SQL_C_CHAR, strCountry1 );
            db.SQLGetData( 10, db.SQL_C_CHAR, strEmail1 );
            db.SQLGetData( 11, db.SQL_C_CHAR, strHome1 );
            db.SQLGetData( 12, db.SQL_C_CHAR, strWork1 );
            db.SQLGetData( 13, db.SQL_C_CHAR, strWorkExt1 );
            db.SQLGetData( 14, db.SQL_C_CHAR, strFax1 );
            db.SQLGetData( 15, db.SQL_C_TIMESTAMP, tsBirthday1 );
            db.SQLGetData( 16, db.SQL_C_BIT, Send1 );
            System.err.println(id1+" First Name: "+strFirstName1+" Last Name: "+strLastName1+" Spouse Name: "+strSpouseName1 );
            System.err.println("Address: "+strAddress1 );
            System.err.println(strCity1+" "+strState1 );
            System.err.println(strPostal1+" "+strCountry1 );
            System.err.println(strEmail1+" "+strHome1+" "+strWork1 );
            System.err.println(strWorkExt1+" "+strFax1 );
            System.err.println( tsBirthday1 );
            System.err.println( "Send: "+Send1 );

            // test for get value

            db.JadeSQLGetValues();
            //db.SQLTransact( db.SQL_COMMIT );

            System.err.println(id+" First Name: "+strFirstName+" Last Name: "+strLastName+" Spouse Name: "+strSpouseName );
            System.err.println("Address: "+strAddress );
            System.err.println(strCity+" "+strState );
            System.err.println(strPostal+" "+strCountry );
            System.err.println(strEmail+" "+strHome+" "+strWork );
            System.err.println(strWorkExt+" "+strFax );
            System.err.println( tsBirthday );
            System.err.println( "Send: "+Send );
        }
    }

    public static void TestColAttributes( JadeDB db )
    {
        OutString   strDesc = new OutString("");
        OutLong     lDesc = new OutLong(0);

        db.SQLColAttributes( 0, db.SQL_COLUMN_COUNT, strDesc, lDesc );
        System.err.println("Total Column # = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_AUTO_INCREMENT, strDesc, lDesc );
        System.err.println("Auto Increment = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_CASE_SENSITIVE, strDesc, lDesc );
        System.err.println("Case Senitive = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_DISPLAY_SIZE, strDesc, lDesc );
        System.err.println("Column Display Size = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_LABEL, strDesc, lDesc );
        System.err.println("Column Lable = "+strDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_LENGTH, strDesc, lDesc );
        System.err.println("Column Length = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_MONEY, strDesc, lDesc );
        System.err.println("Column Money = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_NAME, strDesc, lDesc );
        System.err.println("Column NAME = "+strDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_NULLABLE, strDesc, lDesc );
        System.err.println("Column Nullable = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_OWNER_NAME, strDesc, lDesc );
        System.err.println("Column Owner Name = "+strDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_PRECISION, strDesc, lDesc );
        System.err.println("Column Precision = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_QUALIFIER_NAME, strDesc, lDesc );
        System.err.println("Column Qualifier Name = "+strDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_SCALE, strDesc, lDesc );
        System.err.println("Column Scale = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_SEARCHABLE, strDesc, lDesc );
        System.err.println("Column Searchable = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_TABLE_NAME, strDesc, lDesc );
        System.err.println("Column Table Name = "+strDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_TYPE, strDesc, lDesc );
        System.err.println("Column Type = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_TYPE_NAME, strDesc, lDesc );
        System.err.println("Column Type Name = "+strDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_UNSIGNED, strDesc, lDesc );
        System.err.println("Column Unsigned = "+lDesc);

        db.SQLColAttributes( 1, db.SQL_COLUMN_UPDATABLE, strDesc, lDesc );
        System.err.println("Column Updateable = "+lDesc);
    }

    public static void TestDescribeCol( JadeDB db )
    {
        OutLong  ColCount = new OutLong(0);

        db.SQLNumResultCols( ColCount );

        for (long i=1; i<=ColCount.nValue;i++ )
        {
            OutString name = new OutString("");
            OutInteger SqlType = new OutInteger(0);
            OutLong    ColDef  = new OutLong(0);
            OutInteger Scale   = new OutInteger(0);
            OutInteger Nullable= new OutInteger(0);
            int iCol = (int)i;
            db.SQLDescribeCol( iCol, name, SqlType, ColDef, Scale, Nullable );
            System.err.print("Column #"+i+" : "+name+" of ");
            switch (SqlType.get())
            {
            case db.SQL_BIGINT:
                System.err.print("SQL_BIGINT");
                break;
            case db.SQL_BINARY:
                System.err.print("SQL_BINARY");
                break;
            case db.SQL_BIT:
                System.err.print("SQL_BIT");
                break;
            case db.SQL_CHAR:
                System.err.print("SQL_CHAR");
                break;
            case db.SQL_DATE:
                System.err.print("SQL_DATE");
                break;
            case db.SQL_DECIMAL:
                System.err.print("SQL_DECIMAL");
                break;
            case db.SQL_DOUBLE:
                System.err.print("SQL_DOUBLE");
                break;
            case db.SQL_FLOAT:
                System.err.print("SQL_FLOAT");
                break;
            case db.SQL_INTEGER:
                System.err.print("SQL_INTEGER");
                break;
            case db.SQL_LONGVARBINARY:
                System.err.print("SQL_LONGVARBINARY");
                break;
            case db.SQL_LONGVARCHAR:
                System.err.print("SQL_LONGVARCHAR");
                break;
            case db.SQL_NUMERIC:
                System.err.print("SQL_NUMERIC");
                break;
            case db.SQL_REAL:
                System.err.print("SQL_REAL");
                break;
            case db.SQL_SMALLINT:
                System.err.print("SQL_SMALLINT");
                break;
            case db.SQL_TIME:
                System.err.print("SQL_TIME");
                break;
            case db.SQL_TIMESTAMP:
                System.err.print("SQL_TIMESTAMP");
                break;
            case db.SQL_TINYINT:
                System.err.print("SQL_TINYINT");
                break;
            case db.SQL_VARBINARY:
                System.err.print("SQL_VARBINARY");
                break;
            case db.SQL_VARCHAR:
                System.err.print("SQL_VARCHAR");
                break;
            }
            System.err.print(" "+ColDef+" "+Scale);
            switch (Nullable.get())
            {
            case db.SQL_NO_NULLS:
                System.err.println(" SQL_NO_NULLS");
                break;
            case db.SQL_NULLABLE:
                System.err.println(" SQL_NULLABLE");
                break;
            case db.SQL_NULLABLE_UNKNOWN:
                System.err.println(" SQL_NULLABLE_UNKNOWN");
                break;
            }
        }
    }

    public static void TestTables( JadeDB db )
    {
        if ( db.SQLTables("","%","%","%") != db.SQL_ERROR )
        {
            OutString squalifier = new OutString("");
            OutString sowner = new OutString("");
            OutString sname = new OutString("");
            OutString stype = new OutString("");
            OutString sremark = new OutString("");

            db.JadeResetBindVector();
            db.SQLBindCol( 1, db.SQL_C_CHAR, squalifier );
            db.SQLBindCol( 2, db.SQL_C_CHAR, sowner );
            db.SQLBindCol( 3, db.SQL_C_CHAR, sname );
            db.SQLBindCol( 4, db.SQL_C_CHAR, stype );
            db.SQLBindCol( 5, db.SQL_C_CHAR, sremark );
            while (true)
            {
                if ( db.SQLFetch() != db.SQL_SUCCESS )
                    break;

                db.JadeSQLGetValues();

                System.err.println( squalifier+" "+sowner+" "+sname+" "+stype+" "+sremark );
            }
        } else
        {
            PrintError( db, db.SQL_ERROR_HSTMT );
        }
    }

    public static void Test1()
    {
        JadeDB db;
    
        db = new JadeDB("moon", 4201);
        db.debug = true;
        if (!db.m_err)
        {
            //
            // test connection
            //
            if ( db.SQLConnect( "Friend","admin", "" ) == db.SQL_ERROR )
            {
                OutString state=new OutString("");
                OutLong Error=new OutLong(0);
                OutString ErrorMsg=new OutString("");

                db.SQLError( db.SQL_ERROR_CONNECT, state, Error, ErrorMsg );
                System.err.println( state+" "+Error+" "+ErrorMsg);
            }

            do
            {
                //
                // test SQLGetInfo
                //
                TestGetInfo( db );

                //
                // test SQLGetDrivers
                //
                TestGetDrivers(db);

                if ( db.SQLExecDirect( "SELECT * FROM Addresses" ) == db.SQL_ERROR )
                {
                
                    OutString state=new OutString("");
                    OutLong Error=new OutLong(0);
                    OutString ErrorMsg=new OutString("");

                    db.SQLError( db.SQL_ERROR_HSTMT, state, Error, ErrorMsg );
                    System.err.println( state+" "+Error+" "+ErrorMsg);
                }

                if ( db.SQLSetCursorName("C1") == db.SQL_ERROR )
                {
                
                    OutString state=new OutString("");
                    OutLong Error=new OutLong(0);
                    OutString ErrorMsg=new OutString("");

                    db.SQLError( db.SQL_ERROR_HSTMT, state, Error, ErrorMsg );
                    System.err.println( state+" "+Error+" "+ErrorMsg);
                }

                TestColAttributes( db );

                //
                // test SQLDescribeCol
                //
                TestDescribeCol(db);

                TestBindCol( db );

                OutString strCursorName = new OutString("");
                db.SQLGetCursorName( strCursorName );
                System.err.println( "Cursor Name: "+strCursorName );

                //
                // Test table
                //
                TestTables( db );

                //
                // Test columns
                //
                TestColumns( db );
            } while(false);
            
            db.SQLDisconnect();
        }     
    }

    public static void main(String args[])
    {
        //Test1();

        AnotherTest();
    }

    JadeDB Htmldb;
    OutInteger id;
    OutString strFirstName;
    OutString strLastName;
    OutString strSpouseName;
    OutString strAddress;
    OutString strCity;
    OutString strState;
    OutString strPostal;
    OutString strCountry;
    OutString strEmail;
    OutString strHome;
    OutString strWork;
    OutString strWorkExt;
    OutString strFax;
    OutTimestamp tsBirthday;
    OutBit Send;
    String str;

    public void ExecDirect()
    {
    
        Htmldb.SQLExecDirect( "SELECT * FROM Addresses" );

        Htmldb.JadeResetBindVector();
        Htmldb.SQLBindCol( 1, Htmldb.SQL_C_LONG, id );
        Htmldb.SQLBindCol( 2, Htmldb.SQL_C_CHAR, strFirstName );
        Htmldb.SQLBindCol( 3, Htmldb.SQL_C_CHAR, strLastName );
        Htmldb.SQLBindCol( 4, Htmldb.SQL_C_CHAR, strSpouseName );
        Htmldb.SQLBindCol( 5, Htmldb.SQL_C_CHAR, strAddress );
        Htmldb.SQLBindCol( 6, Htmldb.SQL_C_CHAR, strCity );
        Htmldb.SQLBindCol( 7, Htmldb.SQL_C_CHAR, strState );
        Htmldb.SQLBindCol( 8, Htmldb.SQL_C_CHAR, strPostal );
        Htmldb.SQLBindCol( 9, Htmldb.SQL_C_CHAR, strCountry );
        Htmldb.SQLBindCol( 10, Htmldb.SQL_C_CHAR, strEmail );
        Htmldb.SQLBindCol( 11, Htmldb.SQL_C_CHAR, strHome );
        Htmldb.SQLBindCol( 12, Htmldb.SQL_C_CHAR, strWork );
        Htmldb.SQLBindCol( 13, Htmldb.SQL_C_CHAR, strWorkExt );
        Htmldb.SQLBindCol( 14, Htmldb.SQL_C_CHAR, strFax );
        Htmldb.SQLBindCol( 15, Htmldb.SQL_C_TIMESTAMP, tsBirthday );
        Htmldb.SQLBindCol( 16, Htmldb.SQL_C_BIT, Send );

    }

    public void init()
    {
        Htmldb = new JadeDB("moon", 4201);
        Htmldb.SQLConnect( "Friend","admin", "" );
        id = new OutInteger(0);
        strFirstName=new OutString("");
        strLastName=new OutString("");
        strSpouseName=new OutString("");
        strAddress=new OutString("");
        strCity=new OutString("");
        strState=new OutString("");
        strPostal=new OutString("");
        strCountry=new OutString("");
        strEmail=new OutString("");
        strHome=new OutString("");
        strWork=new OutString("");
        strWorkExt=new OutString("");
        strFax=new OutString("");
        tsBirthday=new OutTimestamp(0,0,0,0,0,0,0);
        Send=new OutBit(0);
        ExecDirect();
        str = new String("");
    }

    Thread JadeTest;

    public void start()
    {
        if ( JadeTest == null )
        {
            JadeTest = new Thread(this);
            JadeTest.start();
        }
    }

    public void stop()
    {
        if ( JadeTest != null )
        {
            JadeTest.stop();
            JadeTest = null;
        }
    }

    public void run()
    {
        while (true) {
        try {Thread.currentThread().sleep(1000);} catch (InterruptedException e){}
            NewString();
        }
    }

    public void NewString()
    {
        if ( Htmldb == null )
            return;

        if ( Htmldb.SQLFetch() != Htmldb.SQL_SUCCESS )
        {
            Htmldb.SQLSetPos(1,Htmldb.SQL_POSITION,Htmldb.SQL_LOCK_NO_CHANGE);
        } else
        {

            // test for get value

            Htmldb.JadeSQLGetValues();
            //db.SQLTransact( db.SQL_COMMIT );

            str=id+" First Name: "+strFirstName+" Last Name: "+strLastName+" Spouse Name: "+strSpouseName;

            System.err.println(id+" First Name: "+strFirstName+" Last Name: "+strLastName+" Spouse Name: "+strSpouseName );
            System.err.println("Address: "+strAddress );
            System.err.println(strCity+" "+strState );
            System.err.println(strPostal+" "+strCountry );
            System.err.println(strEmail+" "+strHome+" "+strWork );
            System.err.println(strWorkExt+" "+strFax );
            System.err.println( tsBirthday );
            System.err.println( "Send: "+Send );
        }
        System.err.println("String: "+str);
        repaint();
    }

    public void paint(Graphics g)
    {
        g.drawString( str, 10, 10 );
    }
}
