//////////////////////////////////////////////////////////////
// Expense.java
// 
// Jade demo example 2
//
// Copyright (C) 1996 Kwan Software Research
// All rights reserved.
//
// Please send email to: tkwan@aa.net for license detail.
//
//////////////////////////////////////////////////////////////

import java.awt.*;
import java.applet.*;
import java.net.*;
import java.io.*;

public class Expense extends Applet 
{
    public static void main(String args[])
    {
        ExpenseDataBaseTest();
    }
    public static void PrintError(JadeDB db, int fType )
    {
        OutString state=new OutString("");
        OutLong Error=new OutLong(0);
        OutString ErrorMsg=new OutString("");

        db.SQLError( fType, state, Error, ErrorMsg );
        System.err.println( state+" "+Error+" "+ErrorMsg);
    }

    public static void FetchData(JadeDB db)
    {
        OutInteger ExpenseDetailId=new OutInteger(0);
        OutInteger ExpenseReportId=new OutInteger(0);
        OutInteger ExpenseCategoryId=new OutInteger(0);
        OutString ExpenseItemAmount=new OutString("");
        OutString ExpenseItemDescription=new OutString("");
        OutTimestamp ExpenseDate=new OutTimestamp(0,0,0,0,0,0,0);

        db.JadeResetBindVector();
        db.SQLBindCol( 1, db.SQL_C_SLONG, ExpenseDetailId );
        db.SQLBindCol( 2, db.SQL_C_SLONG, ExpenseReportId );
        db.SQLBindCol( 3, db.SQL_C_SLONG, ExpenseCategoryId );
        db.SQLBindCol( 4, db.SQL_C_CHAR, ExpenseItemAmount );
        db.SQLBindCol( 5, db.SQL_C_CHAR, ExpenseItemDescription );
        db.SQLBindCol( 6, db.SQL_C_TIMESTAMP, ExpenseDate );

        while (true)
        {
            if ( db.SQLFetch() != db.SQL_SUCCESS )
                break;
        
            db.JadeSQLGetValues();
            db.SQLTransact( db.SQL_COMMIT );

            System.err.println(ExpenseDetailId);
            System.err.println(ExpenseReportId);
            System.err.println(ExpenseCategoryId);
            System.err.println(ExpenseItemAmount);
            System.err.println(ExpenseItemDescription);
            System.err.println(ExpenseDate);
        }

    }

    public static void ExpenseDataBaseTest()
    {
        JadeDB db = new JadeDB("moon", 4201);
    
        if (!db.m_err)
        {
            //
            // test connection
            //
            if ( db.SQLConnect( "Expense","admin", "" ) == db.SQL_ERROR )
            {
                OutString state=new OutString("");
                OutLong Error=new OutLong(0);
                OutString ErrorMsg=new OutString("");

                db.SQLError( db.SQL_ERROR_CONNECT, state, Error, ErrorMsg );
                System.err.println( state+" "+Error+" "+ErrorMsg);
            }

            do
            {

                if ( db.SQLExecDirect( "SELECT * FROM Expense_Details" ) == db.SQL_ERROR )
                {
                
                    OutString state=new OutString("");
                    OutLong Error=new OutLong(0);
                    OutString ErrorMsg=new OutString("");

                    db.SQLError( db.SQL_ERROR_HSTMT, state, Error, ErrorMsg );
                    System.err.println( state+" "+Error+" "+ErrorMsg);
                }

                //
                // test SQLDescribeCol
                //
                TestDescribeCol(db);

                FetchData(db);

            } while(false);
            
            db.SQLDisconnect();
        }     
    }

    public static void TestDescribeCol( JadeDB db )
    {
        OutLong  ColCount = new OutLong(0);

        db.SQLNumResultCols( ColCount );

        for (long i=1; i<=ColCount.nValue;i++ )
        {
            OutString name = new OutString("");
            OutInteger SqlType = new OutInteger(0);
            OutLong    ColDef  = new OutLong(0);
            OutInteger Scale   = new OutInteger(0);
            OutInteger Nullable= new OutInteger(0);
            int iCol = (int)i;
            db.SQLDescribeCol( iCol, name, SqlType, ColDef, Scale, Nullable );
            System.err.print("Column #"+i+" : "+name+" of ");
            switch (SqlType.get())
            {
            case db.SQL_BIGINT:
                System.err.print("SQL_BIGINT");
                break;
            case db.SQL_BINARY:
                System.err.print("SQL_BINARY");
                break;
            case db.SQL_BIT:
                System.err.print("SQL_BIT");
                break;
            case db.SQL_CHAR:
                System.err.print("SQL_CHAR");
                break;
            case db.SQL_DATE:
                System.err.print("SQL_DATE");
                break;
            case db.SQL_DECIMAL:
                System.err.print("SQL_DECIMAL");
                break;
            case db.SQL_DOUBLE:
                System.err.print("SQL_DOUBLE");
                break;
            case db.SQL_FLOAT:
                System.err.print("SQL_FLOAT");
                break;
            case db.SQL_INTEGER:
                System.err.print("SQL_INTEGER");
                break;
            case db.SQL_LONGVARBINARY:
                System.err.print("SQL_LONGVARBINARY");
                break;
            case db.SQL_LONGVARCHAR:
                System.err.print("SQL_LONGVARCHAR");
                break;
            case db.SQL_NUMERIC:
                System.err.print("SQL_NUMERIC");
                break;
            case db.SQL_REAL:
                System.err.print("SQL_REAL");
                break;
            case db.SQL_SMALLINT:
                System.err.print("SQL_SMALLINT");
                break;
            case db.SQL_TIME:
                System.err.print("SQL_TIME");
                break;
            case db.SQL_TIMESTAMP:
                System.err.print("SQL_TIMESTAMP");
                break;
            case db.SQL_TINYINT:
                System.err.print("SQL_TINYINT");
                break;
            case db.SQL_VARBINARY:
                System.err.print("SQL_VARBINARY");
                break;
            case db.SQL_VARCHAR:
                System.err.print("SQL_VARCHAR");
                break;
            }
            System.err.print(" "+ColDef+" "+Scale);
            switch (Nullable.get())
            {
            case db.SQL_NO_NULLS:
                System.err.println(" SQL_NO_NULLS");
                break;
            case db.SQL_NULLABLE:
                System.err.println(" SQL_NULLABLE");
                break;
            case db.SQL_NULLABLE_UNKNOWN:
                System.err.println(" SQL_NULLABLE_UNKNOWN");
                break;
            }
        }
    }

}

