//////////////////////////////////////////////////////////////
// JadeDB.java
// 
// Jade Java Code
// Copyright (C) 1996 Kwan Software Research
// All rights reserved.
//
// Please send email to: tkwan@aa.net for license detail.
//
//////////////////////////////////////////////////////////////

import java.awt.*;
import java.applet.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class JadeDB
{
    public final static int ODBCVER = 0x0250;
    public final static int SQL_SPEC_MAJOR        =            2  ;   /* Major version of specification  */
    public final static int SQL_SPEC_MINOR        =            50 ;   /* Minor version of specification  */
    public final static String SQL_SPEC_STRING    =  "02.50"      ;   /* String constant for version */
    public final static int SQL_SQLSTATE_SIZE     =            5  ;   /* size of SQLSTATE */
    public final static int SQL_MAX_MESSAGE_LENGTH=  512          ;   /* message buffer size */
    public final static int SQL_MAX_DSN_LENGTH    =           32  ;   /* maximum data source name size*/

    /* RETCODEs */
    public final static int SQL_INVALID_HANDLE    =          (-2);
    public final static int SQL_ERROR             =          (-1);
    public final static int SQL_SUCCESS           =          0;
    public final static int SQL_SUCCESS_WITH_INFO =          1;
    public final static int SQL_NO_DATA_FOUND     =          100;

    /* Standard SQL datatypes, using ANSI type numbering */
    public final static int SQL_CHAR              =          1;
    public final static int SQL_NUMERIC           =          2;
    public final static int SQL_DECIMAL           =          3;
    public final static int SQL_INTEGER           =          4;
    public final static int SQL_SMALLINT          =          5;
    public final static int SQL_FLOAT             =          6;
    public final static int SQL_REAL              =          7;
    public final static int SQL_DOUBLE            =          8;
    public final static int SQL_VARCHAR           =          12;

    /* SQL extended datatypes */
    public final static int SQL_DATE               =                 9;
    public final static int SQL_TIME               =                 10;
    public final static int SQL_TIMESTAMP          =                 11;
    public final static int SQL_LONGVARCHAR        =                 (-1);
    public final static int SQL_BINARY             =                 (-2);
    public final static int SQL_VARBINARY          =                 (-3);
    public final static int SQL_LONGVARBINARY      =                 (-4);
    public final static int SQL_BIGINT             =                 (-5);
    public final static int SQL_TINYINT            =                 (-6);
    public final static int SQL_BIT                =                 (-7);

    public final static int SQL_TYPE_NULL         =          0;
    public final static int SQL_TYPE_MIN          =          SQL_BIT;
    public final static int SQL_TYPE_MAX          =          SQL_VARCHAR;
    public final static int SQL_ALL_TYPES         =          0;

    /* C datatype to SQL datatype mapping      SQL types 
                                                                                       ------------------- */
    public final static int SQL_C_CHAR    = SQL_CHAR            ; /* CHAR, VARCHAR, DECIMAL, NUMERIC */
    public final static int SQL_C_LONG    = SQL_INTEGER         ; /* INTEGER                      */
    public final static int SQL_C_SHORT   = SQL_SMALLINT        ; /* SMALLINT                     */
    public final static int SQL_C_FLOAT   = SQL_REAL            ; /* REAL                         */
    public final static int SQL_C_DOUBLE  = SQL_DOUBLE          ; /* FLOAT, DOUBLE                */
    public final static int SQL_C_DEFAULT = 99;

    /* NULL status constants.  These are used in SQLColumns, SQLColAttributes,
    SQLDescribeCol, SQLDescribeParam, and SQLSpecialColumns to describe the
    nullablity of a column in a table. */
    public final static int SQL_NO_NULLS                  =  0;
    public final static int SQL_NULLABLE                  =  1;
    public final static int SQL_NULLABLE_UNKNOWN          =  2;

    /* Special length values */
    public final static int SQL_NULL_DATA                 =  (-1);
    public final static int SQL_DATA_AT_EXEC              =  (-2);
    public final static int SQL_NTS                       =  (-3);

    /* SQLFreeStmt defines */
    public final static int SQL_CLOSE                     =  0;
    public final static int SQL_DROP                      =  1;
    public final static int SQL_UNBIND                    =  2;
    public final static int SQL_RESET_PARAMS              =  3;
                                                      
    /* SQLTransact defines */
    public final static int SQL_COMMIT                    =  0;
    public final static int SQL_ROLLBACK                  =  1;

    /* SQLColAttributes defines */
    public final static int SQL_COLUMN_COUNT              =  0;
    public final static int SQL_COLUMN_NAME               =  1;
    public final static int SQL_COLUMN_TYPE               =  2;
    public final static int SQL_COLUMN_LENGTH             =  3;
    public final static int SQL_COLUMN_PRECISION          =  4;
    public final static int SQL_COLUMN_SCALE              =  5;
    public final static int SQL_COLUMN_DISPLAY_SIZE       =  6;
    public final static int SQL_COLUMN_NULLABLE           =  7;
    public final static int SQL_COLUMN_UNSIGNED           =  8;
    public final static int SQL_COLUMN_MONEY              =  9;
    public final static int SQL_COLUMN_UPDATABLE          =  10;
    public final static int SQL_COLUMN_AUTO_INCREMENT     =  11;
    public final static int SQL_COLUMN_CASE_SENSITIVE     =  12;
    public final static int SQL_COLUMN_SEARCHABLE         =  13;
    public final static int SQL_COLUMN_TYPE_NAME          =  14;
    public final static int SQL_COLUMN_TABLE_NAME         =  15;
    public final static int SQL_COLUMN_OWNER_NAME         =  16;
    public final static int SQL_COLUMN_QUALIFIER_NAME     =  17;
    public final static int SQL_COLUMN_LABEL              =  18;
    public final static int SQL_COLATT_OPT_MAX            =  SQL_COLUMN_LABEL;
    public final static int SQL_COLUMN_DRIVER_START       =  1000;

    public final static int SQL_COLATT_OPT_MIN            =  SQL_COLUMN_COUNT;

    /* SQLColAttributes subdefines for SQL_COLUMN_UPDATABLE */
    public final static int SQL_ATTR_READONLY             =  0;
    public final static int SQL_ATTR_WRITE                =  1;
    public final static int SQL_ATTR_READWRITE_UNKNOWN    =  2;

    /* SQLColAttributes subdefines for SQL_COLUMN_SEARCHABLE */
    /* These are also used by SQLGetInfo                     */
    public final static int SQL_UNSEARCHABLE              =  0;
    public final static int SQL_LIKE_ONLY                 =  1;
    public final static int SQL_ALL_EXCEPT_LIKE           =  2;
    public final static int SQL_SEARCHABLE                =  3;

    /* SQLError defines */
    public final static int SQL_NULL_HENV                 =  0;
    public final static int SQL_NULL_HDBC                 =  0;
    public final static int SQL_NULL_HSTMT                =  0;

    /* generally useful constants */
    public final static int SQL_MAX_OPTION_STRING_LENGTH  =  256;

    /* Additional return codes */
    public final static int SQL_STILL_EXECUTING    = 2;
    public final static int SQL_NEED_DATA          = 99;

    public final static int SQL_INTERVAL_YEAR              =         (-80);
    public final static int SQL_INTERVAL_MONTH             =         (-81);
    public final static int SQL_INTERVAL_YEAR_TO_MONTH     =         (-82);
    public final static int SQL_INTERVAL_DAY               =         (-83);
    public final static int SQL_INTERVAL_HOUR              =         (-84);
    public final static int SQL_INTERVAL_MINUTE            =         (-85);
    public final static int SQL_INTERVAL_SECOND            =         (-86);
    public final static int SQL_INTERVAL_DAY_TO_HOUR       =         (-87);
    public final static int SQL_INTERVAL_DAY_TO_MINUTE     =         (-88);
    public final static int SQL_INTERVAL_DAY_TO_SECOND     =         (-89);
    public final static int SQL_INTERVAL_HOUR_TO_MINUTE    =         (-90);
    public final static int SQL_INTERVAL_HOUR_TO_SECOND    =         (-91);
    public final static int SQL_INTERVAL_MINUTE_TO_SECOND  =         (-92);
    public final static int SQL_UNICODE                    =         (-95);
    public final static int SQL_UNICODE_VARCHAR            =         (-96);
    public final static int SQL_UNICODE_LONGVARCHAR        =         (-97);
    public final static int SQL_UNICODE_CHAR               =         SQL_UNICODE;

    public final static int SQL_TYPE_DRIVER_START          =         SQL_INTERVAL_YEAR;
    public final static int SQL_TYPE_DRIVER_END            =         SQL_UNICODE_LONGVARCHAR;


    public final static int SQL_SIGNED_OFFSET      = (-20);
    public final static int SQL_UNSIGNED_OFFSET    = (-22);

    /* C datatype to SQL datatype mapping */
    public final static int SQL_C_DATE      = SQL_DATE;
    public final static int SQL_C_TIME      = SQL_TIME;
    public final static int SQL_C_TIMESTAMP = SQL_TIMESTAMP;
    public final static int SQL_C_BINARY    = SQL_BINARY;
    public final static int SQL_C_BIT       = SQL_BIT;
    public final static int SQL_C_TINYINT   = SQL_TINYINT;
    public final static int SQL_C_SLONG     = SQL_C_LONG+SQL_SIGNED_OFFSET   ; /* SIGNED INTEGER   */
    public final static int SQL_C_SSHORT    = SQL_C_SHORT+SQL_SIGNED_OFFSET  ; /* SIGNED SMALLINT  */
    public final static int SQL_C_STINYINT  = SQL_TINYINT+SQL_SIGNED_OFFSET  ; /* SIGNED TINYINT   */
    public final static int SQL_C_ULONG     = SQL_C_LONG+SQL_UNSIGNED_OFFSET ; /* UNSIGNED INTEGER */
    public final static int SQL_C_USHORT    = SQL_C_SHORT+SQL_UNSIGNED_OFFSET; /* UNSIGNED SMALLINT*/
    public final static int SQL_C_UTINYINT  = SQL_TINYINT+SQL_UNSIGNED_OFFSET; /* UNSIGNED TINYINT */
    public final static int SQL_C_BOOKMARK  = SQL_C_ULONG                    ; /* BOOKMARK         */

    /* Level 1 Functions                    */

    /* Special return values for SQLGetData */
    public final static int SQL_NO_TOTAL     =               (-4);

    /* Defines for SQLGetFunctions */
    public final static int SQL_API_SQLALLOCCONNECT    =  1;    /* Core Functions           */
    public final static int SQL_API_SQLALLOCENV        =  2;
    public final static int SQL_API_SQLALLOCSTMT       =  3;
    public final static int SQL_API_SQLBINDCOL         =  4;
    public final static int SQL_API_SQLCANCEL          =  5;
    public final static int SQL_API_SQLCOLATTRIBUTES   =  6;
    public final static int SQL_API_SQLCONNECT         =  7;
    public final static int SQL_API_SQLDESCRIBECOL     =  8;
    public final static int SQL_API_SQLDISCONNECT      =  9;
    public final static int SQL_API_SQLERROR           = 10;
    public final static int SQL_API_SQLEXECDIRECT      = 11;
    public final static int SQL_API_SQLEXECUTE         = 12;
    public final static int SQL_API_SQLFETCH           = 13;
    public final static int SQL_API_SQLFREECONNECT     = 14;
    public final static int SQL_API_SQLFREEENV         = 15;
    public final static int SQL_API_SQLFREESTMT        = 16;
    public final static int SQL_API_SQLGETCURSORNAME   = 17;
    public final static int SQL_API_SQLNUMRESULTCOLS   = 18;
    public final static int SQL_API_SQLPREPARE         = 19;
    public final static int SQL_API_SQLROWCOUNT        = 20;
    public final static int SQL_API_SQLSETCURSORNAME   = 21;
    public final static int SQL_API_SQLSETPARAM        = 22;
    public final static int SQL_API_SQLTRANSACT        = 23;

    public final static int SQL_NUM_FUNCTIONS          = 23;

    public final static int SQL_EXT_API_START          = 40;

    public final static int SQL_API_SQLCOLUMNS         = 40;    /* Level 1 Functions        */
    public final static int SQL_API_SQLDRIVERCONNECT    = 41;
    public final static int SQL_API_SQLGETCONNECTOPTION = 42;
    public final static int SQL_API_SQLGETDATA          = 43;
    public final static int SQL_API_SQLGETFUNCTIONS     = 44;
    public final static int SQL_API_SQLGETINFO          = 45;
    public final static int SQL_API_SQLGETSTMTOPTION    = 46;
    public final static int SQL_API_SQLGETTYPEINFO      = 47;
    public final static int SQL_API_SQLPARAMDATA        = 48;
    public final static int SQL_API_SQLPUTDATA          = 49;
    public final static int SQL_API_SQLSETCONNECTOPTION = 50;
    public final static int SQL_API_SQLSETSTMTOPTION    = 51;
    public final static int SQL_API_SQLSPECIALCOLUMNS   = 52;
    public final static int SQL_API_SQLSTATISTICS       = 53;
    public final static int SQL_API_SQLTABLES           = 54;

    public final static int SQL_API_SQLBROWSECONNECT    = 55;    /* Level 2 Functions        */
    public final static int SQL_API_SQLCOLUMNPRIVILEGES = 56;
    public final static int SQL_API_SQLDATASOURCES      = 57;
    public final static int SQL_API_SQLDESCRIBEPARAM    = 58;
    public final static int SQL_API_SQLEXTENDEDFETCH    = 59;
    public final static int SQL_API_SQLFOREIGNKEYS      = 60;
    public final static int SQL_API_SQLMORERESULTS      = 61;
    public final static int SQL_API_SQLNATIVESQL        = 62;
    public final static int SQL_API_SQLNUMPARAMS        = 63;
    public final static int SQL_API_SQLPARAMOPTIONS     = 64;
    public final static int SQL_API_SQLPRIMARYKEYS      = 65;
    public final static int SQL_API_SQLPROCEDURECOLUMNS = 66;
    public final static int SQL_API_SQLPROCEDURES       = 67;
    public final static int SQL_API_SQLSETPOS           = 68;
    public final static int SQL_API_SQLSETSCROLLOPTIONS = 69;
    public final static int SQL_API_SQLTABLEPRIVILEGES  = 70;

    /*              SDK 2.0 Additions               */
    public final static int SQL_API_SQLDRIVERS          = 71;
    public final static int SQL_API_SQLBINDPARAMETER    = 72;
    public final static int SQL_EXT_API_LAST            = SQL_API_SQLBINDPARAMETER;

    public final static int SQL_API_ALL_FUNCTIONS       = 0;

    public final static int SQL_NUM_EXTENSIONS = (SQL_EXT_API_LAST-SQL_EXT_API_START+1);
    public final static int SQL_API_LOADBYORDINAL       = 199;

    /* Defines for SQLGetInfo */
    public final static int SQL_INFO_FIRST              =         0;
    public final static int SQL_ACTIVE_CONNECTIONS      =         0;
    public final static int SQL_ACTIVE_STATEMENTS       =         1;
    public final static int SQL_DATA_SOURCE_NAME        =         2;
    public final static int SQL_DRIVER_HDBC             =         3;
    public final static int SQL_DRIVER_HENV             =         4;
    public final static int SQL_DRIVER_HSTMT            =         5;
    public final static int SQL_DRIVER_NAME             =         6;
    public final static int SQL_DRIVER_VER              =         7;
    public final static int SQL_FETCH_DIRECTION         =         8;
    public final static int SQL_ODBC_API_CONFORMANCE    =         9;
    public final static int SQL_ODBC_VER                =        10;
    public final static int SQL_ROW_UPDATES             =        11;
    public final static int SQL_ODBC_SAG_CLI_CONFORMANCE=        12;
    public final static int SQL_SERVER_NAME             =        13;
    public final static int SQL_SEARCH_PATTERN_ESCAPE   =        14;
    public final static int SQL_ODBC_SQL_CONFORMANCE    =        15;

    public final static int SQL_DBMS_NAME               =        17;
    public final static int SQL_DBMS_VER                =        18;

    public final static int SQL_ACCESSIBLE_TABLES       =        19;
    public final static int SQL_ACCESSIBLE_PROCEDURES   =        20;
    public final static int SQL_PROCEDURES              =        21;
    public final static int SQL_CONCAT_NULL_BEHAVIOR    =        22;
    public final static int SQL_CURSOR_COMMIT_BEHAVIOR  =        23;
    public final static int SQL_CURSOR_ROLLBACK_BEHAVIOR=        24;
    public final static int SQL_DATA_SOURCE_READ_ONLY   =        25;
    public final static int SQL_DEFAULT_TXN_ISOLATION   =        26;
    public final static int SQL_EXPRESSIONS_IN_ORDERBY  =        27;
    public final static int SQL_IDENTIFIER_CASE         =        28;
    public final static int SQL_IDENTIFIER_QUOTE_CHAR   =        29;
    public final static int SQL_MAX_COLUMN_NAME_LEN     =        30;
    public final static int SQL_MAX_CURSOR_NAME_LEN     =        31;
    public final static int SQL_MAX_OWNER_NAME_LEN      =        32;
    public final static int SQL_MAX_PROCEDURE_NAME_LEN  =        33;
    public final static int SQL_MAX_QUALIFIER_NAME_LEN  =        34;
    public final static int SQL_MAX_TABLE_NAME_LEN      =        35;
    public final static int SQL_MULT_RESULT_SETS        =        36;
    public final static int SQL_MULTIPLE_ACTIVE_TXN     =        37;
    public final static int SQL_OUTER_JOINS             =        38;
    public final static int SQL_OWNER_TERM              =        39;
    public final static int SQL_PROCEDURE_TERM          =        40;
    public final static int SQL_QUALIFIER_NAME_SEPARATOR=        41;
    public final static int SQL_QUALIFIER_TERM          =        42;
    public final static int SQL_SCROLL_CONCURRENCY      =        43;
    public final static int SQL_SCROLL_OPTIONS          =        44;
    public final static int SQL_TABLE_TERM              =        45;
    public final static int SQL_TXN_CAPABLE             =        46;
    public final static int SQL_USER_NAME               =        47;

    public final static int SQL_CONVERT_FUNCTIONS       =        48;
    public final static int SQL_NUMERIC_FUNCTIONS       =        49;
    public final static int SQL_STRING_FUNCTIONS        =        50;
    public final static int SQL_SYSTEM_FUNCTIONS        =        51;
    public final static int SQL_TIMEDATE_FUNCTIONS      =        52;

    public final static int SQL_CONVERT_BIGINT          =        53;
    public final static int SQL_CONVERT_BINARY          =        54;
    public final static int SQL_CONVERT_BIT             =        55;
    public final static int SQL_CONVERT_CHAR            =        56;
    public final static int SQL_CONVERT_DATE            =        57;
    public final static int SQL_CONVERT_DECIMAL         =        58;
    public final static int SQL_CONVERT_DOUBLE          =        59;
    public final static int SQL_CONVERT_FLOAT           =        60;
    public final static int SQL_CONVERT_INTEGER         =        61;
    public final static int SQL_CONVERT_LONGVARCHAR     =        62;
    public final static int SQL_CONVERT_NUMERIC         =        63;
    public final static int SQL_CONVERT_REAL            =        64;
    public final static int SQL_CONVERT_SMALLINT        =        65;
    public final static int SQL_CONVERT_TIME            =        66;
    public final static int SQL_CONVERT_TIMESTAMP       =        67;
    public final static int SQL_CONVERT_TINYINT         =        68;
    public final static int SQL_CONVERT_VARBINARY       =        69;
    public final static int SQL_CONVERT_VARCHAR         =        70;
    public final static int SQL_CONVERT_LONGVARBINARY   =        71;

    public final static int SQL_TXN_ISOLATION_OPTION    =        72;
    public final static int SQL_ODBC_SQL_OPT_IEF        =        73;

    /*** ODBC SDK 1.0 Additions ***/
    public final static int SQL_CORRELATION_NAME        =        74;
    public final static int SQL_NON_NULLABLE_COLUMNS    =        75;

    /*** ODBC SDK 2.0 Additions ***/
    public final static int SQL_DRIVER_HLIB             =        76;
    public final static int SQL_DRIVER_ODBC_VER         =        77;
    public final static int SQL_LOCK_TYPES              =        78;
    public final static int SQL_POS_OPERATIONS          =        79;
    public final static int SQL_POSITIONED_STATEMENTS   =        80;
    public final static int SQL_GETDATA_EXTENSIONS      =        81;
    public final static int SQL_BOOKMARK_PERSISTENCE    =        82;
    public final static int SQL_STATIC_SENSITIVITY      =        83;
    public final static int SQL_FILE_USAGE              =        84;
    public final static int SQL_NULL_COLLATION          =        85;
    public final static int SQL_ALTER_TABLE             =        86;
    public final static int SQL_COLUMN_ALIAS            =        87;
    public final static int SQL_GROUP_BY                =        88;
    public final static int SQL_KEYWORDS                =        89;
    public final static int SQL_ORDER_BY_COLUMNS_IN_SELECT =     90;
    public final static int SQL_OWNER_USAGE                =     91;
    public final static int SQL_QUALIFIER_USAGE            =     92;
    public final static int SQL_QUOTED_IDENTIFIER_CASE     =     93;
    public final static int SQL_SPECIAL_CHARACTERS         =     94;
    public final static int SQL_SUBQUERIES                 =     95;
    public final static int SQL_UNION                      =     96;
    public final static int SQL_MAX_COLUMNS_IN_GROUP_BY    =     97;
    public final static int SQL_MAX_COLUMNS_IN_INDEX       =     98;
    public final static int SQL_MAX_COLUMNS_IN_ORDER_BY    =     99;
    public final static int SQL_MAX_COLUMNS_IN_SELECT      =     100;
    public final static int SQL_MAX_COLUMNS_IN_TABLE       =     101;
    public final static int SQL_MAX_INDEX_SIZE             =     102;
    public final static int SQL_MAX_ROW_SIZE_INCLUDES_LONG =     103;
    public final static int SQL_MAX_ROW_SIZE               =     104;
    public final static int SQL_MAX_STATEMENT_LEN          =     105;
    public final static int SQL_MAX_TABLES_IN_SELECT       =     106;
    public final static int SQL_MAX_USER_NAME_LEN          =     107;
    public final static int SQL_MAX_CHAR_LITERAL_LEN       =     108;
    public final static int SQL_TIMEDATE_ADD_INTERVALS     =     109;
    public final static int SQL_TIMEDATE_DIFF_INTERVALS    =     110;
    public final static int SQL_NEED_LONG_DATA_LEN         =     111;
    public final static int SQL_MAX_BINARY_LITERAL_LEN     =     112;
    public final static int SQL_LIKE_ESCAPE_CLAUSE         =     113;
    public final static int SQL_QUALIFIER_LOCATION         =     114;

    /*** ODBC SDK 2.01 Additions ***/
    public final static int SQL_OJ_CAPABILITIES         = 65003 ; /* Temp value until ODBC 3.0 */

    public final static int SQL_INFO_LAST               =        SQL_QUALIFIER_LOCATION;

    public final static int SQL_INFO_DRIVER_START       =        1000;

    /* SQL_CONVERT_*  return value bitmasks */

    public final static long SQL_CVT_CHAR                =        0x00000001L;
    public final static long SQL_CVT_NUMERIC             =        0x00000002L;
    public final static long SQL_CVT_DECIMAL             =        0x00000004L;
    public final static long SQL_CVT_INTEGER             =        0x00000008L;
    public final static long SQL_CVT_SMALLINT            =        0x00000010L;
    public final static long SQL_CVT_FLOAT               =        0x00000020L;
    public final static long SQL_CVT_REAL                =        0x00000040L;
    public final static long SQL_CVT_DOUBLE              =        0x00000080L;
    public final static long SQL_CVT_VARCHAR             =        0x00000100L;
    public final static long SQL_CVT_LONGVARCHAR         =        0x00000200L;
    public final static long SQL_CVT_BINARY              =        0x00000400L;
    public final static long SQL_CVT_VARBINARY           =        0x00000800L;
    public final static long SQL_CVT_BIT                 =        0x00001000L;
    public final static long SQL_CVT_TINYINT             =        0x00002000L;
    public final static long SQL_CVT_BIGINT              =        0x00004000L;
    public final static long SQL_CVT_DATE                =        0x00008000L;
    public final static long SQL_CVT_TIME                =        0x00010000L;
    public final static long SQL_CVT_TIMESTAMP           =        0x00020000L;
    public final static long SQL_CVT_LONGVARBINARY       =        0x00040000L;

    /* SQL_CONVERT_FUNCTIONS functions */
    public final static long SQL_FN_CVT_CONVERT          =        0x00000001L;

    /* SQL_STRING_FUNCTIONS functions */

    public final static long SQL_FN_STR_CONCAT           =        0x00000001L;
    public final static long SQL_FN_STR_INSERT           =        0x00000002L;
    public final static long SQL_FN_STR_LEFT             =        0x00000004L;
    public final static long SQL_FN_STR_LTRIM            =        0x00000008L;
    public final static long SQL_FN_STR_LENGTH           =        0x00000010L;
    public final static long SQL_FN_STR_LOCATE           =        0x00000020L;
    public final static long SQL_FN_STR_LCASE            =        0x00000040L;
    public final static long SQL_FN_STR_REPEAT           =        0x00000080L;
    public final static long SQL_FN_STR_REPLACE          =        0x00000100L;
    public final static long SQL_FN_STR_RIGHT            =        0x00000200L;
    public final static long SQL_FN_STR_RTRIM            =        0x00000400L;
    public final static long SQL_FN_STR_SUBSTRING        =        0x00000800L;
    public final static long SQL_FN_STR_UCASE            =        0x00001000L;
    public final static long SQL_FN_STR_ASCII            =        0x00002000L;
    public final static long SQL_FN_STR_CHAR             =        0x00004000L;
    public final static long SQL_FN_STR_DIFFERENCE       =        0x00008000L;
    public final static long SQL_FN_STR_LOCATE_2         =        0x00010000L;
    public final static long SQL_FN_STR_SOUNDEX          =        0x00020000L;
    public final static long SQL_FN_STR_SPACE            =        0x00040000L;

    /* SQL_NUMERIC_FUNCTIONS functions */

    public final static long SQL_FN_NUM_ABS              =        0x00000001L;
    public final static long SQL_FN_NUM_ACOS             =        0x00000002L;
    public final static long SQL_FN_NUM_ASIN             =        0x00000004L;
    public final static long SQL_FN_NUM_ATAN             =        0x00000008L;
    public final static long SQL_FN_NUM_ATAN2            =        0x00000010L;
    public final static long SQL_FN_NUM_CEILING          =        0x00000020L;
    public final static long SQL_FN_NUM_COS              =        0x00000040L;
    public final static long SQL_FN_NUM_COT              =        0x00000080L;
    public final static long SQL_FN_NUM_EXP              =        0x00000100L;
    public final static long SQL_FN_NUM_FLOOR            =        0x00000200L;
    public final static long SQL_FN_NUM_LOG              =        0x00000400L;
    public final static long SQL_FN_NUM_MOD              =        0x00000800L;
    public final static long SQL_FN_NUM_SIGN             =        0x00001000L;
    public final static long SQL_FN_NUM_SIN              =        0x00002000L;
    public final static long SQL_FN_NUM_SQRT             =        0x00004000L;
    public final static long SQL_FN_NUM_TAN              =        0x00008000L;
    public final static long SQL_FN_NUM_PI               =        0x00010000L;
    public final static long SQL_FN_NUM_RAND             =        0x00020000L;
    public final static long SQL_FN_NUM_DEGREES          =        0x00040000L;
    public final static long SQL_FN_NUM_LOG10            =        0x00080000L;
    public final static long SQL_FN_NUM_POWER            =        0x00100000L;
    public final static long SQL_FN_NUM_RADIANS          =        0x00200000L;
    public final static long SQL_FN_NUM_ROUND            =        0x00400000L;
    public final static long SQL_FN_NUM_TRUNCATE         =        0x00800000L;

    /* SQL_TIMEDATE_FUNCTIONS functions */

    public final static long SQL_FN_TD_NOW               =        0x00000001L;
    public final static long SQL_FN_TD_CURDATE           =        0x00000002L;
    public final static long SQL_FN_TD_DAYOFMONTH        =        0x00000004L;
    public final static long SQL_FN_TD_DAYOFWEEK         =        0x00000008L;
    public final static long SQL_FN_TD_DAYOFYEAR         =        0x00000010L;
    public final static long SQL_FN_TD_MONTH             =        0x00000020L;
    public final static long SQL_FN_TD_QUARTER           =        0x00000040L;
    public final static long SQL_FN_TD_WEEK              =        0x00000080L;
    public final static long SQL_FN_TD_YEAR              =        0x00000100L;
    public final static long SQL_FN_TD_CURTIME           =        0x00000200L;
    public final static long SQL_FN_TD_HOUR              =        0x00000400L;
    public final static long SQL_FN_TD_MINUTE            =        0x00000800L;
    public final static long SQL_FN_TD_SECOND            =        0x00001000L;
    public final static long SQL_FN_TD_TIMESTAMPADD      =        0x00002000L;
    public final static long SQL_FN_TD_TIMESTAMPDIFF     =        0x00004000L;
    public final static long SQL_FN_TD_DAYNAME           =        0x00008000L;
    public final static long SQL_FN_TD_MONTHNAME         =        0x00010000L;
                                                       
    /* SQL_SYSTEM_FUNCTIONS functions */               
                                                       
    public final static long SQL_FN_SYS_USERNAME         =        0x00000001L;
    public final static long SQL_FN_SYS_DBNAME           =        0x00000002L;
    public final static long SQL_FN_SYS_IFNULL           =        0x00000004L;
                                                       
    /* SQL_TIMEDATE_ADD_INTERVALS and SQL_TIMEDATE_DIFF_INTERVALS functions */

    public final static long SQL_FN_TSI_FRAC_SECOND      =        0x00000001L;
    public final static long SQL_FN_TSI_SECOND           =        0x00000002L;
    public final static long SQL_FN_TSI_MINUTE           =        0x00000004L;
    public final static long SQL_FN_TSI_HOUR             =        0x00000008L;
    public final static long SQL_FN_TSI_DAY              =        0x00000010L;
    public final static long SQL_FN_TSI_WEEK             =        0x00000020L;
    public final static long SQL_FN_TSI_MONTH            =        0x00000040L;
    public final static long SQL_FN_TSI_QUARTER          =        0x00000080L;
    public final static long SQL_FN_TSI_YEAR             =        0x00000100L;

    /* SQL_ODBC_API_CONFORMANCE values */

    public final static int SQL_OAC_NONE                 =       0x0000;
    public final static int SQL_OAC_LEVEL1               =       0x0001;
    public final static int SQL_OAC_LEVEL2               =       0x0002;

    /* SQL_ODBC_SAG_CLI_CONFORMANCE values */

    public final static int SQL_OSCC_NOT_COMPLIANT       =       0x0000;
    public final static int SQL_OSCC_COMPLIANT           =       0x0001;

    /* SQL_ODBC_SQL_CONFORMANCE values */

    public final static int SQL_OSC_MINIMUM              =       0x0000;
    public final static int SQL_OSC_CORE                 =       0x0001;
    public final static int SQL_OSC_EXTENDED             =       0x0002;

    /* SQL_CONCAT_NULL_BEHAVIOR values */

    public final static int SQL_CB_NULL                  =       0x0000;
    public final static int SQL_CB_NON_NULL              =       0x0001;

    /* SQL_CURSOR_COMMIT_BEHAVIOR and SQL_CURSOR_ROLLBACK_BEHAVIOR values */

    public final static int SQL_CB_DELETE                =       0x0000;
    public final static int SQL_CB_CLOSE                 =       0x0001;
    public final static int SQL_CB_PRESERVE              =       0x0002;

    /* SQL_IDENTIFIER_CASE values */

    public final static int SQL_IC_UPPER                 =       0x0001;
    public final static int SQL_IC_LOWER                 =       0x0002;
    public final static int SQL_IC_SENSITIVE             =       0x0003;
    public final static int SQL_IC_MIXED                 =       0x0004;

    /* SQL_TXN_CAPABLE values */

    public final static int SQL_TC_NONE                  =       0x0000;
    public final static int SQL_TC_DML                   =       0x0001;
    public final static int SQL_TC_ALL                   =       0x0002;
    public final static int SQL_TC_DDL_COMMIT            =       0x0003;
    public final static int SQL_TC_DDL_IGNORE            =       0x0004;

    /* SQL_SCROLL_OPTIONS masks */

    public final static long SQL_SO_FORWARD_ONLY         =       0x00000001L;
    public final static long SQL_SO_KEYSET_DRIVEN        =       0x00000002L;
    public final static long SQL_SO_DYNAMIC              =       0x00000004L;
    public final static long SQL_SO_MIXED                =       0x00000008L;
    public final static long SQL_SO_STATIC               =       0x00000010L;

    /* SQL_SCROLL_CONCURRENCY masks */

    public final static long SQL_SCCO_READ_ONLY          =       0x00000001L;
    public final static long SQL_SCCO_LOCK               =       0x00000002L;
    public final static long SQL_SCCO_OPT_ROWVER         =       0x00000004L;
    public final static long SQL_SCCO_OPT_VALUES         =       0x00000008L;

    /* SQL_FETCH_DIRECTION masks */

    public final static long SQL_FD_FETCH_NEXT           =       0x00000001L;
    public final static long SQL_FD_FETCH_FIRST          =       0x00000002L;
    public final static long SQL_FD_FETCH_LAST           =       0x00000004L;
    public final static long SQL_FD_FETCH_PRIOR          =       0x00000008L;
    public final static long SQL_FD_FETCH_ABSOLUTE       =       0x00000010L;
    public final static long SQL_FD_FETCH_RELATIVE       =       0x00000020L;
    public final static long SQL_FD_FETCH_RESUME         =       0x00000040L;
    public final static long SQL_FD_FETCH_BOOKMARK       =       0x00000080L;

    /* SQL_TXN_ISOLATION_OPTION masks */

    public final static long SQL_TXN_READ_UNCOMMITTED    =       0x00000001L;
    public final static long SQL_TXN_READ_COMMITTED      =       0x00000002L;
    public final static long SQL_TXN_REPEATABLE_READ     =       0x00000004L;
    public final static long SQL_TXN_SERIALIZABLE        =       0x00000008L;
    public final static long SQL_TXN_VERSIONING          =       0x00000010L;

    /* SQL_CORRELATION_NAME values */

    public final static int SQL_CN_NONE                  =       0x0000;
    public final static int SQL_CN_DIFFERENT             =       0x0001;
    public final static int SQL_CN_ANY                   =       0x0002;

    /* SQL_NON_NULLABLE_COLUMNS values */

    public final static int SQL_NNC_NULL                 =       0x0000;
    public final static int SQL_NNC_NON_NULL             =       0x0001;

    /* SQL_NULL_COLLATION values */

    public final static int SQL_NC_HIGH                  =       0x0000;
    public final static int SQL_NC_LOW                   =       0x0001;
    public final static int SQL_NC_START                 =       0x0002;
    public final static int SQL_NC_END                   =       0x0004;

    /* SQL_FILE_USAGE values */

    public final static int SQL_FILE_NOT_SUPPORTED       =       0x0000;
    public final static int SQL_FILE_TABLE               =       0x0001;
    public final static int SQL_FILE_QUALIFIER           =       0x0002;

    /* SQL_GETDATA_EXTENSIONS values */

    public final static long SQL_GD_ANY_COLUMN           =       0x00000001L;
    public final static long SQL_GD_ANY_ORDER            =       0x00000002L;
    public final static long SQL_GD_BLOCK                =       0x00000004L;
    public final static long SQL_GD_BOUND                =       0x00000008L;

    /* SQL_ALTER_TABLE values */

    public final static long SQL_AT_ADD_COLUMN           =       0x00000001L;
    public final static long SQL_AT_DROP_COLUMN          =       0x00000002L;

    /* SQL_POSITIONED_STATEMENTS masks */

    public final static long SQL_PS_POSITIONED_DELETE    =       0x00000001L;
    public final static long SQL_PS_POSITIONED_UPDATE    =       0x00000002L;
    public final static long SQL_PS_SELECT_FOR_UPDATE    =       0x00000004L;

    /* SQL_GROUP_BY values */

    public final static int SQL_GB_NOT_SUPPORTED            =   0x0000;
    public final static int SQL_GB_GROUP_BY_EQUALS_SELECT   =   0x0001;
    public final static int SQL_GB_GROUP_BY_CONTAINS_SELECT =   0x0002;
    public final static int SQL_GB_NO_RELATION              =   0x0003;

    /* SQL_OWNER_USAGE masks */

    public final static long SQL_OU_DML_STATEMENTS           =   0x00000001L;
    public final static long SQL_OU_PROCEDURE_INVOCATION     =   0x00000002L;
    public final static long SQL_OU_TABLE_DEFINITION         =   0x00000004L;
    public final static long SQL_OU_INDEX_DEFINITION         =   0x00000008L;
    public final static long SQL_OU_PRIVILEGE_DEFINITION     =   0x00000010L;

    /* SQL_QUALIFIER_USAGE masks */

    public final static long SQL_QU_DML_STATEMENTS           =   0x00000001L;
    public final static long SQL_QU_PROCEDURE_INVOCATION     =   0x00000002L;
    public final static long SQL_QU_TABLE_DEFINITION         =   0x00000004L;
    public final static long SQL_QU_INDEX_DEFINITION         =   0x00000008L;
    public final static long SQL_QU_PRIVILEGE_DEFINITION     =   0x00000010L;

    /* SQL_SUBQUERIES masks */

    public final static long SQL_SQ_COMPARISON               =   0x00000001L;
    public final static long SQL_SQ_EXISTS                   =   0x00000002L;
    public final static long SQL_SQ_IN                       =   0x00000004L;
    public final static long SQL_SQ_QUANTIFIED               =   0x00000008L;
    public final static long SQL_SQ_CORRELATED_SUBQUERIES    =   0x00000010L;

    /* SQL_UNION masks */

    public final static long SQL_U_UNION                     =   0x00000001L;
    public final static long SQL_U_UNION_ALL                 =   0x00000002L;

    /* SQL_BOOKMARK_PERSISTENCE values */

    public final static long SQL_BP_CLOSE                    =   0x00000001L;
    public final static long SQL_BP_DELETE                   =   0x00000002L;
    public final static long SQL_BP_DROP                     =   0x00000004L;
    public final static long SQL_BP_TRANSACTION              =   0x00000008L;
    public final static long SQL_BP_UPDATE                   =   0x00000010L;
    public final static long SQL_BP_OTHER_HSTMT              =   0x00000020L;
    public final static long SQL_BP_SCROLL                   =   0x00000040L;

    /* SQL_STATIC_SENSITIVITY values */

    public final static long SQL_SS_ADDITIONS                =   0x00000001L;
    public final static long SQL_SS_DELETIONS                =   0x00000002L;
    public final static long SQL_SS_UPDATES                  =   0x00000004L;

    /* SQL_LOCK_TYPESL masks */

    public final static long SQL_LCK_NO_CHANGE               =   0x00000001L;
    public final static long SQL_LCK_EXCLUSIVE               =   0x00000002L;
    public final static long SQL_LCK_UNLOCK                  =   0x00000004L;

    /* SQL_POS_OPERATIONS masks */

    public final static long SQL_POS_POSITION                =   0x00000001L;
    public final static long SQL_POS_REFRESH                 =   0x00000002L;
    public final static long SQL_POS_UPDATE                  =   0x00000004L;
    public final static long SQL_POS_DELETE                  =   0x00000008L;
    public final static long SQL_POS_ADD                     =   0x00000010L;

    /* SQL_QUALIFIER_LOCATION values */

    public final static long SQL_QL_START                    =   0x0001L;
    public final static long SQL_QL_END                      =   0x0002L;

    /* SQL_OJ_CAPABILITIES values */

    public final static long SQL_OJ_LEFT                      =  0x00000001L;
    public final static long SQL_OJ_RIGHT                     =  0x00000002L;
    public final static long SQL_OJ_FULL                      =  0x00000004L;
    public final static long SQL_OJ_NESTED                    =  0x00000008L;
    public final static long SQL_OJ_NOT_ORDERED               =  0x00000010L;
    public final static long SQL_OJ_INNER                     =  0x00000020L;
    public final static long SQL_OJ_ALL_COMPARISON_OPS        =  0x00000040L;

    /* options for SQLGetStmtOption/SQLSetStmtOption */
    public final static int SQL_QUERY_TIMEOUT            =  0;
    public final static int SQL_MAX_ROWS                 =  1;
    public final static int SQL_NOSCAN                   =  2;
    public final static int SQL_MAX_LENGTH               =  3;
    public final static int SQL_ASYNC_ENABLE             =  4;
    public final static int SQL_BIND_TYPE                =  5;
    public final static int SQL_CURSOR_TYPE              =  6;
    public final static int SQL_CONCURRENCY              =  7;
    public final static int SQL_KEYSET_SIZE              =  8;
    public final static int SQL_ROWSET_SIZE              =  9;
    public final static int SQL_SIMULATE_CURSOR          =  10;
    public final static int SQL_RETRIEVE_DATA            =  11;
    public final static int SQL_USE_BOOKMARKS            =  12;
    public final static int SQL_GET_BOOKMARK             =  13;      /*      GetStmtOption Only */
    public final static int SQL_ROW_NUMBER               =  14;      /*      GetStmtOption Only */
    public final static int SQL_STMT_OPT_MAX             =  SQL_ROW_NUMBER;

    public final static int SQL_STMT_OPT_MIN             =  SQL_QUERY_TIMEOUT;


    /* SQL_QUERY_TIMEOUT options */
    public final static long SQL_QUERY_TIMEOUT_DEFAULT   =  0;

    /* SQL_MAX_ROWS options */
    public final static long SQL_MAX_ROWS_DEFAULT        =  0;

    /* SQL_NOSCAN options */
    public final static long SQL_NOSCAN_OFF              =  0;     /*      1.0 FALSE */
    public final static long SQL_NOSCAN_ON               =  1;     /*      1.0 TRUE */
    public final static long SQL_NOSCAN_DEFAULT          =  SQL_NOSCAN_OFF;

    /* SQL_MAX_LENGTH options */
    public final static long SQL_MAX_LENGTH_DEFAULT      =  0;

    /* SQL_ASYNC_ENABLE options */
    public final static long SQL_ASYNC_ENABLE_OFF        =  0;
    public final static long SQL_ASYNC_ENABLE_ON         =  1;
    public final static long SQL_ASYNC_ENABLE_DEFAULT    =  SQL_ASYNC_ENABLE_OFF;

    /* SQL_BIND_TYPE options */
    public final static long SQL_BIND_BY_COLUMN          =  0;
    public final static long SQL_BIND_TYPE_DEFAULT       =  SQL_BIND_BY_COLUMN;  /* Default value */

    /* SQL_CONCURRENCY options */
    public final static long SQL_CONCUR_READ_ONLY        =  1;
    public final static long SQL_CONCUR_LOCK             =  2;
    public final static long SQL_CONCUR_ROWVER           =  3;
    public final static long SQL_CONCUR_VALUES           =  4;
    public final static long SQL_CONCUR_DEFAULT          =  SQL_CONCUR_READ_ONLY; /* Default value;
    */

    /* SQL_CURSOR_TYPE options */
    public final static long SQL_CURSOR_FORWARD_ONLY     =  0;
    public final static long SQL_CURSOR_KEYSET_DRIVEN    =  1;
    public final static long SQL_CURSOR_DYNAMIC          =  2;
    public final static long SQL_CURSOR_STATIC           =  3;
    public final static long SQL_CURSOR_TYPE_DEFAULT     =  SQL_CURSOR_FORWARD_ONLY; /* Default value */

    /* SQL_ROWSET_SIZE options */
    public final static long SQL_ROWSET_SIZE_DEFAULT     =  1;

    /* SQL_KEYSET_SIZE options */
    public final static long SQL_KEYSET_SIZE_DEFAULT     =  0;

    /* SQL_SIMULATE_CURSOR options */
    public final static long SQL_SC_NON_UNIQUE           =  0;
    public final static long SQL_SC_TRY_UNIQUE           =  1;
    public final static long SQL_SC_UNIQUE               =  2;

    /* SQL_RETRIEVE_DATA options */
    public final static long SQL_RD_OFF                  =  0;
    public final static long SQL_RD_ON                   =  1;
    public final static long SQL_RD_DEFAULT              =  SQL_RD_ON;

    /* SQL_USE_BOOKMARKS options */
    public final static long SQL_UB_OFF                  =  0;
    public final static long SQL_UB_ON                   =  1;
    public final static long SQL_UB_DEFAULT              =  SQL_UB_OFF;

    /* options for SQLSetConnectOption/SQLGetConnectOption */
    public final static int SQL_ACCESS_MODE              =  101;
    public final static int SQL_AUTOCOMMIT               =  102;
    public final static int SQL_LOGIN_TIMEOUT            =  103;
    public final static int SQL_OPT_TRACE                =  104;
    public final static int SQL_OPT_TRACEFILE            =  105;
    public final static int SQL_TRANSLATE_DLL            =  106;
    public final static int SQL_TRANSLATE_OPTION         =  107;
    public final static int SQL_TXN_ISOLATION            =  108;
    public final static int SQL_CURRENT_QUALIFIER        =  109;
    public final static int SQL_ODBC_CURSORS             =  110;
    public final static int SQL_QUIET_MODE               =  111;
    public final static int SQL_PACKET_SIZE              =  112;
    public final static int SQL_CONN_OPT_MAX             =  SQL_PACKET_SIZE;
    public final static int SQL_CONNECT_OPT_DRVR_START   =  1000;

    public final static int SQL_CONN_OPT_MIN             =  SQL_ACCESS_MODE;

    /* SQL_ACCESS_MODE options */
    public final static long SQL_MODE_READ_WRITE         =  0;
    public final static long SQL_MODE_READ_ONLY          =  1;
    public final static long SQL_MODE_DEFAULT            =  SQL_MODE_READ_WRITE;

    /* SQL_AUTOCOMMIT options */
    public final static long SQL_AUTOCOMMIT_OFF          =   0;
    public final static long SQL_AUTOCOMMIT_ON           =   1;
    public final static long SQL_AUTOCOMMIT_DEFAULT      =   SQL_AUTOCOMMIT_ON;

    /* SQL_LOGIN_TIMEOUT options */
    public final static long SQL_LOGIN_TIMEOUT_DEFAULT   =   15;

    /* SQL_OPT_TRACE options */
    public final static long SQL_OPT_TRACE_OFF           =   0;
    public final static long SQL_OPT_TRACE_ON            =   1;
    public final static long SQL_OPT_TRACE_DEFAULT       =   SQL_OPT_TRACE_OFF;
    public final static String SQL_OPT_TRACE_FILE_DEFAULT   =  "\\SQL.LOG";

    /* SQL_ODBC_CURSORS options */
    public final static int SQL_CUR_USE_IF_NEEDED        =   0;
    public final static int SQL_CUR_USE_ODBC             =   1;
    public final static int SQL_CUR_USE_DRIVER           =   2;
    public final static int SQL_CUR_DEFAULT              =   SQL_CUR_USE_DRIVER;

    /* Column types and scopes in SQLSpecialColumns.  */
    public final static int SQL_BEST_ROWID               =   1;
    public final static int SQL_ROWVER                   =   2;

    public final static int SQL_SCOPE_CURROW             =   0;
    public final static int SQL_SCOPE_TRANSACTION        =   1;
    public final static int SQL_SCOPE_SESSION            =   2;

    /* Defines for SQLStatistics */
    public final static int SQL_INDEX_UNIQUE             =   0;
    public final static int SQL_INDEX_ALL                =   1;

    public final static int SQL_QUICK                    =   0;
    public final static int SQL_ENSURE                   =   1;

    /* Defines for SQLStatistics (returned in the result set) */
    public final static int SQL_TABLE_STAT               =   0;
    public final static int SQL_INDEX_CLUSTERED          =   1;
    public final static int SQL_INDEX_HASHED             =   2;
    public final static int SQL_INDEX_OTHER              =   3;

    /* Defines for SQLSpecialColumns (returned in the result set) */
    public final static int SQL_PC_UNKNOWN               =   0;
    public final static int SQL_PC_NOT_PSEUDO            =   1;
    public final static int SQL_PC_PSEUDO                =   2;

    /* SQLDataSources "fDirection" values, also used on SQLExtendedFetch() */
    public final static int SQL_FETCH_NEXT               =                   1;
    public final static int SQL_FETCH_FIRST              =                   2;

    /* SQLExtendedFetch "fFetchType" values */
    //public final static int SQL_FETCH_NEXT               =     1;
    //public final static int SQL_FETCH_FIRST              =     2;
    public final static int SQL_FETCH_LAST               =     3;
    public final static int SQL_FETCH_PRIOR              =     4;
    public final static int SQL_FETCH_ABSOLUTE           =     5;
    public final static int SQL_FETCH_RELATIVE           =     6;
    public final static int SQL_FETCH_BOOKMARK           =     8;
    
    /*      Deprecated defines from prior versions of ODBC */
    public final static int  SQL_DATABASE_NAME         =      16;    /* Use SQLGetConnectOption/SQL_CURRENT_QUALIFIER */
    public final static long SQL_FD_FETCH_PREV         =      SQL_FD_FETCH_PRIOR;
    public final static long SQL_FETCH_PREV            =      SQL_FETCH_PRIOR;
    public final static long SQL_CONCUR_TIMESTAMP      =      SQL_CONCUR_ROWVER;
    public final static long SQL_SCCO_OPT_TIMESTAMP    =      SQL_SCCO_OPT_ROWVER;
    public final static long SQL_CC_DELETE             =      SQL_CB_DELETE;
    public final static long SQL_CR_DELETE             =      SQL_CB_DELETE;
    public final static long SQL_CC_CLOSE              =      SQL_CB_CLOSE;
    public final static long SQL_CR_CLOSE              =      SQL_CB_CLOSE;
    public final static long SQL_CC_PRESERVE           =      SQL_CB_PRESERVE;
    public final static long SQL_CR_PRESERVE           =      SQL_CB_PRESERVE;
    public final static long SQL_FETCH_RESUME          =      7    ; /* Not supported by 2.0 drivers */
    public final static long SQL_SCROLL_FORWARD_ONLY  =      0L   ; /*-SQL_CURSOR_FORWARD_ONLY */
    public final static long SQL_SCROLL_KEYSET_DRIVEN =      (-1L); /*-SQL_CURSOR_KEYSET_DRIVEN */
    public final static long SQL_SCROLL_DYNAMIC       =      (-2L); /*-SQL_CURSOR_DYNAMIC */
    public final static long SQL_SCROLL_STATIC        =      (-3L); /*-SQL_CURSOR_STATIC */
    public final static int SQL_PC_NON_PSEUDO         =      SQL_PC_NOT_PSEUDO;

    /* SQLBindParameter extensions */
    public final static int SQL_DEFAULT_PARAM            = (-5);
    public final static int SQL_IGNORE                   = (-6);
    public final static int SQL_LEN_DATA_AT_EXEC_OFFSET  = (-100);
        
    /* Defines for SQLSetPos */
    public final static int SQL_ENTIRE_ROWSET            = 0;
    
    /* Operations in SQLSetPos */
    public final static int SQL_POSITION                 = 0;               /*      1.0 FALSE */
    public final static int SQL_REFRESH                  = 1;               /*      1.0 TRUE */
    public final static int SQL_UPDATE                   = 2;
    public final static int SQL_DELETE                   = 3;
    public final static int SQL_ADD                      = 4;
    
    /* Lock options in SQLSetPos */
    public final static int SQL_LOCK_NO_CHANGE           = 0;               /*      1.0 FALSE */
    public final static int SQL_LOCK_EXCLUSIVE           = 1;               /*      1.0 TRUE */
    public final static int SQL_LOCK_UNLOCK              = 2;
    
    
    /* Level 1 Prototypes                            */
    
    /* Options for SQLDriverConnect */
    public final static int SQL_DRIVER_NOPROMPT          =    0;
    public final static int SQL_DRIVER_COMPLETE          =    1;
    public final static int SQL_DRIVER_PROMPT            =    2;
    public final static int SQL_DRIVER_COMPLETE_REQUIRED =    3;
    
    /* Level 2 Functions                             */
    
    /* SQLExtendedFetch "rgfRowStatus" element values */
    public final static int SQL_ROW_SUCCESS              =     0;
    public final static int SQL_ROW_DELETED              =     1;
    public final static int SQL_ROW_UPDATED              =     2;
    public final static int SQL_ROW_NOROW                =     3;
    public final static int SQL_ROW_ADDED                =     4;
    public final static int SQL_ROW_ERROR                =     5;
    
    /* Defines for SQLForeignKeys (returned in result set) */
    public final static int SQL_CASCADE                  =     0;
    public final static int SQL_RESTRICT                 =     1;
    public final static int SQL_SET_NULL                 =     2;
    public final static int SQL_NO_ACTION                =     3;
    public final static int SQL_SET_DEFAULT              =     4;
    
    /* Defines for SQLBindParameter and
                               SQLProcedureColumns (returned in the result set) */
    public final static int SQL_PARAM_TYPE_UNKNOWN       =     0;
    public final static int SQL_PARAM_INPUT              =     1;
    public final static int SQL_PARAM_INPUT_OUTPUT       =     2;
    public final static int SQL_RESULT_COL               =     3;
    public final static int SQL_PARAM_OUTPUT             =     4;
    public final static int SQL_RETURN_VALUE             =     5;
    
    
    /* Defines for SQLProcedures (returned in the result set) */
    public final static int SQL_PT_UNKNOWN               =     0;
    public final static int SQL_PT_PROCEDURE             =     1;
    public final static int SQL_PT_FUNCTION              =     2;
    
    /* Defines used by Driver Manager when mapping SQLSetParam to SQLBindParameter
    */
    public final static long SQL_PARAM_TYPE_DEFAULT       =     SQL_PARAM_INPUT_OUTPUT;
    public final static long SQL_SETPARAM_VALUE_MAX       =     (-1L);
    
    // for SQLError
    public final static int SQL_ERROR_ENV=0;
    public final static int SQL_ERROR_CONNECT=1;
    public final static int SQL_ERROR_HSTMT=2;

    // my message extentsion
    public final static int JADE_SET_BIND_VALUES    = 1010;
    public final static int JADE_GET_BIND_VALUES    = 1011;
    public final static int JADE_RESET_BIND_VALUES  = 1012;

    boolean m_err;
    String  m_strServer;
    int    m_nPort;

    boolean debug;

    Socket  m_db;
    InputStream m_dbInputStream;
    OutputStream m_dbOutputStream;

    Vector vBind;

    public JadeDB( String strServer, int nPort )
    {
    }

    public void SetError( boolean err )
    {
    }

    public long SQLBindCol( int icol, int fCType, Object o )
    {
    }

    public long SQLBindParameter( int ipar, int fParamType, int fCType,
        int fSqlType, long cbColDef, int ibScale, Object o )
    {
    }

    public long SQLBrowseConnect( String strDB, OutString out )
    {
    }

    public long SQLCancel()
    {
    }

    public long SQLColAttributes( int icol, int fDescType, OutString strDesc, OutLong fDesc )
    {
    }

    public long SQLColumnPrivileges( String TableQualifer,
        String strOwner, String strTableName, String ColumnName )
    {
    }

    public long SQLColumns( String TableQualifer,
        String strOwner, String strTableName, String ColumnName )
    {
    }

    public long SQLConnect( String szDsn, String szUID, String szAuth )
    {
    }

    public long SQLDataSources( int fDirection, OutString szDsn, OutString szDescription )
    {
    }

    public long SQLDescribeCol( int icol, OutString ColName, OutInteger fSqlType, OutLong ColDef, OutInteger ibScale, OutInteger Nullable )
    {
    }


    public long SQLDescribeParam( int ipar, OutInteger fSqlType, OutLong ColDef, OutInteger Nullable )
    {
    }

    public long SQLDisconnect()
    {
    }

    public long SQLDriverConnect( long hwnd, int fDriverCompletion, String strConnect, OutString out )
    {
    }

    public long SQLDrivers( int fDirection, OutString szDes, OutString szAtt )
    {
    }

    public long SQLError( int nType, OutString SQLState, OutLong NativeError,
        OutString ErrorMsg )
    {
    }

    public long SQLExecDirect( String sql )
    {
    }

    public long SQLExecute()
    {
    }

    public long SQLExtendedFetch( int fFetchType, int irow, OutLong crow, OutInteger RowStatus[])
    {
    }

    public long SQLFetch()
    {
    }

    public long SQLForeignKeys(
        String PkTableQualifer,
        String PkOwner,
        String PkTableName,
        String FkTableQualifer,
        String FkOwner,
        String FkTableName )
    {
    }

    public long SQLGetConnectOption( int fOption, OutLong Param )
    {
    }

    public long SQLGetConnectOption( int fOption, OutString Param )
    {
    }

    public long SQLGetCursorName( OutString strName )
    {
    }

    public long SQLGetData( int icol, int fCType, OutObject out )
    {
    }

    public long SQLGetFunctions( int fFunction, OutInteger fExist[] )
    {
    }

    public long SQLGetInfo( int fInfoType, OutString out )
    {
    }

    public long SQLGetInfo( int fInfoType, OutInteger nOut )
    {
    }

    public long SQLGetInfo( int fInfoType, OutLong nOut )
    {
    }

    public long SQLGetStmtOption( int fOption, OutLong nOut )
    {
    }

    public long SQLGetTypeInfo( int fType )
    {
    }

    public long SQLMoreResults()
    {
    }

    public long SQLNativeSql( String sql, OutString out )
    {
    }

    public long SQLNumParams( OutLong NumPar )
    {
    }

    public long SQLNumResultCols( OutLong col )
    {
    }

    public long SQLParamData( OutString out )
    {
    }

    public long SQLParamOptions( long cRow, OutLong iRow )
    {
    }

    public long SQLPrepare( String str )
    {
    }

    public long SQLPrimaryKeys( String TableQualifer,
        String strOwner, String strTableType )
    {
    }

    public long SQLProcdureColumns( String ProcQualifer,
        String ProcOwner, String ProcName, String ColumnName )
    {
    }

    public long SQLProcedures( String ProcQualifer,
        String ProcOwner, String ProcName )
    {
    }

    public long SQLPutData( String strIn)
    {
    }

    public long SQLRowCount( OutLong Row )
    {
    }

    public long SQLSetConnectOption( int nOption, int nParam )
    {
    }

    public long SQLSetConnectOption( int nOption, long nParam )
    {
    }

    public long SQLSetCursorName( String strName )
    {
    }

    public long SQLSetPos( int irow, int fOption, int fLock )
    {
    }

    public long SQLSetScrollOptions( int fConcurrency, long crowKeyset, int crowRowset )
    {
    }

    public long SQLSetStmtOption( int Option, long Param )
    {
    }

    public long SQLSetStmtOption( int Option, String Param )
    {
    }

    public long SQLSpecialColumns( int ColType, String TableQualifer,
        String Owner, String TableName, int nScope, int nNullable )
    {
    }

    public long SQLStatistics( String TableQualifer, String Owner,
        String TableName, int nUnique, int nAccuracy )
    {
    }

    public long SQLTablePrivileges( String TableQualifer, String Owner, String TableType )
    {
    }

    public long SQLTables( String TableQualifer, String Owner, String TableName, String TableType )
    {
    }

    public long SQLTransact( int nType )
    {
    }

    public long JadeSQLSetValues()
    {
    }

    public long JadeSQLGetValues()
    {
    }

    public long JadeResetBindVector()
    {
    }
}
