//////////////////////////////////////////////////////////////
// OutDate.java
// 
// Jade Java Code
// Copyright (C) 1996 Kwan Software Research
// All rights reserved.
//
// Please send email to: tkwan@aa.net for license detail.
//
//////////////////////////////////////////////////////////////

import java.lang.*;
import java.io.*;

class OutDate extends OutObject 
{
    public int year;
    public int month;
    public int day;

    public OutDate( int _year, int _month, int _day )
    {
        year = _year;
        month = _month;
        day = _day;
    }

    public String toString()
    {
        return(year+"/"+month+"/"+day);
    }

    public void set(int _year, int _month, int _day )
    {
        year = _year;
        month = _month;
        day = _day;
    }

    public void readStream( InputStream s )
    {
        try
        {
            int ch1 = s.read();
            int ch2 = s.read();
            int ch3 = s.read();
            int ch4 = s.read();
            //if (((ch1 | ch2 | ch3 | ch4) < 0)
            //    throw new EOFException();
            year = ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
            ch1 = s.read();
            ch2 = s.read();
            ch3 = s.read();
            ch4 = s.read();
            month = ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
            ch1 = s.read();
            ch2 = s.read();
            ch3 = s.read();
            ch4 = s.read();
            day = ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
        } catch (IOException e)
        {
            // cannot write
        }
    }

    public void writeStream( OutputStream s )
    {
        try
        {
            s.write((year >>> 24) & 0xFF);
            s.write((year >>> 16) & 0xFF);
            s.write((year >>>  8) & 0xFF);
            s.write((year >>>  0) & 0xFF);
            s.write((month >>> 24) & 0xFF);
            s.write((month >>> 16) & 0xFF);
            s.write((month >>>  8) & 0xFF);
            s.write((month >>>  0) & 0xFF);
            s.write((day >>> 24) & 0xFF);
            s.write((day >>> 16) & 0xFF);
            s.write((day >>>  8) & 0xFF);
            s.write((day >>>  0) & 0xFF);
        } catch (IOException e)
        {
            // cannot write
        }
    }
}


