//////////////////////////////////////////////////////////////
// OutInteger.java
// 
// Jade Java Code
// Copyright (C) 1996 Kwan Software Research
// All rights reserved.
//
// Please send email to: tkwan@aa.net for license detail.
//
//////////////////////////////////////////////////////////////

import java.lang.*;
import java.io.*;

class OutInteger extends OutObject 
{
    public int nValue;

    public OutInteger( int i )
    {
        nValue = i;
    }

    public OutInteger( Integer i )
    {
        nValue = i.intValue();
    }

    public String toString()
    {
        return(String.valueOf(nValue));
    }

    public void set(int i)
    {
        nValue=i;
    }

    public void set(Integer i)
    {
        nValue=i.intValue();
    }

    public int get()
    {
        return(nValue);
    }

    public void readStream( InputStream s )
    {
        try
        {
            int ch1 = s.read();
            int ch2 = s.read();
            int ch3 = s.read();
            int ch4 = s.read();
            //if (((ch1 | ch2 | ch3 | ch4) < 0)
            //    throw new EOFException();
            nValue = ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
            // System.err.println("reading integer : "+nValue);
        } catch (IOException e)
        {
            // cannot write
        }
    }

    public void writeStream( OutputStream s )
    {
        try
        {
            s.write((nValue >>> 24) & 0xFF);
            s.write((nValue >>> 16) & 0xFF);
            s.write((nValue >>>  8) & 0xFF);
            s.write((nValue >>>  0) & 0xFF);
        } catch (IOException e)
        {
            // cannot write
        }
    }
}
