//////////////////////////////////////////////////////////////
// OutLong.java
// 
// Jade Java Code
// Copyright (C) 1996 Kwan Software Research
// All rights reserved.
//
// Please send email to: tkwan@aa.net for license detail.
//
//////////////////////////////////////////////////////////////

import java.lang.*;
import java.io.*;

class OutLong extends OutObject 
{
    public long nValue;

    public OutLong( long i )
    {
        nValue = i;
    }

    public OutLong( Long i )
    {
        nValue = i.longValue();
    }

    public String toString()
    {
        return(String.valueOf(nValue));
    }

    public void set(long i)
    {
        nValue=i;
    }

    public void set(Long i)
    {
        nValue=i.longValue();
    }

    public long get()
    {
        return(nValue);
    }

    public void readStream( InputStream s )
    {
        try
        {
            int ch1 = s.read();
            int ch2 = s.read();
            int ch3 = s.read();
            int ch4 = s.read();
            //if (((ch1 | ch2 | ch3 | ch4) < 0)
            //    throw new EOFException();
            int s1 = ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
            ch1 = s.read(); 
            ch2 = s.read(); 
            ch3 = s.read(); 
            ch4 = s.read(); 
            int s2 = ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
            nValue = ( s1 << 32L) + (s2 & 0xFFFFFFFFL);
            // System.err.println("read long: "+nValue);
        } catch (IOException e )
        {
            
        }
    }

    public void writeStream( OutputStream s )
    {
        try
        {
            s.write((int)(nValue >>> 56) & 0xFF);
            s.write((int)(nValue >>> 48) & 0xFF);
            s.write((int)(nValue >>> 40) & 0xFF);
            s.write((int)(nValue >>> 32) & 0xFF);
            s.write((int)(nValue >>> 24) & 0xFF);
            s.write((int)(nValue >>> 16) & 0xFF);
            s.write((int)(nValue >>>  8) & 0xFF);
            s.write((int)(nValue >>>  0) & 0xFF);
        } catch (IOException e )
        {
            
        }
    }
}

