//////////////////////////////////////////////////////////////
// OutString.java
// 
// Jade Java Code
// Copyright (C) 1996 Kwan Software Research
// All rights reserved.
//
// Please send email to: tkwan@aa.net for license detail.
//
//////////////////////////////////////////////////////////////

import java.lang.*;
import java.io.*;

class OutString extends OutObject 
{
    public String string;

    public OutString( String str )
    {
        string = str;
    }

    public String toString()
    {
        return(string);
    }

    public void set( String str )
    {
        string = str;
    }

    public String get()
    {
        return(string);
    }

    public void readStream( InputStream s )
    {
        try
        {
            int size = s.read();
            if (size==0)
                string="";
            else
            {
                byte ar[] = new byte[size+1];
                s.read( ar, 0, size );
                string = new String(ar,0,0,size);
            }
            // System.err.println("reading: "+string);
        } catch (IOException e )
        {
            // cannot read
        }
    }

    public void writeStream( OutputStream s )
    {
        try
        {
            byte ar[] = new byte[string.length()+10];
            string.getBytes( 0, string.length(), ar, 0 );
            byte size = (byte)string.length();
            s.write( size );
            s.write( ar, 0, string.length());
        } catch (IOException e)
        {
            // cannot write
        }
    }
}
