//////////////////////////////////////////////////////////////
// OutTime.java
// 
// Jade Java Code
// Copyright (C) 1996 Kwan Software Research
// All rights reserved.
//
// Please send email to: tkwan@aa.net for license detail.
//
//////////////////////////////////////////////////////////////

import java.lang.*;
import java.io.*;

class OutTime extends OutObject 
{
    public int hour;
    public int minute;
    public int second;

    public OutTime( int _hour, int _minute, int _second )
    {
        hour = _hour;
        minute = _minute;
        second = _second;
    }

    public String toString()
    {
        return(hour+":"+minute+":"+second+":");
    }

    public void set(int _hour, int _minute, int _second ) 
    {
        hour = _hour;
        minute = _minute;
        second = _second;
    }

    public void readStream( InputStream s )
    {
        try
        {
            int ch1 = s.read();
            int ch2 = s.read();
            int ch3 = s.read();
            int ch4 = s.read();
            hour = ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
            ch1 = s.read();
            ch2 = s.read();
            ch3 = s.read();
            ch4 = s.read();
            minute = ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
            ch1 = s.read();
            ch2 = s.read();
            ch3 = s.read();
            ch4 = s.read();
            second = ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
        } catch (IOException e)
        {
            // cannot write
        }
    }

    public void writeStream( OutputStream s )
    {
        try
        {
            s.write((hour >>> 24) & 0xFF);
            s.write((hour >>> 16) & 0xFF);
            s.write((hour >>>  8) & 0xFF);
            s.write((hour >>>  0) & 0xFF);
            s.write((minute >>> 24) & 0xFF);
            s.write((minute >>> 16) & 0xFF);
            s.write((minute >>>  8) & 0xFF);
            s.write((minute >>>  0) & 0xFF);
            s.write((second >>> 24) & 0xFF);
            s.write((second >>> 16) & 0xFF);
            s.write((second >>>  8) & 0xFF);
            s.write((second >>>  0) & 0xFF);
        } catch (IOException e)
        {
            // cannot write
        }
    }
}


