/* complex.h

  compile :   JUMP -cl ../classes -op complex
  run:        java global

       Complex Number Library
       class complex:  declarations for complex numbers.

*/

import java.io.PrintStream;

class complex {
protected:      // Implementation
	double re, im;
public:
	// constructors
	complex() {}
	complex(double __re_val, double __im_val) {
		re = __re_val;
              im = __im_val; }

       complex operator+() { return this;  }
       complex operator-() { return new complex(-re, -im);   }

	// Definitions of compound-assignment operator member functions
	complex operator+=(complex __z2) {
		re += __z2.re;
		im += __z2.im;
		return this; 	}

       complex operator+=(double __re_val2) {
		re += __re_val2;
		return this;	}

       complex operator-=(complex __z2) {
		re -= __z2.re;
		im -= __z2.im;
		return this;	}

       complex operator-=(double __re_val2) {
		re -= __re_val2;
		return this;	}

       complex operator*=(double __re_val2) {
		re *= __re_val2;
		im *= __re_val2;
		return this;	}

       complex operator/=(double __re_val2) {
		re /= __re_val2;
		im /= __re_val2;
		return this;	}
       void print( PrintStream os ) { os.print( re + "," + im ); }
};

// Definitions of non-member complex functions

double real(complex __z)
{
	return __z.re;
}

double imag(complex __z)
{
	return __z.im;
}

complex conj(complex __z)
{
       return new complex(__z.re, -__z.im);
}

complex polar(double __mag, double __angle)
{
       return new complex(__mag*Math.cos(__angle), __mag*Math.sin(__angle));
}


// Definitions of non-member binary operator functions

complex operator+(complex __z1, complex __z2)
{
       return new complex(__z1.re + __z2.re, __z1.im + __z2.im);
}

complex operator+(double __re_val1, complex __z2)
{
       return new complex(__re_val1 + __z2.re, __z2.im);
}

complex operator+(complex __z1, double __re_val2)
{
       return new complex(__z1.re + __re_val2, __z1.im);
}

complex operator-(complex __z1, complex __z2)
{
       return new complex(__z1.re - __z2.re, __z1.im - __z2.im);
}

complex operator-(double __re_val1, complex __z2)
{
       return new complex(__re_val1 - __z2.re, -__z2.im);
}

complex operator-(complex __z1, double __re_val2)
{
       return new complex(__z1.re - __re_val2, __z1.im);
}

complex operator*(complex __z1, double __re_val2)
{
       return new complex(__z1.re*__re_val2, __z1.im*__re_val2);
}

complex operator*(double __re_val1, complex __z2)
{
       return new complex(__z2.re*__re_val1, __z2.im*__re_val1);
}

complex operator/(complex __z1, double __re_val2)
{
       return new complex(__z1.re/__re_val2, __z1.im/__re_val2);
}

boolean operator==(complex __z1, complex __z2)
{
	return __z1.re == __z2.re && __z1.im == __z2.im;
}

boolean operator!=(complex __z1, complex __z2)
{
	return __z1.re != __z2.re || __z1.im != __z2.im;
}

PrintStream operator<<( PrintStream os, complex c )
{
       c.print( os );
       return os;
}

PrintStream operator<<( PrintStream os, String s )
{
       os.print( s );
       return os;
}

PrintStream operator<<( PrintStream os, float f )
{
       os.print( f );
       return os;
}

PrintStream operator<<( PrintStream os, int i )
{
       os.print( i );
       return os;
}

PrintStream operator<<( PrintStream os, char c )
{
       os.print( c );
       return os;
}

void DefaultTest( float f1, int i1 = 3, int i2 = 4 )
{
       System.out << "f1: " << f1 << " i1: " << i1 << " i2: " << i2 << '\n';
}

void DefaultTest( String s1, int i1 = 7, int i2 = 8 )
{
       System.out << "s1: " << s1 << " i1: " << i1 << " i2: " << i2 << '\n';
}

void main( String argv[] )
{
       System.out.println( "Start testing operator overloading and default parameters!\n" );
       complex C1 = new complex( 3, 4), C2 = new complex( 5, 6 );
       if( C1 == C2 ) System.out << "C1 equals C2 = " << C1 << '\n';
       else System.out << "C1 doesn't equal C2 (" << C1 << " and " << C2 << ")\n";
       complex C3 = C1 + C2 - C1 - C2;
       System.out << "C1 + C2 - C1 - C2 = " << C3 << '\n';
       DefaultTest( 5.5f );
       DefaultTest( "and finally" );
       System.out.println( "End" );
}

