//=================================================================================
// File MCalc.java jlouie 9.96 73270.1776@compuserve.com
// This file should be named MCalc.java and compiled with 'javac'/'java compiler'
// Title  * MCalc v2.00 *
// Supplied AS_IS.
// Free if distributed as is with a functioning and unaltered about box.
// Thanks to W. Carlini, T. Ball, R. Scorer, W. Brogden & the folks at Java Support.
// Creates an GUI AWT Mortgage Calculator
// Compiled with: JDK 1.02 Mac/Win95
// Tested with: Netscape 3.0b6 (Mac) 2.01 (Win95)
// "New" Features:
//    Formats numeric output (see Format.java).
//    Implements a Checkbox group to select the calculation field.
//    Calls DoCalc() if user hits return key in a TextField
//    Returns to a TextField after a dialog.   
//    Uses a package of reusable classes.
//    Supports polymorphic main();
// Known bugs and incompatabilities:
//    OKbutton.requestFocus() is buggy on Mac
//    Tab key is buggy in MyTextField Netscape 3.0b6 (Mac)
//    Modal Dialog boxes are non_modal under Netscape 2.01 (Win95)
// Features not implemented:
//    Responding to keyboard equivalents.
//    Online help
// Ref: "Teach Yourself Java in 21 Days", Lemay & Perkins, Sams Net
// Ref: "Java in a Nutshell", David Flanagan, O'Reilly & Associates
// Ref: "Core Java", Cornell & Horstmann, Sunsoft Press
// Ref: "The Java Programming Language" Arnold & Gosling Addison Wesley
// General Ref: "Code Complete" Steve McConnell, Microsoft Press
// OOP Ref: "Object-Oriented Analysis and Design" Grady Booch, Addison Wesley
//=================================================================================

import java.awt.*;
import java.applet.*;
import Widgets103.*;

//=====================================================================
//
// Class * MCalc *
//
// Applet class.  Adds a button to a web page.
// Will also execute as an application (requires Java Interpreter)
//
//======================================================================

public class MCalc extends Applet
{  
   public final static boolean IS_APPLICATION= true;
   public final static boolean IS_APPLET= false;
   
   Button newCalc;
      
   public void init()  // applet entry point
   {
      add(new Label("Mortgage Calculator:"));
      add(newCalc= new Button("New Calculator"));
   }
   
   public static void main(String[] input)  // application entry point Win
   {new MyFrame("MCalc", IS_APPLICATION);}
   
   public static void main()  // application entry point Mac
   {new MyFrame("MCalc", IS_APPLICATION);}
      
   public boolean action(Event evt, Object obj) 
   {  
      if (evt.target == newCalc)
      {
            new MyFrame("MCalc", IS_APPLET);
            return true;
      }
      return super.action(evt, obj);   
   }
}


//============================================================================
//
// Class * MyFrame *
//
// Calculator Input/Output Interface
//
//==========================================================================

class MyFrame extends Frame implements DialogInterface
{
   static final Point p= new Point(30,30);

   private  MyTextField[]  textArray;     // Array of four extended text boxes for input/output
   private  Label          messageBox;    // Error message             
   private  MyDialog       dl= null;      // About Dialog Box
   private  MyDialog       err= null;     // Error Dialog Box
   private  double         dbArray[],dbResult= 0;  // Array of double, stores numeric input
   private boolean         isApplication= false;
   private Checkbox        checkPrinciple;
   private Checkbox        checkInterest;
   private Checkbox        checkMonths;
   private Checkbox        checkPayment;
   private CheckboxGroup   g;
   private Checkbox        checkTarget;
   private Button          buttonOK;
   private Button          buttonQuit;
   private boolean         isFormat= true;
   private MenuItem        itemEnableFormat, itemDisableFormat;
       
   
   MyFrame(String title, boolean isApplication)  //  Main Window Constructor
   {
      super(title);
      this.isApplication= isApplication;
      dbArray= new double[4];
      textArray= new MyTextField[4];
      InitTextArray(textArray);
      setLayout(new BorderLayout());
      Panel pl= new Panel();
      pl.setLayout(new GridLayout(1,1,10,10));
      pl.add(new Label("A Mortgage Calculator", Label.LEFT));
      messageBox= new Label("Calculate Payments", Label.LEFT);
      pl.add(messageBox);
      this.add("North",pl);
      pl= new Panel();
      pl.setLayout(new GridLayout(4,1,10,10));
      pl.add(textArray[0]);
      pl.add(textArray[1]);
      pl.add(textArray[2]);
      pl.add(textArray[3]);
      this.add("Center",pl);
      pl= new Panel();
      pl.setLayout(new FlowLayout(FlowLayout.CENTER));
      buttonOK= new Button(" Calculate <Enter> ");     // spaces Mac workaround
      buttonQuit= new Button(" Quit ");
      pl.add(buttonOK);
      pl.add(buttonQuit);
      this.add("South",pl);
      
      pl= new Panel();
      pl.setLayout(new GridLayout(4,1,10,10));
      g= new CheckboxGroup();
      pl.add(checkPrinciple= new    Checkbox("Principle: .....................$", g, false));
      pl.add(checkInterest= new     Checkbox("Annual Interest (0-100): %",g,false));
      pl.add(checkMonths= new       Checkbox("Loan Period (Months): ",g,false));
      pl.add(checkPayment= new      Checkbox("Monthly Payments: .......$",g,true));
      this.add("West",pl);
      checkTarget= checkPayment;
      //(GetTextField(checkTarget)).setEditable(false); // disables tab and return Mac
      
      MenuBar mb= new MenuBar();
      Menu m= new Menu("File");
      m.add(new MenuItem("Quit"));
      mb.add(m);
      m= new Menu("Display");
      m.add(itemDisableFormat= new MenuItem("Turn Off Formatting"));
      m.add(itemEnableFormat= new MenuItem("Turn On Formatting"));
      itemEnableFormat.disable();
      mb.add(m);
      m= new Menu("Help");
      m.add(new MenuItem("About MCalc..."));
      mb.add(m);
      setMenuBar(mb);   
      this.resize(400,400);    
      this.pack();
      Point l= location();
      if ((l.x<30) || (l.y<30)) this.move(p.x,p.y);        
      Font f= buttonOK.getFont();
      f= new Font(f.getName(), Font.BOLD, f.getSize());
      buttonOK.setFont(f);
      buttonOK.setBackground(Color.white);
      this.setBackground(Color.lightGray);
      this.show();
      textArray[0].requestFocus();
   }
   
   static private void InitTextArray(MyTextField[] textArray)
   {
      textArray[0]= new MyTextField("",20, MyTextField.NUMERIC_ONLY);
      textArray[1]= new MyTextField("",20, MyTextField.NUMERIC_ONLY);
      textArray[2]= new MyTextField("",20, MyTextField.DIGITS_ONLY);
      textArray[3]= new MyTextField("0",20, MyTextField.NUMERIC_ONLY);
      
      // use class method SetTabFields _after_ adding instances
      MyTextField.SetTabFields(textArray);
   }
   
    // implement the DialogInterface
   
   public void ButtonOne(String label) // "OK"    
   {
      this.toFront();
      textArray[0].requestFocus();
      textArray[0].selectAll();
   } 
   public void ButtonTwo(String label)    {;}
   public void ButtonThree(String label)  {;}
   
   //==================================
   // * ParseString *
   //
   // Strips the input string of commas
   //
   // Use a StringBuffer to avoid multiple 
   // memory allocations
   //
   //==================================
   
   String ParseString(String inString)
   {
      StringBuffer   outString= new StringBuffer(inString.length());

      for (int i=0; i<inString.length(); i++)
      {
         if (inString.charAt(i) != ',')
            {outString.append(inString.charAt(i));}
      }
      return outString.toString();
   }
   
   //==============================
   //
   // * handleEvent *
   //
   // Each interactive panel should handle it's events.
   // Call super.handleEvent() to call this panels action() method
   //
   //==============================
   
   public boolean handleEvent(Event event) // MyFrame
   {  
      if (event.id == Event.WINDOW_DESTROY)
      {
         if (this.isShowing()) this.hide();
         this.dispose();
         if (isApplication) System.exit(0);
         return true;   
      }
      return super.handleEvent(event);  // calls action
   }

   //==============================
   //
   // * action *
   //
   // called by default handleEvent()
   // trap return key in TextField
   //
   //==============================
            
   public boolean action(Event evt, Object obj)  // MyFrame
   {
      char ch;
      String str;
      
      if (evt.target instanceof MenuItem)
      {
         str= (String)obj;
         ch= str.charAt(0);
         switch (ch)
         {
            case 'Q':         // Quit
               if (this.isShowing()) this.hide();
               this.dispose();
               if (isApplication) System.exit(0);
               return true;
            case 'A':
               DoAboutBox();  // About
               return true;
         } 
         if (evt.target == itemEnableFormat)
         {
            isFormat= true;
            if (itemEnableFormat.isEnabled()) itemEnableFormat.disable();
            if (! itemDisableFormat.isEnabled()) itemDisableFormat.enable();
            return true;
         }
         if (evt.target == itemDisableFormat)
         {
            isFormat= false;
            if (! itemEnableFormat.isEnabled()) itemEnableFormat.enable();
            if (itemDisableFormat.isEnabled()) itemDisableFormat.disable();
            return true;
         } 
      }
      
      if (evt.target instanceof Button)
      {
         if (evt.target == buttonOK) {DoCalc(); return true;}
         if (evt.target == buttonQuit) {DoQuit(); return true;}
      }
      
      if (evt.target instanceof MyTextField)  // return key down in TextField
      { 
            DoCalc();
            return true;
      }
      
      if (evt.target instanceof Checkbox)
      {  
         //GetTextField(checkTarget).setEditable(true);
         checkTarget= (Checkbox)evt.target;
         MyTextField temp= GetTextField(checkTarget);
         SetLabel(checkTarget);
         temp.setText("0");
         //temp.setEditable(false);
         temp.requestFocus();
         return true;
      }
          
      return super.action(evt, obj); 
   }
   
   private void DoQuit()
   {
      if (this.isShowing()) this.hide();
      this.dispose();
      if (isApplication) System.exit(0);
   }
   private void SetLabel(Checkbox checkTarget)
   {
      if (checkTarget== checkPrinciple) messageBox.setText("Calculate Principle");
      if (checkTarget== checkInterest) messageBox.setText("Calculate Interest");
      if (checkTarget== checkMonths) messageBox.setText("Calculate Months"); 
      if (checkTarget== checkPayment) messageBox.setText("Calculate Payment");
   }
   private MyTextField GetTextField(Checkbox checkTarget)
   {
      if (checkTarget== checkPrinciple) return textArray[0];
      if (checkTarget== checkInterest) return textArray[1];
      if (checkTarget== checkMonths) return textArray[2]; 
      if (checkTarget== checkPayment) return textArray[3];
      return textArray[3];
   }
   
   //==================================
   // * DoAlgo * CalcInt *
   //
   // The actual amortization algorithm:
   //
   // m= P*i/(1-(1+i)^-N)
   // i=r/1200
   //
   // solving for i is non_trivial
   // Thanks to Dr. W. Carlini (& Euclid) for this formula!
   //
   //==================================
   
   // Euclid's theorem to the rescue.
   
   String CalcInt(double P, double N, double m)
   {
      String outString;
      
      double temp=(m/P), answer=(m/P), diff=100, num=0, den=0, accuracy=.00001;
      int i, maxIterations= 1000;
      
      try
      {
         for (i=0; ((diff>accuracy) && (i<maxIterations)); i++)
         {
            temp= answer;
            num= (P*temp/m)+Math.pow((1+temp), -N)-1;
            den= (P/m)-N*Math.pow((1+temp),(-N-1));
            //if (den==0) throw new ArithmeticException(); // not needed
            answer= temp- (num/den);
            diff= answer- temp;
            if (diff<0) diff= -diff;
         }
         if ((answer < 0) || (Double.isNaN(answer)) || (i == maxIterations))
            {throw new ArithmeticException();}
         if (isFormat) outString= Format.ToCommaString((1200*answer));
         else outString= Double.toString((1200*answer)); // annual interest (0-100)
      }
      catch (ArithmeticException e) {outString= "Invalid Input";}
      return outString;
   }
   
   String DoAlgo(int field)
   {
      String   outString;
      double   db, temp= 0;
      double   P= dbArray[0];       // principle
      double   i= (dbArray[1]/1200);   // monthly percentage rate
      double   N= dbArray[2];          // loan period months
      double   m= dbArray[3];       // monthly payments
      
      outString= "Error";
      if (field<4)
      {
         try
         {  
            switch (field)
            {
               case 0: // Principle
                  db= 1+i;
                  db= 1/Math.pow(db, N);
                  db= ((1-db)/i)*m;
                  if (isFormat) outString= Format.ToCommaString(db);
                  else outString= Double.toString(db);
                  break;
               case 1:  // Annual Interest
                  outString= CalcInt(P, N, m);
                  break;
               case 2:  // Loan Period
                  db= (1-(P*i/m));
                  db= Math.log(db);
                  temp= 1+i;
                  db= -db/Math.log(temp);
                  if (isFormat) outString= Format.ToCommaString(db);
                  else outString= Double.toString(db);
                  break;
               case 3:  // Monthly Payments
                  db= 1+i;
                  db= 1/Math.pow(db, N);
                  db= (P*i)/(1-db);
                  if (isFormat) outString= Format.ToCommaString(db);
                  else outString= Double.toString(db);
                  break;
               default:;
               }
         }
         catch (ArithmeticException e) {;} // outString= "Error"
      }
      return outString; 
   }
   
   //==================================
   // * DoCalc *
   //
   // Check for valid input, update the
   // window fields and then DoAlgo()
   //
   //==================================
   
   void DoCalc()
   {
      String   strArray[], strResult= "", tempString="";
      Double   db;
      int      count= 0, field= 0;
      boolean  isError= false;
      
      strArray= new String[4];
      
      (GetTextField(checkTarget)).setText("0");
      for (int i=0; i<4; i++)
      {  
         strArray[i]= textArray[i].getText();      
         try
         {
            tempString= ParseString(strArray[i]);  // strip commas
            db= Double.valueOf(tempString);        // get Double, may throw exception
            if (isFormat)
            {
               tempString= Format.ToString(db.doubleValue());
               db= Double.valueOf(tempString);        // correct input for formatting
            }
            dbArray[i]= db.doubleValue();          // convert Double to double          
            if (dbArray[i]<0) throw new NumberFormatException();  // negative #
            
            switch (i)
            {
               case 0:  // Principle
               break;
               case 1:  // Annual Interest
                  if (dbArray[i]>100) 
                     {throw new NumberFormatException();} // over 100%
               break;
               case 2:  // Months
                  if ((int)dbArray[i] != dbArray[i])
                     {throw new NumberFormatException();}  // not an integer
               break;
               case 3:  // Monthly Payment
               break;
            }
            if (isFormat) textArray[i].setText(Format.ToCommaString(dbArray[i]));
            else textArray[i].setText(Double.toString(dbArray[i]));
         }
         catch (NumberFormatException e)
         {
            dbArray[i]= 0;
            isError= true;
            textArray[i].setText("Error");
         }
            
         if (dbArray[i]==0) 
         {
            count +=1;  //count zero entries
            field= i;   //last zero text field
         }
      }
      
      
      if (isError) 
      {
         DoDialogError("Invalid Entry");
         messageBox.setText("Invalid Entry");
      }
      else
      {
         if (count>1) 
         {
            DoDialogError("Too Many Zero Entries");
            messageBox.setText("Too Many Zero Entries");
         }
         else
         {
            if (count<1) 
            {
               DoDialogError("One Entry Must Be 0");
               messageBox.setText("One Entry Must Be 0");
            }
            else
            {
               strResult= DoAlgo(field);  // finally, do the math!
               textArray[field].setText(strResult);
               messageBox.setText("Done");
            }
         }
      }
   }
   
   //==========================
   //
   // * DoAboutBox * 
   //
   //==========================
   
   void DoAboutBox()
   {
      if (dl != null) 
            {
               if (dl.isShowing()) dl.hide();
               dl.dispose();
               dl= null;
            }
      dl= new MyDialog(this, "About Box","MCalc v2.00","jlouie 9.96"); 
   }
   
   //==========================
   //
   // * DoDialogError *
   //
   //==========================
   
   void DoDialogError(String inString)
   {
      messageBox.setText("Error");  // respond to user while dialog loads
      if (err != null) 
               {
                  if (err.isShowing()) err.hide();
                  err.dispose();
                  err= null;
               }
      err= new MyDialog(this,"Error Box","Input Error", inString);
   }
}
   
