//=====================================================================
//
// class * MyTextField * v1.03 9.96 jlouie
// this version does _not_ trap the return key
// text is not selected if the textfield is not editable
// we extend TextField to implement OO tab key behavior and KeyFilters
// this version supports automagic linking of tab text fields,
// custom Key Filters and public methods for nextField/prevField.
// public MyTextField(String str, int col) default NO_KEY_FILTER
// public MyTextField(String str, int col, int keyFilter) not a customKey
// if keyFilter= CUSTOM_KEY and customKey == null default is NO_KEY_FILTER
// public MyTextField(String str, int col, int keyFilter, String customKey)
// if keyFilter= CUSTOM_KEY and customKey= "", no input allowed.
//
//=====================================================================
 
package Widgets103;
import java.awt.*;

public class MyTextField extends TextField
{
   // protect the data
   private MyTextField nextField= this, prevField= this; 
   private int keyFilter;
   private String customKey= "";
   
   public static final int NO_KEY_FILTER=       0;        // keyFilter Constants
   public static final int NUMERIC_ONLY=        1;
   public static final int DIGITS_ONLY=         2;
   public static final int PHONE_ONLY=          3;
   public static final int SIGNED_NUMERIC_ONLY= 4;
   public static final int CUSTOM_KEY=          5;
   public static final int MIN_KEY=             0;
   public static final int MAX_KEY=             CUSTOM_KEY;
    
   // class method to set tab order
   public static void SetTabFields(MyTextField[] textArray)
   {
      // use short circuited logical OR
     if ((textArray == null) || (textArray.length<2)) return; // default is this!
     textArray[0].SetNextField(textArray[1]);
     textArray[0].SetPrevField(textArray[textArray.length-1]);
     textArray[textArray.length-1].SetNextField(textArray[0]);
     textArray[textArray.length-1].SetPrevField(textArray[textArray.length-2]);
     for (int i=1; i<(textArray.length-1); i++)
     {
         textArray[i].SetNextField(textArray[i+1]);
         textArray[i].SetPrevField(textArray[i-1]);
     }
   }
    
   // allow class method to set private data
   
   private void SetNextField(MyTextField field)
   {this.nextField= field;}
   
   private void SetPrevField(MyTextField field)
   {this.prevField= field;}
   
   // allow read only access to private data
   
   public MyTextField GetNextField()
   {return this.nextField;}
   
   public MyTextField GetPrevField()
   {return this.prevField;}
   
   //  overloaded constructor, default NO_KEY_FILTER
   
   public MyTextField(String str, int col)
   {
      this(str, col, NO_KEY_FILTER, null);  
   }


   public MyTextField(String str, int col, int keyFilter)
   {
      this(str, col, keyFilter, null);
   }
   
   public MyTextField(String str, int col, int keyFilter, String customKey)
   {
      super(str, col);           
      if (((keyFilter<MIN_KEY) || (keyFilter>MAX_KEY)) || 
         ((keyFilter == CUSTOM_KEY) && (customKey == null)))
      {
         this.keyFilter= NO_KEY_FILTER;
         this.customKey= "";
      }
      else
      {
         this.keyFilter= keyFilter;
         this.customKey= customKey;
      }
   }
   
   //================================
   //
   // * keyDown *
   //
   // override keyDown to trap tabs, return
   // & implement KeyFilters
   //
   //================================
   
   public boolean keyDown(Event evt, int key)
   {
      switch (key)
      {
         case '\b':        // backspace
         case '\n':        // ** fall through **
         case '\r':        // ** fall through **
            break;         // pass to super.keyDown()
         //case '\n':      // ** fall through **
         //case '\r':      // ** fall through **
         case '\t':                 
            //if ((evt.modifiers & Event.SHIFT_MASK) == Event.SHIFT_MASK)
            if (evt.shiftDown()) // traps shift and option-shift etc.
            {
               if (prevField != null)
               {
                  prevField.requestFocus();
                  if (prevField.isEditable()) prevField.selectAll(); 
                  return true;      
               }              
            }
            else
            {
               if (nextField != null) 
               {
                  nextField.requestFocus();
                  if (nextField.isEditable()) nextField.selectAll();
                  return true;      
               }
            }
            break;  // not handled, pass to super
         default: // not tab or backspace
            switch(keyFilter)
            {
               case DIGITS_ONLY:
                  if (! IsDigit(key)) return true;    // handle & ignore key input
                  break;                        // pass to super
               case NUMERIC_ONLY:
                  if (! IsNumeric(key)) return true;  // handle & ignore key input
                  break;
               case PHONE_ONLY:
                  if (! IsPhone(key)) return true;
                  break;
               case CUSTOM_KEY:
                  if (! IsCustom(key)) return true;
                  break;
               case SIGNED_NUMERIC_ONLY:
                  if (! IsSignedNumeric(key)) return true;
                  break;                              
               // NO_KEY_FILTER, pass to super
            } 
      }
      return super.keyDown(evt, key);
   }
   
   // custom
   public boolean IsCustom(int key)
   {
    if (customKey == null){return false;}
    for (int i=0; i<customKey.length(); i++)
    {
      if (key == (int)customKey.charAt(i))
      {return true;}
    }
    return false;
   }
   
   // {0 to 9}
   public boolean IsDigit(int key)
   {
      if (((key < '0') || (key >'9')) ) return false;
      else return true;
   }
  
   // {.,0 to 9}
   public boolean IsNumeric(int key)
   {  
      switch(key)
      {
         case '.':
         case ',':
            return true;
         default:
            return IsDigit(key);
      }
   }
   
   // {-.,0 to 9}
   public boolean IsSignedNumeric(int key)
   {  
      switch(key)
      {
         case '-':
            return true;
         default:
            return IsNumeric(key);
      }
   }
   
   // {- 0 to 9}
   public boolean IsPhone(int key)
   {
      switch(key)
      {
         case '-':
            return true;
         default:
            return IsDigit(key);
      }
   }
}
