/*
 * example.c:  copyright 1996 by Thomas Ball
 *
 * This file implements the native methods defined in NativeExample.java:
 *
 * NativeExample_quote():  given a valid index return a quotation,
 *	throws an IllegalArgumentException otherwise.
 *
 * NativeExample_twoTimes(): returns an int double the instance's value
 *	variable.
 *
 * NativeExample_doubleUp(): returns a new NativeExample instance with
 *	a value twice that of the instance whose method was invoked.
 *
 * Author:  Thomas Ball
 */

#include <native.h>
#include "NativeExample.h"
#include "java_lang_Integer.h"

static char *quotes[] = {
    "The truth is out there -- X-Files",
    "I suppose it will all make sense when we grow up -- Calvin & Hobbes",
    "Who died and made you king? -- my dad"
};

struct Hjava_lang_String *
NativeExample_quote(struct HNativeExample *unused, long index)
{
    char *quotation;

    if (index < 1 || index > 3) {
	/* SignalError marks the calling thread as having the
	 * specified exception, but then returns.
	 */
	SignalError(0, "java/lang/IllegalArgumentException", 0);
	return NULL;
    }

    quotation = quotes[index - 1];
    return makeJavaString(quotation, strlen(quotation));
}

long 
NativeExample_twoTimes(struct HNativeExample *hInst)
{
    /* This demonstrates accessing the private data of another object.
     * A safer alternative is to invoke one of its accessor methods,
     * since this rev-locks this library to that class's implementation. 
     */
    Hjava_lang_Integer *v = unhand(hInst)->myValue;
    return unhand(v)->value * 2;
}

struct HNativeExample *
NativeExample_doubleUp(struct HNativeExample *hInst)
{
    HNativeExample *hNewInst;
    long twoX;

    /* Create a NativeExample instance with the same value */
    hNewInst = (HNativeExample *)execute_java_constructor(
	0, "NativeExample", 0, "(I)", unhand(unhand(hInst)->myValue)->value);
    if (!hNewInst) {
	SignalError(0, "java/lang/NullPointerException", 0);
	return NULL;
    }

    /* Invoke its twoTimes() method -- yes, you can call the twoTimes()
     * native method above, but this is an example, remember? */
    twoX = (long)execute_java_dynamic_method(
	0, (HObject *)hNewInst, "twoTimes", "()I");

    unhand(unhand(hNewInst)->myValue)->value = twoX;
    return hNewInst;
}
