/**
 * NativeExample.java -- copyright 1996 by Thomas Ball
 *
 * This example app demonstrates loading a native library and native
 * method invocation.  See NativeMethods.html for details on building
 * the native library.
 *
 * @author	Thomas Ball
 */

public class NativeExample {

    private Integer myValue;

    // Load the example native library.  This static block only executes
    // one time -- when the class is first loaded.
    static {
	Runtime.getRuntime().loadLibrary("example");
    }

    NativeExample(int v) {
	myValue = new Integer(v);
    }

    public String toString() {
	return myValue.toString();
    }

    /**
     * Returns a quotation.
     *
     * @param index	the index of the quote to return, between 1 and 3.
     * @return the quote as a String object.
     */
    native static String quote(int index) throws IllegalArgumentException;

    /**
     * Returns double the object's value.
     *
     * @return	an Integer with the doubled value.
     */
    native int twoTimes();

    /**
     * Returns a new instance of NativeExample with its value twice as big.
     */
    native NativeExample doubleUp();

    public static void main(String[] args) {
	String s = quote(2);
	System.out.println("Testing quote(): \"" + s + "\"");

	NativeExample ne = new NativeExample(13);
	System.out.println("Testing twoTimes() " + ne.twoTimes() + 
			   " (should be 26)");

	ne = new NativeExample(24);
	NativeExample ne2 = ne.doubleUp();
	System.out.println("Testing doubleUp() " + ne2 + " (should be 48)");
    }
}
