//=================================================================
//
// file SQLClient.java v1.0
// a Socket Server (SQLServer.java) applet client
// supplied as is, free for non-commercial use.
// synchronization is pre-beta.
// jlouie 10.96
// name this file SQLClient.java and compile with Javac eg.
// c:\java\bin>javac -d c:/MyWebServer/HTML .\src\SQLClient.java
// where the source code is in c:\java\bin\src
// and the code compiles to c:\MyWebServer\HTML
// note the use of the Unix / and DOS \ with javac!
// warning: select browser option/network/every time/apply when debugging
// with Netscape over a network!
// this applet compiles with Sun's JDK 1.02 Win95
// tested with Netscape 2.0 Win95/WinNT 4.0 over Ethernet
// does not work with Netscape 3.0b4 Mac  (Socket class)
// this applet creates a client socket that spawns 
// two threads, a socket listener and writer.
// call this class from a HTML file 
// WARNING Netscape may preferentially load any local class files on the client
// with the same name!
// Log On as User: Guest Password: Open Sesame
//
//=================================================================


import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;
import Widgets105.*;

public class SQLClient extends Applet implements LogOnInterface
{  
   public Socket so;
   private Label l= new Label("Trying to Connect.");
    
   public void init()
   {
      try
      { 
         setLayout(new FlowLayout());
         add(l);
         show();
         so= new Socket(this.getDocumentBase().getHost(), SQLServer.DEFAULT_PORT);
      }
      catch(Exception e)
      {
         l.setText("SQL Connect Error: "+ e.toString());
         return;
      }
      l.setText("Successful Socket Connection.");
      new LogOn(this,"Log On: SQL Client v1.0");
   }
   
   // define the interface methods
   
   public void DoLogOn(String logOn)      
   {new MyFrame("SQL Client", so, logOn);}
   
   public void DoDestroy()
   {
      if (so!=null){try{so.close();} catch(Exception ignored){;}}
      l.setText("Invalid User Name/Password.");
   }
}

class MyFrame extends Frame
{
   Socket so;
   DataInputStream in;
   PrintStream out;
   TextField tf;
   TextArea ta;
   private boolean isDirty= false;
   private StreamReader sr;
   private StreamWriter sw;
   private Point p;
   private static char MY_CHAR= '\ue487';
   private char mask8=(char)(MY_CHAR & '\u00FF');  // clear top 8 bit
   private String logOn=" ";

   public MyFrame(String title, Socket so, String logOn)
   {
      super(title);
      this.so= so;
      this.logOn= logOn;
      tf= new TextField();
      ta= new TextArea("Trying to connect to host.");
      setLayout(new BorderLayout());
      add("North", tf);
      add("Center", ta);
      resize(300,300);
      p= location();
      if ((p.x<30)||(p.y<30)) move(30,30);
      show(); 
      tf.requestFocus();
      
      try
      { 
         in= new DataInputStream(new BufferedInputStream(so.getInputStream()));
         out= new PrintStream(new BufferedOutputStream(so.getOutputStream()));
  
         sr= new StreamReader(in, ta);
         sw= new StreamWriter(this,out, tf);
        
         int myPriority= sw.getPriority();
         if (myPriority < Thread.MAX_PRIORITY) sr.setPriority(myPriority+1);
         else sw.setPriority(myPriority-1);
      }
      catch(IOException e) {ta.setText("Unable to connect to host.");}
      catch(SecurityException e) 
      {ta.setText("Security Exception.");}
      catch(IllegalArgumentException e) 
      {ta.setText("Bad Priority Parameter.");}
      catch(Exception e)
      {ta.setText("Unknow Exception.");}  
   }
   
   public boolean handleEvent(Event event)
   {
      if (event.id == Event.WINDOW_DESTROY)
      {
         if ((sw != null)&&(sw.isAlive())) sw.stop();
         if (out != null)
         {
            out.println(Encrypt(SQLServer.BREAK));
            out.flush();
         }
         if ((sr != null)&&(sr.isAlive())) sr.stop();
         if (this.isShowing()) this.hide();
         this.dispose();
         if (in != null) try{in.close();} catch(Exception ignored) {;}
         if (out != null) try{out.close();} catch(Exception ignored) {;}
         if (so != null) try{so.close();} catch(Exception ignored) {;}
         return true;
      }
      return super.handleEvent(event);
   }
   
   public boolean action(Event evt, Object obj)
   {
      if (evt.target == this.tf)
      {
         synchronized(sr.data)   // clear textarea
         {
            sr.data= "";
            sr.ta.setText("");
         }
         //sw.resume();      // wake up the writer thread
         SetDirty(true);     // flag writer thread
         return true;
      }
      return super.action(evt, obj);
   }
   
   public void SetDirty(boolean inBoolean)
   {isDirty= inBoolean;}
   
   public boolean GetDirty()
   {return isDirty;}
   
   public String GetLogOn()
   {return logOn;}
   
   private String Encrypt(String inString)
   {
      StringBuffer outString= new StringBuffer(inString.length());
      char temp;
      
      for (int i=0; i<inString.length(); i++)
      {
         temp= inString.charAt(i);
         if (temp>'\u00FC') temp -= '\u00FC';   
         else temp += '\u0003';                 
         temp ^= mask8;                 
         outString.append((char)temp); 
      }
      return outString.toString();
   }
}

class StreamReader extends Thread
{
   DataInputStream in;
   TextArea ta;
   public String data= "";
   private static char MY_CHAR= '\ue487';
   private char mask8=(char)(MY_CHAR & '\u00FF');  // clear top 8 bits
   
   public StreamReader(DataInputStream in, TextArea ta)
   {
      if ((in == null)||(ta==null))
      {
            System.out.println("Null Parameter in StreamReader.");
            return;
      }
      this.in= in;
      this.ta= ta;
      this.start();
   }
   
   public void run()
   {
      String line;
      
      ta.setText("");
      try
      {
         while((line= in.readLine()) != null)
         {
            line= Decrypt(line);
            line += "\n";
            ta.appendText(line);
         }
      }
      catch(IOException e) {ta.setText(e.toString());}
      finally {ta.setText("Connection Closed or Server Busy.");}
   }
   
   private String Decrypt(String inString)
   {
      StringBuffer outString= new StringBuffer(inString.length());
      char temp;
      
      for (int i=0; i<inString.length(); i++)
      {
         temp= inString.charAt(i);         
         temp ^= mask8;
         if (temp<'\u0003') temp += '\u00FC';
         else temp -= '\u0003';                    
         outString.append(temp); 
      }
      return outString.toString();
   }
}

class StreamWriter extends Thread
{
   private static char MY_CHAR= '\ue487';
   char mask8=(char)(MY_CHAR & '\u00FF');

   TextField tf;
   PrintStream out;
   MyFrame mf;
   
   public StreamWriter(MyFrame mf, PrintStream out, TextField tf)
   {
       if ((mf == null)||(tf == null))
      {
            System.out.println("Null Parameter in StreamWriter.");
            return;
      }
      this.mf= mf;
      this.tf= tf;
      this.out= out;
      this.start();
   }
   
   public void run()
   {
      out.println(DoEncrypt(mf.GetLogOn()));
      out.flush();
      while(true)
      {
         //suspend();                                       // wait for textfield input
         this.yield();                                      
         while(mf.GetDirty())                               // wait for flag
         {
            synchronized(tf)
            {
                  out.println(DoEncrypt(tf.getText()));     // encrypt query
                  out.flush();
                  tf.setText("");
                  mf.SetDirty(false);
            }
         }
      }
   }
   
   private String DoEncrypt(String inQuery)
   { 
      String err= "Invalid Query.";
          
      if ((inQuery == null) || (inQuery.length()<1)) return (Encrypt(err));           
      else return (Encrypt(inQuery));
   }
   
   private String Encrypt(String inString)
   {
      StringBuffer outString= new StringBuffer(inString.length());
      char temp;
      
      for (int i=0; i<inString.length(); i++)
      {
         temp= inString.charAt(i);
         if (temp>'\u00FC') temp -= '\u00FC';   
         else temp += '\u0003';                 
         temp ^= mask8;                 
         outString.append((char)temp); 
      }
      return outString.toString();
   }
   
}

class LogOn extends Frame
{
   TabTextField[] arrayFields= new TabTextField[2];
   TabButton[] arrayButtons= new TabButton[2];
   String logOn= " ";
   LogOnInterface loi;
   
   LogOn(Object obj, String title)
   {
       super(title);
       this.loi= (LogOnInterface)obj;
       this.setLayout(new GridLayout(3,1,10,10));     // workaround for scrunch
       Panel pl= new Panel();
       pl.setLayout(new FlowLayout(FlowLayout.CENTER));
       pl.add(new Label("Enter User Name and Password.", Label.CENTER));
       this.add(pl);
       pl= new Panel();
       pl.setLayout(new BorderLayout());
       Panel sp= new Panel();
       sp.setLayout(new GridLayout(2,1));
       sp.add(new Label("User Name:", Label.LEFT));
       sp.add(new Label("Password:", Label.LEFT));
       pl.add("West",sp);
       sp= new Panel();
       sp.setLayout(new GridLayout(2,1));
       arrayFields[0]= new TabTextField(SQLServer.DEFAULT_USER,20);
       arrayFields[1]= new TabTextField(SQLServer.DEFAULT_PASSWORD,20);
       sp.add(arrayFields[0]);
       sp.add(arrayFields[1]);
       pl.add("East",sp);
       this.add(pl);
       pl=new Panel();
       pl.setLayout(new FlowLayout());
       arrayButtons[0]= new TabButton("OK <Enter>");
       arrayButtons[1]= new TabButton("Quit");
       pl.add(arrayButtons[0]);
       pl.add(arrayButtons[1]);
       this.add(pl);
       
       TabInterface[] ti= new TabInterface[arrayFields.length+arrayButtons.length];
       for (int i=0; i<arrayFields.length; i++)
       {ti[i]= (TabInterface)arrayFields[i];}
       for (int i=arrayFields.length; i<ti.length; i++)
       {ti[i]= (TabInterface)arrayButtons[i-arrayFields.length];}
       TabMethods.SetTabComponents(ti);
       
       this.resize(400,400);
       this.pack();
       this.setResizable(false);
       Point p= location();
       if ((p.x<30)||(p.y<30)) this.move(30,30);
       arrayFields[1].setEchoCharacter('*');
       this.show();
       arrayFields[0].requestFocus();
       arrayFields[0].selectAll();
   }
   
   public boolean handleEvent(Event event)
   {
      if (event.id == Event.WINDOW_DESTROY)
      {
         this.hide();
         this.dispose();
         loi.DoDestroy();  
         return true;
      }
      return super.handleEvent(event);
   }
   
   public boolean keyDown(Event event, int key)
   { 
      switch(key)
      {
         case '\n':
         case '\r':
            if (event.target instanceof TabButton)
            {
               if ((TabButton)event.target == arrayButtons[0])  {DoOK();return true;}
               if ((TabButton)event.target == arrayButtons[1])  {DoCancel();return true;}
            } 
         default:
             return super.keyDown(event, key);
      }  
   }
   
   public boolean action(Event event, Object obj)
   {
      if (event.target == arrayButtons[0])
      {
         DoOK();
         return true;
      }
      if (event.target == arrayButtons[1])
      {
         DoCancel();
         return true;
      }
      if (event.target instanceof TextField)   // trap return in textfield
      {
         DoOK();
         return true;
      }
      return super.action(event, obj);
   }
   
   private void DoOK()
   {
        logOn= arrayFields[0].getText()+"\t"+arrayFields[1].getText()+"\t";                    
        if (logOn.length()<3) logOn= SQLServer.DEFAULT_USER+"\t"+
                        SQLServer.DEFAULT_PASSWORD+"\t"; 
        loi.DoLogOn(logOn);
        if (this.isShowing()) this.hide();
        this.dispose();
   }
   
   private void DoCancel()
   {
         if (this.isShowing()) this.hide();
         this.dispose();
         loi.DoDestroy();
   }
}


