//=====================================================================
//
// file SQLServer.java v1.0
// see file SQLClient.java
// supplied as is, free for non-commercial use.
// synchronization is pre-beta
// jlouie 10.96
// this application implements a three tiered database access structure.
// the back end currently is a ODBC MS Access database
// SQLServer is the middleware java socket server
// SQLClient is the distributed java applet front end that executes on the client
// this code implements a trivial & lightweight XOR and ROT3 encryption.
// name this file SQLServer.java and compile with javac
// c:\java\bin>javac -d . .\src\GUIServer.java
// where the source code is in c:\java\bin\src
// and the code is compiled to c:\java\bin
// and then run it from the DOS prompt
// c:\java\bin>java GUIServer [MyDatabase] [PortNumber]
// this code was tested with Sun's JDK 1.02 for WinNT,
// Netscape 2.01 Win95/NT 4.0 over an Ethernet HP NetServer LC network
// this code does _not_ work properly with Sun's JDK 1.02 for Mac or
// earlier versions of the Win95 JDK or Netscape 3.0b4 Mac
// This application does not quit under WinNT, kill the server & then press
// ctrl-c from the dos prompt. 
// This code does not compile with J++ v1.0.
// Load the client SQL.htm file with Netscape
// or serve the client applet on a web server and log on with Netscape
//
// Ref: "Teach Yourself Java in 21 Days", Lemay & Perkins, Sams Net
// Ref: "Java in a Nutshell", David Flanagan, O'Reilly & Associates
// Ref: "Core Java", Cornell & Horstmann, Sunsoft Press
// Ref: "The Java Programming Language" Arnold & Gosling Addison Wesley
// General Ref: "Code Complete" Steve McConnell, Microsoft Press
// OOP Ref: "Object-Oriented Analysis and Design" Grady Booch, Addison Wesley
// Encryption Ref: "Applied Cryptography" Bruce Schneier, Wiley
//=====================================================================

import java.io.*;
import java.net.*;
import java.awt.*;
import Widgets105.*;
import java.sql.*;                              
import java.util.*;

public class SQLServer extends Thread
{
   // class constants
   
   public final static int    MAX_CLIENTS=   2;    // max number of connections, set to 10
   public final static int    DEFAULT_PORT=  8189;
   public final static int    MIN_PORT=      1024;
   public final static int    MAX_PORT=      32767;// what _is_ the max value?
   public final static int    MAX_QUEUE=     10;   // max queue for incoming, set to 50
   public final static String DEFAULT_QUERY=       "ID";
   public final static String DEFAULT_DATATABLE=   "CustomerID";
   public final static String DEFAULT_DATABASE=    "AccessTest";
   public final static String BREAK=               "exit";
   public final static String DEFAULT_USER=        "Guest";
   public final static String DEFAULT_PASSWORD=    "Open Sesame";
   
   public String        inDatabase=       DEFAULT_DATABASE;
   public Connection    c=                null;
   public Statement     s=                null;
   private int          port=             DEFAULT_PORT;
   private ServerSocket ss;
   private int          gac;                        // active connections, untrusted   
   private ThreadedDataHandler[] arrayClients= 
                     new ThreadedDataHandler[SQLServer.MAX_CLIENTS];
   private ThreadedDataHandler threadHandler;
   private Socket       so; 
   private PrintStream  out;
   
   public static void main(String[] input)
   {
      String inDatabase= DEFAULT_DATABASE;
      int port= DEFAULT_PORT;
      if (input.length >0 ) inDatabase= input[0];   // parse input, get database name
      if (input.length >1)                          // get port number
      {
          try {port= Integer.parseInt(input[1]);}   
          catch (NumberFormatException e) 
          {
            System.out.println("Invalid Input.");
            port= DEFAULT_PORT;
          }
      }
      new SQLServer(port, inDatabase).start();
   }
   
   public SQLServer(int port, String inDatabase)
   {  
      if ((inDatabase==null)||(inDatabase.length()<1)) inDatabase= DEFAULT_DATABASE;
      this.inDatabase= inDatabase; 
      if ((port < MIN_PORT ) || (port > MAX_PORT)) 
      {
         System.out.println("Illegal Port.");
         port= DEFAULT_PORT;
      }
      this.port= port;                                            
      try                                             
      {
         new jdbc.odbc.JdbcOdbcDriver();                    // load ODBC driver
         String connectionString= "jdbc:odbc:"+inDatabase;
         c= DriverManager.getConnection(connectionString);  // create db connection
         SQLWarning w= c.getWarnings();
         if (w!=null) System.out.println("Connection generated warnings!");
         s= c.createStatement();                            // create statement
         System.out.println("Successful connection to ODBC database: "+inDatabase+".");
      }
      catch(Exception e)
      {
         if (s != null) try {s.close();} catch(Exception ignored) {;}
         if (c != null) try {c.close();} catch(Exception ignored) {;}
         System.out.println(e);
         System.exit(1);
      }
   
      try
      {
         ss= new ServerSocket(port, MAX_QUEUE);              // create socket server
         new ControlPanel(this, ss);                         // create GUI interface
         System.out.println("SQL Server is up and Running on Port "+port);
         InetAddress hostIP= InetAddress.getLocalHost();
         System.out.println("Hosted on Machine " + hostIP.toString());
      }
      catch(Exception e)
      {
         System.out.println(e);
         System.exit(1);
      }
   }
   
   public void run() // thread here
   {
      int ac,dead;
      String temp="";
      
      while(true)
      {
        try
        {
                ControlPanel.SetMessage(temp + " Waiting.");
                so= null;
                so= ss.accept();
                temp= "Connection accepted.";
                synchronized(arrayClients)
                {
                        ac= 0;      // no active clients    
                        dead= -1;   // no dead clients
                        // use short circuit logical OR
                        for (int i =0; i<MAX_CLIENTS; i++)
                        {
                            if((arrayClients[i] == null)||(!arrayClients[i].isAlive()))
                            { 
                              dead= i;
                            }
                            else ac++;                           
                        }
                        if (dead != -1) // we got a dead one
                        {   
                            arrayClients[dead]= new ThreadedDataHandler(this,so);
                            arrayClients[dead].start();
                            ac++;
                        }
                        else 
                        {
                            temp= "Connections full.";
                            if (so != null)
                            {
                                   try{so.close();}
                                   catch(Exception ignored) {;}
                            }                
                        }
                        ControlPanel.SetAC(ac);
                        gac= ac;
                }
         }
         catch(Exception e) 
         {
                ControlPanel.SetMessage(e.toString());       
         } 
      }      
   }
   
   // access methods
   
   public int GetPort() 
   {return port;}
   
   public ServerSocket GetServerSocket()  
   {return ss;}
   
   public int GetGAC()  // global, active connections
   {return gac;}
   
   public void NotifyDeath()
   {if (gac > 0) gac--;}
   
   public void DisconnectAll()
   {
      // use short circuit logical AND
      synchronized(arrayClients)
      {
         for (int i =0; i<SQLServer.MAX_CLIENTS; i++)
         {
            if((arrayClients[i] != null)
              && (arrayClients[i].isAlive())) 
            {arrayClients[i].Close();}
         }
      }
      gac= 0;
   }
}

class ThreadedDataHandler extends Thread
{
   private Socket so;
   private String str="";
   private DataInputStream in;
   private PrintStream out;
   private SQLServer server;
   private static char MY_CHAR= '\ue487';
   private static char mask8=(char)(MY_CHAR & '\u00FF');   // clear top 8 bits
   private String userName;
   
   ThreadedDataHandler(SQLServer server, Socket so)
   {
      if ((so == null) || (server == null))
      {
         this.stop();
         return;
      }
      this.so= so;
      this.server= server;
   }
   
   public void run() // thread here
   {
      int ac;
      java.util.Date date;
      
      try
      {
         in= new DataInputStream(so.getInputStream());
         out= new PrintStream(so.getOutputStream());
         str= Decrypt(in.readLine());
         if (! VerifyLogOn(str)) throw new Exception("Invalid User/Password.\r");
         if (userName != null)
         {
            date= new java.util.Date();
            System.out.println("User: "+ userName +" Logged On at: " +date.toLocaleString()); 
         }
         str= Encrypt("Connected to SQLServer:Database: "+server.inDatabase+".\n"+
                        "Enter "+ SQLServer.BREAK + " to disconnect.\r");
         out.println(str);
         while((str= in.readLine()) != null)
         {
            str= str.trim();
            str= Decrypt(str);
            if (str.equals(SQLServer.BREAK)) break;
            if (str.length()>0) str= DoSql(str);
            else str= "Input Error. Enter "+SQLServer.BREAK+" to disconnect.";
            str= Encrypt(str); 
            out.println(str);
         }
      }
      catch(Exception e) 
      {
         if (userName != null)
         {
            date= new java.util.Date();
            System.out.println("User: "+ userName +" REJECTED at: " +date.toLocaleString()); 
         }
         out.println(Encrypt(e.toString()));
      }
      finally
      {
         if (userName != null)
         {
            date= new java.util.Date();
            System.out.println("User: "+ userName +
                  " Disconnected  at: " +date.toLocaleString()); 
         }
         if (so != null) 
         {
            server.NotifyDeath();
            this.Close();
         }
         ControlPanel.SetAC(server.GetGAC());
         ControlPanel.SetMessage("Closed Connection.");
      }   
   }
   
   // return true if valid logOn
   private boolean VerifyLogOn(String logOn)
   {
     String userPassword=     "?";
     
     if ((logOn == null) || (logOn.length()<1)) return false;
     StringTokenizer t= new StringTokenizer(logOn,"\t");
     if ((t == null)||(t.countTokens()<2)) return false;    // need two tokens
     userName=" ";
     if (t.hasMoreTokens()) userName= t.nextToken();
     if (t.hasMoreTokens()) userPassword= t.nextToken();
     if ((userName.equals(SQLServer.DEFAULT_USER))&&
            (userPassword.equals(SQLServer.DEFAULT_PASSWORD)))
     {return true;}
     else return false;
   }
   
   private String Encrypt(String inString)
   {
      StringBuffer outString= new StringBuffer(inString.length());
      char temp;
      
      for (int i=0; i<inString.length(); i++)
      {
         temp= inString.charAt(i);
         if (temp>'\u00FC') temp -= '\u00FC';   // \-00FF + 0003
         else temp += '\u0003';                 // A little Ceasar Cipher! ROT3
         temp ^= mask8;                         // XOR
         outString.append(temp); 
      }
      return outString.toString();
   }
   
   private String Decrypt(String inString)
   {
      StringBuffer outString= new StringBuffer(inString.length());
      char temp;
      
      if (inString == null) return "?";
      for (int i=0; i<inString.length(); i++)
      {
         temp= inString.charAt(i);
         temp ^= mask8;            // XOR
         if (temp<'\u0003') temp += '\u00FC';
         else temp -= '\u0003';    // A little Ceasar cipher!            
         outString.append(temp); 
      }
      return outString.toString();
   }
   
   private String DoSql(String inString)
   {
      ResultSet rs= null;
      ResultSetMetaData rsmd= null;
      String outString= "";
      
      if ((inString == null) || (inString.length()==0)) return "Invalid SQL Query.\n";
      try
      {  
         synchronized(server.s)                              // lock statement
         {
            rs= server.s.executeQuery(inString);
         }    
         outString="SQL Query < "+ inString + " >\nIn Database <"+
                  server.inDatabase+ "> Returned:\n\n";
         rsmd= rs.getMetaData();
         while(rs.next())                                   
         {
            for (int i=1; i<=rsmd.getColumnCount(); i++)    // columns indexed from one!
            {outString += rs.getString(i)+ " ";}
            outString += "\n";
         }  
      }
      catch(Exception e){outString= String.valueOf(e)+ "\n";}
      finally
      {
         if (rs != null) try {rs.close();} catch(Exception ignored) {;}
         return (outString +"\nEnter "+ SQLServer.BREAK + " to disconnect.\r");
      } 
   }   
   
   public void Close()
   {
         if (in != null)
         {
            try {in.close(); in= null;}
            catch(Exception ignored) {;}
         }
         if (out != null)
         { 
            try {out.close(); out= null;}
            catch(Exception ignored) {;}
         }
         if (so != null)
         { 
            try {so.close(); so= null;}
            catch(Exception ignored) {;}
         }      
   }
}

class ControlPanel extends Frame  implements DialogInterface
{
   private InetAddress hostIP;
   private String strPort;
   private ServerSocket ss;
   private static TextField mess, ac;
   private MyDialog md;
   private Point l;
   private SQLServer server;
   
   TabButton[] arrayButtons= new TabButton[2];
    
   ControlPanel(SQLServer server, ServerSocket ss)
   {
     super("SQL Server v1.0 <jlouie 10.96>");
     if ((server == null) || (ss == null))
     {
         System.out.println("Parameter error in Control Panel.");
         KillServer();
         return;
     }
     this.ss= ss;
     this.server= server;
     try 
     {
         hostIP= InetAddress.getLocalHost();
         strPort= hostIP.toString();
     }
     catch (Exception e) {strPort="Not Available";}
     
     setLayout(new BorderLayout(10,10));
     Panel p= new Panel();
     p.setLayout(new GridLayout(5,1));
     p.add(new Label("SocketServer on Port:", Label.LEFT));
     p.add(new Label("Hosted on Machine:", Label.LEFT));
     p.add(new Label("Connected to Database: ", Label.LEFT));
     p.add(new Label("Active Connections:", Label.LEFT));
     p.add(new Label("Message:", Label.LEFT));
     this.add("West",p);
     p= new Panel();
     p.setLayout(new GridLayout(5,1));
     p.add(new Label(Integer.toString(server.GetPort()), Label.LEFT));
     p.add(new Label(strPort, Label.LEFT));
     p.add(new Label(server.inDatabase, Label.LEFT));
     p.add(ac= new TextField("0 out of "+SQLServer.MAX_CLIENTS,25));
     ac.setEditable(false);
     p.add(mess= new TextField("25"));
     mess.setEditable(false);
     this.add("Center",p);
     TabInterface[] ti= new TabInterface[2];
     p= new Panel();
     p.setLayout(new GridLayout(1,2));
     p.add(arrayButtons[0]= new TabButton("Kill Server"));
     p.add(arrayButtons[1]= new TabButton("Disconnect All Clients"));
     this.add("South",p);
     for (int i=0; i<arrayButtons.length; i++)
     {ti[i]= (TabInterface)arrayButtons[i];}
     TabMethods.SetTabComponents(ti);
     l= location();
     if ((l.x<30)||(l.y<30)) this.move(30,30);
     this.resize(600,600);
     this.pack();
     arrayButtons[0].requestFocus();
     this.show();
   }
   
   public boolean handleEvent(Event event)
   {
      if (event.id == Event.WINDOW_DESTROY)
      {
         TryToQuit();
         return true;
      }
      return super.handleEvent(event);
   }
   
   
   public boolean action(Event evt, Object obj)
   {
      char ch;
      String str;
      
      if (evt.target instanceof TabButton)
      {
         str=(String)obj;
         ch= str.charAt(0);
         switch(ch)
         {
            case 'K':   // Kill Server
               TryToQuit();
               return true;
            case 'D':   // Disconnect All Users
               TryToDisconnectAll();
               return true;
         }
      }
      return super.action(evt,obj);
   }
   
   public boolean keyDown(Event event, int key)
   {
      switch(key)
      {
         case '\n':
         case '\r':
            if (event.target instanceof TabButton)
            {
               if ((TabButton)event.target == arrayButtons[0]) 
               {
                  TryToQuit();
                  return true;
               }
               if ((TabButton)event.target == arrayButtons[1]) 
               {
                  TryToDisconnectAll();
                  return true;
               }
            }
      }
      return super.keyDown(event, key);
   }
   
   public static void SetMessage(String inString)
   {ControlPanel.mess.setText(inString);}
   
   public static void SetAC(int ac)
   {ControlPanel.ac.setText(ac+" of "+SQLServer.MAX_CLIENTS);}
   
   private void TryToQuit()
   {
      if (md != null)
      {
         if (md.isShowing()) md.hide();
         md.dispose();
         md= null;
      }
      md= new MyDialog(this,"Confirm","Really?","Kill the Server?",MyDialog.BUTTON_TWO,
                        "OK","Cancel"); 
   }
   
   private void TryToDisconnectAll()
   {
      if (md != null)
      {
         if (md.isShowing()) md.hide();
         md.dispose();
         md= null;
      }
      md= new MyDialog(this,"Confirm","Really?","Disconnect All Users?",MyDialog.BUTTON_TWO,
                        " OK ","Cancel"); 
   }
   
   private void KillServer()
   {
      DisconnectAll();
      if (this.isShowing()) this.hide();
      this.dispose();
      if (server.s != null) try {server.s.close();} catch(Exception ignored) {;}
      if (server.c != null) try {server.c.close();} catch(Exception ignored) {;}
      System.exit(0);
   }
   
   private void DisconnectAll()
   {
      server.DisconnectAll();
      SetAC(server.GetGAC());
   }
   
   // implement DialogInterface
   public void ButtonOne(String label) 
   {
      if (label == "OK")   {KillServer();}      // Kill Server
      if (label == " OK ") {DisconnectAll();}   // Disconnect All Clients
      this.toFront();
   }
   public void ButtonTwo(String label)          // Cancel
   {
      this.toFront();
      arrayButtons[0].requestFocus();
   }  
   public void ButtonThree(String label) {;}
   public void DoDestroy(String title) {this.toFront();}
   
}



