package Widgets105;

// file Format.java
// jlouie Part of MyWidgets 1.05
// 9.96
// formats comma delimited output

public class Format
{
   public static Double db;
   public final static double MIN_DOUBLE= 1e-3;
   
   public static void main(String[] input)         // module test
   {
      if (input.length>0)
      {
         try{db= Double.valueOf(input[0]);}
         catch(Exception e){System.exit(1);}
         System.out.println(input[0]+" Input");
         System.out.println(ToString(db.doubleValue())+" double");
         System.out.println(ToCommaString(db.doubleValue())+" doubleComma");
         System.out.println(ToString(db)+" Double");
         System.out.println(ToCommaString(db)+" DoubleComma");
      }
      else System.exit(1);
   }
   
   public static String ToString(Double db)        // Double to String
   {
      if (db.isNaN()) return "NaN";
      else return Convert(db.doubleValue(),false);
   }
   
   public static String ToString(double d)         // double to String
   {return Convert(d,false);}
   
   public static String ToCommaString(Double db)   // Double to comma delimited String
   {
      if (db.isNaN()) return "NaN";
      else return Convert(db.doubleValue(),true);
   }
   public static String ToCommaString(double d)    // double to comma delimited String
   {return Convert(d,true);}
   
   private static String Convert(double d, boolean isComma)
   {
      String out="Error";
      int offset=0,start=0, count=0;
      StringBuffer buf= new StringBuffer();
      boolean isNeg= false;
     
      if (Double.isNaN(d)) return "NaN";
      if (d==0) return "0";                        // 0 input will loop forever
      if (d<0)
      {
         isNeg= true;
         d= -d;
      }
      out= Double.toString(d);
      if (isComma)
      {
         if (d>=1000) isComma= true;
         else isComma=false;
      }
      if (d<=MIN_DOUBLE)                           // needs formating
      {
         while(d<=MIN_DOUBLE)
         {
            d *= 10;
            offset += 1;                           
         }                                         
         out= Double.toString(d);                  // formated string
         buf.append("0.");                         // reconstruct number
         for (int i=0; i<offset; i++) buf.append("0");  // pad zeros
         //for (int i=2; i<out.length(); i++) buf.append(out.charAt(i));
         buf.append(out.substring(2));              // add formated string
         out= buf.toString();
      }
      
      // algorithm is complicated by Double.toString rounding up
      
      if (d>=999999.5)                             // needs formating
      {
         while(d>1e+6)
         {
            d /= 10;
            offset += 1;
         }
         if (d>=999999.5)                          // will round up to 1e+6!
         {
            d= 1e+5;                               // round up, workaround
            offset +=1;
         }
         out= Double.toString(d);                  // formated string no decimals
         buf.append(out);                          // six sig figs
         for (int i=0; i<offset; i++) buf.append("0"); // pad zeros
         out=  buf.toString();
      }
      if (isComma)                                 // add commas
      {
         buf= new StringBuffer();
         for (int i=out.length()-1; i>=0; i--)     // find decimal point
         {
            if (out.charAt(i)=='.')
            { 
               offset = i;                         // index of '.'
               break;
            }
            offset= out.length();                  // no '.' so return lastIndex+1
         }
         offset -= 1;                              // index of ones digit
         start= (offset)-(((offset)/3)*3);         // index of first comma 0,1 or 2
         buf.append(out.substring(0,start+1) +",");// insert first comma at start+1!
         for (int i= start+1; i<out.length(); i++) // insert remaining commas
         {
            count += 1;
            buf.append(out.charAt(i));
            if (count==3)
            {
               count= 0;                           // reset counter
               if (i< offset) buf.append(",");     // insert unless index of ones
            }
         }
         out= buf.toString();
      }
      if (isNeg) return ("-"+out);
      else return out;  
   }
}
