// file MyDialog.java
// v1.05
// jlouie 9.96
// Dialog Box Class 
// This version implements TabButton allowing tabbing between buttons!
// This version supports interface instance method DoDestroy(String title)
// Allows the calling class to respond to WINDOW_DESTROY
// Allows one to construct a one, two or three button Dialog Box
// Supports a default button and customization of button labels
// default is titled "Dialog Box" one button "OK" BUTTON_ONE default
// Implements DialogInterface
// di.ButtonOne(String label);
// di.ButtonTwo((String label);
// di.ButtonThree((String label);
// di.DoDestroy(String title);
// overloaded constructors
// MyDialog(f) owner, a frame
// MyDialog(f,title) title of Dialog Box, default "Dialog Box"
// MyDialog(f,title,mess1) line one of message, default "Confirm"
// MyDialog(f,title,mess1,mess2) line two of message, default "?"
// MyDialog(f,title,mess1,mess2,defaultButton) int 0 to 3, 0= NO_DEFAULT
// MyDialog(f,title,mess1,mess2,defaultButton,str1) button one only, default "OK"
// MyDialog(f,title,mess1,mess2,defaultButton,str1,str2) two buttons <str1> <str2>
// MyDialog(f,title,mess1,mess2,defaultButton,str1,str2,str3) three buttons

package Widgets105;
import java.awt.*;
import Widgets105.*;

public class MyDialog extends Dialog   // uses non OO buttons
{
   public final static int NO_DEFAULT=    0;
   public final static int BUTTON_ONE=    1;
   public final static int BUTTON_TWO=    2;
   public final static int BUTTON_THREE=  3;
   public final static int MIN_DEFAULT=   NO_DEFAULT;
   public final static int MAX_DEFAULT=   BUTTON_THREE;
   public final static Point  p= new Point(30,30);
   
   TabButton buttonOne, buttonTwo, buttonThree;
   DialogInterface di;
   Frame f;
   int maxButton=0;
   String title= "Dialog Box";
    
   public MyDialog(Frame f)
   {
      this(f, "Dialog Box", null, null, BUTTON_ONE, null, null, null);
   }
   
   public MyDialog(Frame f, String title)
   {
      this(f, title, null, null, BUTTON_ONE, null, null, null);
   }
   
   public MyDialog(Frame f, String title, String mess1)
   {
      this(f, title, mess1, null, BUTTON_ONE, null, null, null);
   }
   
   public MyDialog(Frame f, String title, String mess1, String mess2)
   {
      this(f, title, mess1, mess2, BUTTON_ONE, null, null, null);
   }
   
   public MyDialog(Frame f, String title, String mess1, String mess2,
       int defaultButton)
   {
      this(f, title, mess1, mess2, defaultButton, null, null, null);
   }
   
   public MyDialog(Frame f, String title, String mess1, String mess2,
      int defaultButton, String str1)
   {
      this(f, title, mess1, mess2, defaultButton, str1, null, null);
   }
     
   public MyDialog(Frame f, String title, String mess1, String mess2,
       int defaultButton, String str1, String str2)
   {
      this(f, title, mess1, mess2, defaultButton, str1, str2, null);
   }
   
   public MyDialog(Frame f, String title, String mess1, String mess2,
       int defaultButton, String str1, String str2, String str3)
   {
      super(f, title, true);
      this.di= (DialogInterface)f;
      this.f= f;
      if (title != null) this.title= title;
      if ((defaultButton<MIN_DEFAULT) || (defaultButton>MAX_DEFAULT))
      {defaultButton= NO_DEFAULT;}
      if (mess1 == null) mess1= "CONFIRM";
      if (mess2 == null) mess2= "?";
      maxButton= 3;
      if (str3 == null) maxButton= 2;
      if (str2 == null) maxButton= 1;
      if (str1 == null) 
      {
         maxButton= 1;
         str1= "OK";
      }
      if (defaultButton>maxButton) defaultButton= NO_DEFAULT;
      setLayout(new GridLayout(3,1));       
      add(new Label(mess1,Label.CENTER));
      add(new Label(mess2,Label.CENTER));
      Panel pl= new Panel(); 
      pl.add(buttonOne= new TabButton(str1));
      if (maxButton>1) pl.add(buttonTwo= new TabButton(str2));
      if (maxButton>2) pl.add(buttonThree= new TabButton(str3));
      add(pl);
      TabInterface[] ti= new TabInterface[maxButton];
      TabButton target= buttonOne;
      for (int i=0; i<ti.length; i++)
      {
         if ((i==1)&&(buttonTwo!=null)) target= buttonTwo;
         if ((i==2)&&(buttonThree!=null)) target= buttonThree;
         ti[i]= target;
      }
      TabMethods.SetTabComponents(ti);  // set tab order
      this.resize(400,400);
      this.pack();
      Point l= location();
      if ((l.x<30)||(l.y<30)) this.move(p.x,p.y);
      this.show();
      switch (defaultButton)
      {
         case BUTTON_THREE:
            buttonThree.requestFocus();
            break;
         case BUTTON_TWO:
            buttonTwo.requestFocus();
            break;
         case BUTTON_ONE:
            buttonOne.requestFocus();
            break;
         // NO_DEFAULT
      }
   }
   
   public boolean handleEvent(Event event)
   {
      if (event.id == Event.WINDOW_DESTROY)
      {
         if (this.isShowing()) this.hide();
         di.DoDestroy(title);
         //this.dispose(); // calling class should dispose()
         return true;
      }    
      return super.handleEvent(event);
   }
   
   public boolean keyDown(Event event, int key)
   {
      switch(key)
      {
         case '\n':
         case '\r':   // return key down
            if (event.target instanceof TabButton) // button has focus
            {
               if(event.target==buttonOne)
               {
                  if (this.isShowing()) this.hide();
                  di.ButtonOne(buttonOne.getLabel()); // event is key press
               }   
               else if(event.target==buttonTwo)
               {
                  if (this.isShowing()) this.hide();
                  di.ButtonTwo(buttonTwo.getLabel());
               }
               else if(event.target==buttonThree) 
               {
                  if (this.isShowing()) this.hide();
                  di.ButtonThree(buttonThree.getLabel());
               }
               return true;
            }
         default:
            return super.keyDown(event, key);
      }
   }
   
   public boolean action(Event event, Object obj)
   {
      if (event.target == buttonOne)
      {
            if (this.isShowing()) this.hide();
            di.ButtonOne((String)event.arg);   
            return true;   
      }
      if (event.target == buttonTwo)
      {
           
            if (this.isShowing()) this.hide();
            di.ButtonTwo((String)event.arg);
            return true;   
      }
      if (event.target == buttonThree)
      {
            if (this.isShowing()) this.hide();
            di.ButtonThree((String)event.arg);
            return true;   
      }
      return super.action(event, obj);
   }
}
