// file TabButton.java
// jlouie 9.96
// extend Button to implement generic tab behavior
// implements the TabInterface
// theButton.requestFocus is not supported under Mac JDK 1.02

package Widgets105;

import java.awt.*;
import Widgets105.*;

public class TabButton extends Button implements TabInterface
{
   private Component nextComponent= (Component)this;
   private Component prevComponent= (Component)this;
   
   public TabButton(String label)
   {super(label);}
   
   // implement TabInterface methods 
   // will loop forever if no TabInterface Component isEnabled
   // disabled buttons are skipped
   
   public void RequestFocusFoward()
   {
      if (this.isEnabled()) this.requestFocus();
      else
      {
         if (nextComponent instanceof TabInterface) 
         {((TabInterface)nextComponent).RequestFocusFoward();}
      }
   }
    
   public void RequestFocusReverse()
   {
      if (this.isEnabled()) this.requestFocus();
      else
      {
         if (prevComponent instanceof TabInterface) 
         {((TabInterface)prevComponent).RequestFocusReverse();}
      }
   }
   
   public void SetNextComponent(TabInterface ti)
   {
      if (ti instanceof Component)
      {this.nextComponent= (Component)ti;}
   }
   
   public void SetPrevComponent(TabInterface ti)
   {
      if (ti instanceof Component)
      {this.prevComponent= (Component)ti;}
   }
   
   public Component GetNextComponent()
   {return this.nextComponent;}
   
   public Component GetPrevComponent()
   {return this.prevComponent;}
    
   // overide event handlers to trap tab key
   
   public boolean keyDown(Event event, int key)
   {
      if (key == '\t')
      {
            if (event.shiftDown())
            {
               if ((prevComponent != null) &&
                   (prevComponent instanceof TabInterface))
               {((TabInterface)prevComponent).RequestFocusReverse();}
            }
            else
            {
               if ((nextComponent != null) &&
                   (nextComponent instanceof TabInterface))
               {((TabInterface)nextComponent).RequestFocusFoward();}
            }
      }
      return super.keyDown(event, key);
   } 
  
}
