//=====================================================================
//
// class * TabTextField * v1.05 9.96 jlouie
// supports generic tab behavior between different components
// tabbing is forwarded if this component is not editable or not showing!
// this version does _not_ trap the return key
// we extend TextField to implement OO tab key behavior and KeyFilters
// note:
// public TabTextField(String str, int col) default NO_KEY_FILTER
// public TabTextField(String str, int col, int keyFilter) not a customKey
// if keyFilter= CUSTOM_KEY and customKey == null default is NO_KEY_FILTER
// public TabTextField(String str, int col, int keyFilter, String customKey)
// if keyFilter= CUSTOM_KEY and customKey= "", no input allowed.
//
//=====================================================================
 
package Widgets105;
import java.awt.*;
import Widgets105.*;

public class TabTextField extends TextField implements TabInterface
{
   private Component nextComponent= (Component)this;     // note use of generic Component
   private Component prevComponent= (Component)this;
   private int keyFilter;
   private String customKey= "";
   
   public static final int NO_KEY_FILTER=       0;        // keyFilter Constants
   public static final int NUMERIC_ONLY=        1;
   public static final int DIGITS_ONLY=         2;
   public static final int PHONE_ONLY=          3;
   public static final int SIGNED_NUMERIC_ONLY= 4;
   public static final int CUSTOM_KEY=          5;
   public static final int MIN_KEY=             0;
   public static final int MAX_KEY=             CUSTOM_KEY;
   
   // implement TabInterface methods
   
   // will loop forever if no TabInterface Component isEnabled!
   
   public void RequestFocusFoward()
   {
      // skip component if not editable or visible
      if ((this.isEditable()) && (this.isShowing())) 
      {
         this.requestFocus();
         this.selectAll();
      }
      else
      {
         if (nextComponent instanceof TabInterface) 
         {((TabInterface)nextComponent).RequestFocusFoward();}
      }
   }
   
   public void RequestFocusReverse()
   {
      if ((this.isEditable()) && (this.isShowing()))
      {
         this.requestFocus();
         this.selectAll();
      }
      else
      {
         if (prevComponent instanceof TabInterface) 
         {((TabInterface)prevComponent).RequestFocusReverse();}
      }
   }
   
   public void SetNextComponent(TabInterface ti)
   {
      if (ti instanceof Component)
      {this.nextComponent= (Component)ti;}
   }
   
   public void SetPrevComponent(TabInterface ti)
   {
      if (ti instanceof Component)
      {this.prevComponent= (Component)ti;}
   }
   
   public Component GetNextComponent()
   {return this.nextComponent;}
   
   public Component GetPrevComponent()
   {return this.prevComponent;}
   
   //  overloaded constructor, default NO_KEY_FILTER
   
   public TabTextField(String str, int col)
   {
      this(str, col, NO_KEY_FILTER, null);  
   }


   public TabTextField(String str, int col, int keyFilter)
   {
      this(str, col, keyFilter, null);
   }
   
   public TabTextField(String str, int col, int keyFilter, String customKey)
   {
      super(str, col);           
      if (((keyFilter<MIN_KEY) || (keyFilter>MAX_KEY)) || 
         ((keyFilter == CUSTOM_KEY) && (customKey == null)))
      {
         this.keyFilter= NO_KEY_FILTER;
         this.customKey= "";
      }
      else
      {
         this.keyFilter= keyFilter;
         this.customKey= customKey;
      }
   }
   
   //================================
   //
   // * keyDown *
   //
   // override keyDown to trap tabs, return
   // & implement KeyFilters
   //
   //================================
   
   public boolean keyDown(Event evt, int key)
   {
      switch (key)
      {
         case '\b':        // backspace
         case '\n':        // ** fall through **
         case '\r':        // ** fall through **
            break;         // pass to super.keyDown()
         case '\t':                 
            //if ((evt.modifiers & Event.SHIFT_MASK) == Event.SHIFT_MASK)
            if (evt.shiftDown()) // traps shift and option-shift etc.
            {
               if (prevComponent != null)
               {
                  if (prevComponent instanceof TabInterface)
                  {((TabInterface)prevComponent).RequestFocusReverse();} 
                  return true;      
               }              
            }
            else
            {
               if (nextComponent != null) 
               {
                  if (nextComponent instanceof TabInterface)
                  {((TabInterface)nextComponent).RequestFocusFoward();}
                  return true;      
               }
            }
            break;  // not handled, pass to super
         default: // not tab or backspace
            switch(keyFilter)
            {
               case DIGITS_ONLY:
                  if (! IsDigit(key)) return true;    // handle & ignore key input
                  break;                              // pass to super
               case NUMERIC_ONLY:
                  if (! IsNumeric(key)) return true;  // handle & ignore key input
                  break;
               case PHONE_ONLY:
                  if (! IsPhone(key)) return true;
                  break;
               case CUSTOM_KEY:
                  if (! IsCustom(key)) return true;
                  break;
               case SIGNED_NUMERIC_ONLY:
                  if (! IsSignedNumeric(key)) return true;
                  break;                              
               // NO_KEY_FILTER, pass to super
            } 
      }
      return super.keyDown(evt, key);
   }
   
   // custom
   public boolean IsCustom(int key)
   {
    if (customKey == null){return false;}
    for (int i=0; i<customKey.length(); i++)
    {
      if (key == (int)customKey.charAt(i))
      {return true;}
    }
    return false;
   }
   
   // {0 to 9}
   public boolean IsDigit(int key)
   {
      if (((key < '0') || (key >'9')) ) return false;
      else return true;
   }
  
   // {.,0 to 9}
   public boolean IsNumeric(int key)
   {  
      switch(key)
      {
         case '.':
         case ',':
            return true;
         default:
            return IsDigit(key);
      }
   }
   
   // {-.,0 to 9}
   public boolean IsSignedNumeric(int key)
   {  
      switch(key)
      {
         case '-':
            return true;
         default:
            return IsNumeric(key);
      }
   }
   
   // {- 0 to 9}
   public boolean IsPhone(int key)
   {
      switch(key)
      {
         case '-':
            return true;
         default:
            return IsDigit(key);
      }
   }
}
