////////////////////////////////////////////////////////////////////////////
// Program: TextEdit.java
//    Date: Jan 15, 1996
//  Author: Anil Hemrajani
// Purpose: Text File Editor (Demo JAVA)
/////////////////////////////////////////////////////////////////////////////

import java.io.*;
import java.lang.*;
import java.util.*;
import java.awt.*;
import java.applet.Applet;


class TextEdit extends Frame
{
   TextArea t;
   String MI_OPEN="Open...", MI_SAVE="Save", MI_EXIT="Exit";

   public TextEdit(String filename)
   {
       MenuBar mb = new MenuBar();
       Menu    m  = new Menu("File");
       m.add(new MenuItem(MI_OPEN));
       m.add(new MenuItem(MI_SAVE));
       m.add(new MenuItem(MI_EXIT));
       mb.add(m);
       setMenuBar(mb);

       Panel cp = new Panel();
       Panel p  = new Panel();
       cp.setLayout(new GridLayout(1,2));
       p.setLayout (new BorderLayout());
       t = new TextArea(30, 80);
       t.setFont(new Font("Courier", Font.PLAIN, 12));
       p.add("Center", t);
       cp.add(p);

       Panel bp = new Panel();
       bp.add(new Button(MI_OPEN));
       bp.add(new Button(MI_SAVE));
       bp.add(new Button(MI_EXIT));
       bp.setLayout(new FlowLayout(FlowLayout.CENTER));

       setLayout(new BorderLayout());
       add("Center", cp);
       add("South", bp);

       if (filename != null)
       {
           try { ViewFile view = new ViewFile(filename, t);
                 setTitle(filename);
               }
           catch (IOException e)
           { System.err.println("Unable to create ViewFile"); }
       }
   }

   public boolean handleEvent(Event evt)
   {
       if (evt.id == Event.WINDOW_DESTROY)
           System.exit(0);
 
       if (evt.id == Event.ACTION_EVENT &&
           (evt.target instanceof MenuItem ||
            evt.target instanceof Button))
       {   String menuLabel = (String)evt.arg;
           if (menuLabel.equals(MI_OPEN))
           {
               FileDialog fd = new FileDialog(this, "Open a File");
               fd.show();

               if (fd.getFile() != null)
               {
                   String filename=
                          new String(fd.getDirectory() + "/" + fd.getFile());
                   try ViewFile view = new ViewFile(filename, t);
                       catch (IOException e)
                       { System.err.println("IOException"); }
                   setTitle(filename);
               }
           }
           if (menuLabel.equals(MI_SAVE))
           {
              try SaveFile save = new SaveFile(getTitle(), t);
                  catch (IOException e)
                  { System.err.println("IOException"); }
           }
           if (menuLabel.equals(MI_EXIT))
              System.exit(0);
           return true;
       }
       return super.handleEvent(evt);
   }

   public static void main(String args[])
   {
       TextEdit g;
       if (args.length > 0)
          g=new TextEdit(args[0]);
       else
          g=new TextEdit((String)null);

       g.setTitle("Text Editor");
       g.pack();
       g.show();
   }
}


class ViewFile
{
   ViewFile(String FileName, TextArea t) throws IOException
   {
      FileInputStream fis;
      StringBuffer sb = new StringBuffer();

      try {
            fis = new FileInputStream(FileName);
            int onechar;

            while ((onechar=fis.read()) != -1)
               sb.append((char)onechar);
            fis.close();
            t.setText(sb.toString());
      }
      catch (IOException e)
      {  System.err.println ("IOException in ViewFile");
      }
   }
}


class SaveFile
{
   SaveFile(String FileName, TextArea t) throws IOException
   {
      FileOutputStream fos;
      StringBuffer sb = new StringBuffer();
      sb.append(t.getText());
      int i;

      try {
            fos = new FileOutputStream(FileName);
            for (i=0; i < sb.length(); i++)
                 fos.write(sb.charAt(i));
            fos.close();
      }
      catch (IOException e)
      {  System.err.println ("IOException in SaveFile");
      }
   }
}
