include graphics.e
include image.e
include bitmap.e

-- << bm_demo2.ex >> -- demonstration of displaying an irregular-shaped image
--                      over a graphic background
-- Colin Taylor - 71630.1776@compuserve.com
-- version 1.0 - 6/1/97

sequence image, mask, size, back
integer back_color

if graphics_mode(18) then
    puts(2, "need graphics mode 18\n")
    abort(1)
end if

-- make a random background graphic
polygon(7, 1, {{0, 0}, {639, 0}, {639, 479}, {0, 479}})
for x = 1 to 100 do
    draw_line(rand(15), {{rand(638), rand(478)}, {rand(638), rand(478)}})
end for

image = bm_load("bm2.bm")
display_image({20,30},image)  -- display bitmap before manipulation

    text_color(15)
    position(1, 3)
    puts(1, " Method of displaying an irregular-shaped image over a " &
		"background image: ")
    position(3, 30)
    puts(1, " original image (red on green background) ")
    
-- If you don't know the background color of the image, then sample it.
back_color = image[4][4]
-- or, to sample from the screen use:  back_color = get_pixel({203, 23})

-- Create a "mask" image by substituting 1 (TRUE) for the background color,
-- and 0 (FALSE) for any other color.
mask = (image=back_color)

-- If you don't know the size of the image, the use bm_size to determine it.
size = bm_size(image)

    -- let's see our progress...
    display_image({20, 110}, mask)
    position(8, 30)
    puts(1, " negative mask image (black=0, blue=1) ")

-- make a copy of the background image where you plan to display image.
-- it has to be the same size as the image to be displayed.
back = save_image({20, 190}, {20, 190}+size-1)

-- erase the portion of the background image corresponding with the 
-- foreground image area of image
back = back*mask

    display_image({20, 190}, back)
    position(13, 30)
    puts(1, " masked background image (black=0) ")

-- erase the background color of image 
image = image*(not mask)

    display_image({20, 270}, image)
    position(18, 30)
    puts(1, " image with background color masked (black=0) ")

    -- for this demo, we have to repeat previous steps involving 
    -- background image, because of the change in screen position
    back = save_image({20, 350}, {20, 350}+size-1)
    back = back*mask

-- add the foreground image to the background image
image = back+image

    display_image({20, 350}, image)
    position(23, 30)
    puts(1, " combined foreground and background images ")
    position(25, 39)
    puts(1, " press a key to end... ")

-- Note: Usually you should contrive to have the transparent portion
-- of the image as color 0 (black).  This simplifies the procedure to:
--      back = save_image({...})
--      mask = not image
--      back = back*mask
--      image = back+image
--      display_image({...}, image)
--
--  or, in more compact form:
--      back = save_image({...})
--      display_image({...}, back*(not image)+image)

while get_key() = -1 do
end while

if graphics_mode(-1) then
end if

